/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.TabOutScopesTracker;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BraceOrQuoteOutAction
extends EditorAction {
    public BraceOrQuoteOutAction() {
        super((EditorActionHandler)new Handler());
    }

    private static class Handler
    extends EditorActionHandler {
        private Handler() {
            super(true);
        }

        protected boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
            int caretOffset = caret.getOffset();
            return TabOutScopesTracker.getInstance().hasScopeEndingAt(editor, caretOffset);
        }

        protected void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
            assert (caret != null);
            int caretOffset = caret.getOffset();
            if (TabOutScopesTracker.getInstance().removeScopeEndingAt(editor, caretOffset)) {
                caret.moveToOffset(caretOffset + 1);
            }
        }
    }
}

