/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.lang.CodeDocumentationAwareCommenter;
import com.intellij.lang.Commenter;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.DocCommentSettings;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeDocumentationUtil {
    private CodeDocumentationUtil() {
    }

    @Deprecated
    public static String createDocCommentLine(String lineData, Project project, CodeDocumentationAwareCommenter commenter) {
        return CodeDocumentationUtil.createLine(lineData, commenter, DocCommentSettings.DEFAULTS);
    }

    public static String createDocCommentLine(String lineData, PsiFile file2, CodeDocumentationAwareCommenter commenter) {
        DocCommentSettings settings = CodeStyleManager.getInstance((Project)file2.getProject()).getDocCommentSettings(file2);
        return CodeDocumentationUtil.createLine(lineData, commenter, settings);
    }

    @NotNull
    private static String createLine(String lineData, CodeDocumentationAwareCommenter commenter, DocCommentSettings settings) {
        if (!settings.isLeadingAsteriskEnabled()) {
            return " " + lineData + " ";
        }
        if (lineData.length() == 0) {
            return commenter.getDocumentationCommentLinePrefix() + " ";
        }
        return commenter.getDocumentationCommentLinePrefix() + " " + lineData + " ";
    }

    @Nullable
    public static String getIndentInsideJavadoc(@NotNull Document document, int offset) {
        CharSequence text = document.getCharsSequence();
        if (offset >= text.length()) {
            return null;
        }
        int line = document.getLineNumber(offset);
        int lineStartOffset = document.getLineStartOffset(line);
        int lineEndOffset = document.getLineEndOffset(line);
        int i = CharArrayUtil.shiftForward((CharSequence)text, (int)lineStartOffset, (String)" \t");
        if (i > lineEndOffset || text.charAt(i) != '*') {
            return null;
        }
        int start2 = i + 1;
        int end = CharArrayUtil.shiftForward((CharSequence)text, (int)start2, (String)" \t");
        return (end = Math.min(end, lineEndOffset)) > start2 ? text.subSequence(start2, end).toString() : "";
    }

    @NotNull
    public static CommentContext tryParseCommentContext(@NotNull PsiFile file2, @NotNull CharSequence chars, int offset, int lineStartOffset) {
        Commenter langCommenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(PsiUtilCore.getLanguageAtOffset((PsiFile)file2, (int)offset));
        return CodeDocumentationUtil.tryParseCommentContext(langCommenter, chars, lineStartOffset);
    }

    static CommentContext tryParseCommentContext(@Nullable Commenter langCommenter, @NotNull CharSequence chars, int lineStartOffset) {
        boolean isInsideCommentLikeCode = langCommenter instanceof CodeDocumentationAwareCommenter;
        if (!isInsideCommentLikeCode) {
            return new CommentContext();
        }
        CodeDocumentationAwareCommenter commenter = (CodeDocumentationAwareCommenter)langCommenter;
        int commentStartOffset = CharArrayUtil.shiftForward((CharSequence)chars, (int)lineStartOffset, (String)" \t");
        boolean docStart = commenter.getDocumentationCommentPrefix() != null && CharArrayUtil.regionMatches((CharSequence)chars, (int)commentStartOffset, (CharSequence)commenter.getDocumentationCommentPrefix());
        boolean docAsterisk = commenter.getDocumentationCommentLinePrefix() != null && CharArrayUtil.regionMatches((CharSequence)chars, (int)commentStartOffset, (CharSequence)commenter.getDocumentationCommentLinePrefix());
        return new CommentContext(commenter, docStart, docAsterisk, commentStartOffset);
    }

    public static class CommentContext {
        public final CodeDocumentationAwareCommenter commenter;
        public final int lineStart;
        public boolean docStart;
        public boolean docAsterisk;

        public CommentContext() {
            this.commenter = null;
            this.lineStart = 0;
        }

        public CommentContext(CodeDocumentationAwareCommenter commenter, boolean docStart, boolean docAsterisk, int lineStart) {
            this.docStart = docStart;
            this.docAsterisk = docAsterisk;
            this.commenter = commenter;
            this.lineStart = lineStart;
        }
    }
}

