/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.impl.CompletionServiceImpl;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class CompletionAutoPopupHandler
extends TypedHandlerDelegate {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.editorActions.CompletionAutoPopupHandler");
    public static volatile Key<Boolean> ourTestingAutopopup = Key.create((String)"TestingAutopopup");

    @NotNull
    public TypedHandlerDelegate.Result checkAutoPopup(char charTyped, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        LookupImpl lookup = (LookupImpl)LookupManager.getActiveLookup(editor);
        if (LOG.isDebugEnabled()) {
            LOG.debug("checkAutoPopup: character=" + charTyped + ";");
            LOG.debug("phase=" + CompletionServiceImpl.getCompletionPhase());
            LOG.debug("lookup=" + lookup);
            LOG.debug("currentCompletion=" + CompletionServiceImpl.getCompletionService().getCurrentCompletion());
        }
        if (lookup != null) {
            if (editor.getSelectionModel().hasSelection()) {
                lookup.performGuardedChange(() -> EditorModificationUtil.deleteSelectedText((Editor)editor));
            }
            return TypedHandlerDelegate.Result.STOP;
        }
        if (Character.isLetterOrDigit(charTyped) || charTyped == '_') {
            AutoPopupController.getInstance(project).scheduleAutoPopup(editor);
            return TypedHandlerDelegate.Result.STOP;
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    @Deprecated
    public static void runLaterWithCommitted(@NotNull Project project, Document document, @NotNull Runnable runnable2) {
        AutoPopupController.runTransactionWithEverythingCommitted(project, runnable2);
    }
}

