/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandlerBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttlistDecl;
import com.intellij.psi.xml.XmlElementDecl;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DtdSelectioner
extends ExtendWordSelectionHandlerBase {
    @Override
    public boolean canSelect(@NotNull PsiElement e) {
        return e instanceof XmlAttlistDecl || e instanceof XmlElementDecl;
    }

    @Override
    public List<TextRange> select(@NotNull PsiElement e, @NotNull CharSequence editorText, int cursorOffset, @NotNull Editor editor) {
        PsiElement[] children2 = e.getChildren();
        XmlToken first = null;
        XmlToken last = null;
        for (PsiElement child2 : children2) {
            if (!(child2 instanceof XmlToken)) continue;
            XmlToken token = (XmlToken)child2;
            if (token.getTokenType() == XmlTokenType.XML_TAG_END) {
                last = token;
                break;
            }
            if (token.getTokenType() != XmlTokenType.XML_ELEMENT_DECL_START && token.getTokenType() != XmlTokenType.XML_ATTLIST_DECL_START) continue;
            first = token;
        }
        ArrayList<TextRange> result2 = new ArrayList<TextRange>(1);
        if (first != null && last != null) {
            int offset = last.getTextRange().getEndOffset() + 1;
            result2.addAll(ExtendWordSelectionHandlerBase.expandToWholeLine(editorText, new TextRange(first.getTextRange().getStartOffset(), offset < editorText.length() ? offset : editorText.length()), false));
        }
        return result2;
    }
}

