/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.application.options.editor.WebEditorOptions;
import com.intellij.codeInsight.editorActions.SelectWordUtil;
import com.intellij.codeInsight.editorActions.XmlTokenSelectioner;
import com.intellij.codeInsight.editorActions.wordSelection.AbstractWordSelectioner;
import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.HtmlUtil;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlSelectioner
extends AbstractWordSelectioner {
    private static final SelectWordUtil.CharCondition JAVA_IDENTIFIER_AND_HYPHEN_CONDITION = ch -> Character.isJavaIdentifierPart(ch) || ch == '-';

    @Override
    public boolean canSelect(@NotNull PsiElement e) {
        return HtmlSelectioner.canSelectElement(e);
    }

    static boolean canSelectElement(PsiElement e) {
        if (e instanceof XmlToken) {
            return HtmlUtil.hasHtml(e.getContainingFile()) || HtmlUtil.supportsXmlTypedHandlers(e.getContainingFile());
        }
        return false;
    }

    @Override
    public List<TextRange> select(@NotNull PsiElement e, @NotNull CharSequence editorText, int cursorOffset, @NotNull Editor editor) {
        ArrayList result2 = !(e instanceof XmlToken) || XmlTokenSelectioner.shouldSelectToken((XmlToken)e) || ((XmlToken)e).getTokenType() == XmlTokenType.XML_DATA_CHARACTERS ? super.select(e, editorText, cursorOffset, editor) : ContainerUtil.newArrayList();
        PsiElement parent = e.getParent();
        if (parent instanceof XmlComment) {
            result2.addAll(HtmlSelectioner.expandToWholeLine(editorText, parent.getTextRange(), true));
        }
        PsiFile psiFile = e.getContainingFile();
        this.addAttributeSelection(result2, editor, cursorOffset, editorText, e);
        FileViewProvider fileViewProvider = psiFile.getViewProvider();
        for (Language lang : fileViewProvider.getLanguages()) {
            PsiFile langFile = fileViewProvider.getPsi(lang);
            if (langFile == psiFile) continue;
            this.addAttributeSelection(result2, editor, cursorOffset, editorText, fileViewProvider.findElementAt(cursorOffset, lang));
        }
        EditorHighlighter highlighter = HighlighterFactory.createHighlighter((Project)e.getProject(), (VirtualFile)psiFile.getVirtualFile());
        highlighter.setText(editorText);
        HtmlSelectioner.addTagSelection2(e, result2);
        return result2;
    }

    private static void addTagSelection2(PsiElement e, List<? super TextRange> result2) {
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)e, XmlTag.class, (boolean)true);
        while (tag != null) {
            result2.add((TextRange)tag.getTextRange());
            ASTNode tagStartEnd = XmlChildRole.START_TAG_END_FINDER.findChild(tag.getNode());
            ASTNode tagEndStart = XmlChildRole.CLOSING_TAG_START_FINDER.findChild(tag.getNode());
            if (tagStartEnd != null && tagEndStart != null) {
                result2.add((TextRange)new UnfairTextRange(tagStartEnd.getTextRange().getEndOffset(), tagEndStart.getTextRange().getStartOffset()));
            }
            if (tagStartEnd != null) {
                result2.add((TextRange)new TextRange(tag.getTextRange().getStartOffset(), tagStartEnd.getTextRange().getEndOffset()));
            }
            if (tagEndStart != null) {
                result2.add((TextRange)new TextRange(tagEndStart.getTextRange().getStartOffset(), tag.getTextRange().getEndOffset()));
            }
            tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)tag, XmlTag.class, (boolean)true);
        }
    }

    private void addAttributeSelection(@NotNull List<? super TextRange> result2, @NotNull Editor editor, int cursorOffset, @NotNull CharSequence editorText, @Nullable PsiElement e) {
        XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)e, XmlAttribute.class);
        if (attribute != null) {
            result2.add((TextRange)attribute.getTextRange());
            XmlAttributeValue value = attribute.getValueElement();
            if (value != null) {
                if (this.getClassAttributeName().equalsIgnoreCase(attribute.getName())) {
                    HtmlSelectioner.addClassAttributeRanges(result2, editor, cursorOffset, editorText, value);
                }
                TextRange range2 = value.getTextRange();
                result2.add((TextRange)range2);
                if (value.getFirstChild() != null && value.getFirstChild().getNode().getElementType() == XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER) {
                    result2.add((TextRange)new TextRange(range2.getStartOffset() + 1, range2.getEndOffset() - 1));
                }
            }
        }
    }

    @Override
    public int getMinimalTextRangeLength(@NotNull PsiElement element, @NotNull CharSequence text, int cursorOffset) {
        if (WebEditorOptions.getInstance().isSelectWholeCssIdentifierOnDoubleClick()) {
            TextRange valueTextRange;
            XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)element, XmlAttribute.class);
            XmlAttributeValue attributeValue = (XmlAttributeValue)PsiTreeUtil.getParentOfType((PsiElement)element, XmlAttributeValue.class);
            if (attribute != null && attributeValue != null && this.getClassAttributeName().equalsIgnoreCase(attribute.getName()) && !(valueTextRange = attributeValue.getValueTextRange()).isEmpty()) {
                int start2;
                int end = cursorOffset;
                for (start2 = cursorOffset; start2 > valueTextRange.getStartOffset() && JAVA_IDENTIFIER_AND_HYPHEN_CONDITION.value(text.charAt(start2 - 1)); --start2) {
                }
                while (end < valueTextRange.getEndOffset() && JAVA_IDENTIFIER_AND_HYPHEN_CONDITION.value(text.charAt(end + 1))) {
                    ++end;
                }
                return end - start2;
            }
        }
        return super.getMinimalTextRangeLength(element, text, cursorOffset);
    }

    @NotNull
    protected String getClassAttributeName() {
        return "class";
    }

    public static void addClassAttributeRanges(@NotNull List<? super TextRange> result2, @NotNull Editor editor, int cursorOffset, @NotNull CharSequence editorText, @NotNull XmlAttributeValue attributeValue) {
        TextRange attributeValueTextRange = attributeValue.getTextRange();
        LinkedList wordRanges = ContainerUtil.newLinkedList();
        SelectWordUtil.addWordSelection(editor.getSettings().isCamelWords(), editorText, cursorOffset, wordRanges, JAVA_IDENTIFIER_AND_HYPHEN_CONDITION);
        for (TextRange range2 : wordRanges) {
            if (!attributeValueTextRange.contains(range2)) continue;
            result2.add((TextRange)range2);
        }
    }
}

