/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.JoinLinesHandlerDelegate;
import com.intellij.codeInsight.editorActions.JoinRawLinesHandlerDelegate;
import com.intellij.ide.DataManager;
import com.intellij.lang.ASTNode;
import com.intellij.lang.CodeDocumentationAwareCommenter;
import com.intellij.lang.Commenter;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NotNullFunction;
import com.intellij.util.text.CharArrayUtil;
import java.awt.Component;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JoinLinesHandler
extends EditorActionHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.editorActions.JoinLinesHandler");
    private final EditorActionHandler myOriginalHandler;

    public JoinLinesHandler(EditorActionHandler originalHandler) {
        super(true);
        this.myOriginalHandler = originalHandler;
    }

    @NotNull
    private static TextRange findStartAndEnd(@NotNull CharSequence text, int start2, int end, int maxoffset) {
        while (start2 > 0 && (text.charAt(start2) == ' ' || text.charAt(start2) == '\t')) {
            --start2;
        }
        while (end < maxoffset && (text.charAt(end) == ' ' || text.charAt(end) == '\t')) {
            ++end;
        }
        return new TextRange(start2, end);
    }

    public void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
        assert (caret != null);
        if (editor.isViewer() || !EditorModificationUtil.requestWriting((Editor)editor)) {
            return;
        }
        if (!(editor.getDocument() instanceof DocumentEx)) {
            this.myOriginalHandler.execute(editor, caret, dataContext);
            return;
        }
        DocumentEx doc = (DocumentEx)editor.getDocument();
        Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)editor.getContentComponent()));
        if (project == null) {
            return;
        }
        PsiDocumentManager docManager = PsiDocumentManager.getInstance((Project)project);
        PsiFile psiFile = docManager.getPsiFile((Document)doc);
        if (psiFile == null) {
            this.myOriginalHandler.execute(editor, caret, dataContext);
            return;
        }
        LogicalPosition caretPosition = caret.getLogicalPosition();
        int startLine = caretPosition.line;
        int endLine = startLine + 1;
        if (caret.hasSelection()) {
            startLine = doc.getLineNumber(caret.getSelectionStart());
            endLine = doc.getLineNumber(caret.getSelectionEnd());
            if (doc.getLineStartOffset(endLine) == caret.getSelectionEnd()) {
                --endLine;
            }
        }
        int startReformatOffset = CharArrayUtil.shiftBackward((CharSequence)doc.getCharsSequence(), (int)doc.getLineEndOffset(startLine), (String)" \t");
        int lineCount = endLine - startLine;
        int line = startLine;
        ((ApplicationImpl)ApplicationManager.getApplication()).runWriteActionWithCancellableProgressInDispatchThread("Join Lines", project, null, (Consumer<? super ProgressIndicator>)((Consumer)indicator -> {
            indicator.setIndeterminate(false);
            Ref caretRestoreOffset = new Ref((Object)-1);
            CodeEditUtil.setNodeReformatStrategy((NotNullFunction<ASTNode, Boolean>)((NotNullFunction)node -> node.getTextRange().getStartOffset() >= startReformatOffset));
            try {
                int afterLines;
                int beforeLines;
                for (int count = 0; count < lineCount; count += Math.max(beforeLines - afterLines, 1)) {
                    indicator.checkCanceled();
                    indicator.setFraction((double)count / (double)lineCount);
                    beforeLines = doc.getLineCount();
                    ProgressManager.getInstance().executeNonCancelableSection(() -> JoinLinesHandler.doJoinTwoLines(doc, project, docManager, psiFile, line, (Ref<Integer>)caretRestoreOffset));
                    afterLines = doc.getLineCount();
                }
            }
            finally {
                CodeEditUtil.setNodeReformatStrategy(null);
            }
            JoinLinesHandler.positionCaret(editor, caret, (Integer)caretRestoreOffset.get());
        }));
    }

    private static void positionCaret(Editor editor, Caret caret, int caretRestoreOffset) {
        if (caret.hasSelection()) {
            caret.moveToOffset(caret.getSelectionEnd());
        } else if (caretRestoreOffset != -1) {
            caret.moveToOffset(caretRestoreOffset);
            if (caret == editor.getCaretModel().getPrimaryCaret()) {
                editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            }
            caret.removeSelection();
        }
    }

    private static void doJoinTwoLines(@NotNull DocumentEx doc, @NotNull Project project, @NotNull PsiDocumentManager docManager, @NotNull PsiFile psiFile, int startLine, Ref<Integer> caretRestoreOffset) {
        int replaceStart;
        if (startLine >= doc.getLineCount() - 1) {
            return;
        }
        docManager.doPostponedOperationsAndUnblockDocument((Document)doc);
        docManager.commitDocument((Document)doc);
        CharSequence text = doc.getCharsSequence();
        JoinLinesOffsets offsets = JoinLinesHandler.calcJoinLinesOffsets(psiFile, doc, startLine);
        if (offsets.isStartLineEndsWithComment() && !offsets.isNextLineStartsWithComment()) {
            JoinLinesHandler.tryConvertEndOfLineComment(doc, offsets.elementAtStartLineEnd);
            offsets = JoinLinesHandler.calcJoinLinesOffsets(psiFile, doc, startLine);
        }
        TextRange limits = JoinLinesHandler.findStartAndEnd(text, offsets.lastNonSpaceOffsetInStartLine, offsets.firstNonSpaceOffsetInNextLine, doc.getTextLength());
        int start2 = limits.getStartOffset();
        int end = limits.getEndOffset();
        int rc = -1;
        for (JoinLinesHandlerDelegate delegate : JoinLinesHandlerDelegate.EP_NAME.getExtensionList()) {
            if (!(delegate instanceof JoinRawLinesHandlerDelegate) || (rc = ((JoinRawLinesHandlerDelegate)delegate).tryJoinRawLines((Document)doc, psiFile, start2, end)) == -1) continue;
            caretRestoreOffset.set((Object)JoinLinesHandler.checkOffset(rc, delegate, doc));
            break;
        }
        if (rc == -1) {
            JoinLinesHandlerDelegate delegate;
            if (offsets.lastNonSpaceOffsetInStartLine == doc.getLineStartOffset(startLine)) {
                doc.deleteString(doc.getLineStartOffset(startLine), offsets.firstNonSpaceOffsetInNextLine);
                int indent = -1;
                try {
                    docManager.commitDocument((Document)doc);
                    indent = CodeStyleManager.getInstance((Project)project).adjustLineIndent(psiFile, startLine == 0 ? 0 : doc.getLineStartOffset(startLine));
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
                if ((Integer)caretRestoreOffset.get() == -1) {
                    caretRestoreOffset.set((Object)indent);
                }
                return;
            }
            doc.deleteString(offsets.lineEndOffset, offsets.lineEndOffset + doc.getLineSeparatorLength(startLine));
            text = doc.getCharsSequence();
            limits = JoinLinesHandler.findStartAndEnd(text, offsets.lineEndOffset - 1, offsets.lineEndOffset, doc.getTextLength());
            start2 = limits.getStartOffset();
            end = limits.getEndOffset();
            docManager.commitDocument((Document)doc);
            Iterator indent = JoinLinesHandlerDelegate.EP_NAME.getExtensionList().iterator();
            while (indent.hasNext() && (rc = JoinLinesHandler.checkOffset((delegate = (JoinLinesHandlerDelegate)indent.next()).tryJoinLines((Document)doc, psiFile, start2, end), delegate, doc)) == -1) {
            }
        }
        if (rc != -1) {
            RangeMarker marker = doc.createRangeMarker(rc, rc);
            docManager.doPostponedOperationsAndUnblockDocument((Document)doc);
            rc = marker.getStartOffset();
            if ((Integer)caretRestoreOffset.get() == -1) {
                caretRestoreOffset.set((Object)rc);
            }
            return;
        }
        docManager.doPostponedOperationsAndUnblockDocument((Document)doc);
        int n = replaceStart = start2 == offsets.lineEndOffset ? start2 : start2 + 1;
        if ((Integer)caretRestoreOffset.get() == -1) {
            caretRestoreOffset.set((Object)replaceStart);
        }
        if (offsets.isStartLineEndsWithComment() && offsets.isNextLineStartsWithComment()) {
            boolean adjacentLineComments = false;
            if (text.charAt(end) == '*' && end < text.length() && text.charAt(end + 1) != '/') {
                ++end;
                while (end < doc.getTextLength() && (text.charAt(end) == ' ' || text.charAt(end) == '\t')) {
                    ++end;
                }
            } else if (!(offsets.isJoiningSameComment() || replaceStart >= 2 && text.charAt(replaceStart - 2) == '*' && text.charAt(replaceStart - 1) == '/' || text.charAt(end) != '/' || end + 1 >= text.length() || text.charAt(end + 1) != '/')) {
                adjacentLineComments = true;
                end += 2;
                while (end < doc.getTextLength() && (text.charAt(end) == ' ' || text.charAt(end) == '\t')) {
                    ++end;
                }
            }
            doc.replaceString(replaceStart, end, adjacentLineComments || offsets.isJoiningSameComment() ? " " : "");
            return;
        }
        while (end < doc.getTextLength() && (text.charAt(end) == ' ' || text.charAt(end) == '\t')) {
            ++end;
        }
        int spacesToCreate = CodeStyleManager.getInstance((Project)project).getSpacing(psiFile, end);
        if (spacesToCreate < 0) {
            spacesToCreate = 1;
        }
        String spacing = StringUtil.repeatSymbol((char)' ', (int)spacesToCreate);
        doc.replaceString(replaceStart, end, spacing);
        docManager.commitDocument((Document)doc);
        if (start2 <= doc.getLineStartOffset(startLine)) {
            try {
                docManager.commitDocument((Document)doc);
                CodeStyleManager.getInstance((Project)project).adjustLineIndent(psiFile, doc.getLineStartOffset(startLine));
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
        docManager.commitDocument((Document)doc);
    }

    private static int checkOffset(int offset, JoinLinesHandlerDelegate delegate, DocumentEx doc) {
        if (offset == -1) {
            return offset;
        }
        if (offset < 0) {
            LOG.error("Handler returned negative offset: handler class=" + delegate.getClass() + "; offset=" + offset);
            return 0;
        }
        if (offset > doc.getTextLength()) {
            LOG.error("Handler returned an offset which exceeds the document length: handler class=" + delegate.getClass() + "; offset=" + offset + "; length=" + doc.getTextLength());
            return doc.getTextLength();
        }
        return offset;
    }

    private static JoinLinesOffsets calcJoinLinesOffsets(PsiFile psiFile, Document doc, int startLine) {
        JoinLinesOffsets offsets = new JoinLinesOffsets();
        CharSequence text = doc.getCharsSequence();
        offsets.lineEndOffset = doc.getLineEndOffset(startLine);
        offsets.firstNonSpaceOffsetInNextLine = doc.getLineStartOffset(startLine + 1);
        while (offsets.firstNonSpaceOffsetInNextLine < text.length() - 1 && (text.charAt(offsets.firstNonSpaceOffsetInNextLine) == ' ' || text.charAt(offsets.firstNonSpaceOffsetInNextLine) == '\t')) {
            ++offsets.firstNonSpaceOffsetInNextLine;
        }
        PsiElement elementAtNextLineStart = psiFile.findElementAt(offsets.firstNonSpaceOffsetInNextLine);
        offsets.commentAtLineStart = JoinLinesHandler.getCommentElement(elementAtNextLineStart);
        offsets.lastNonSpaceOffsetInStartLine = offsets.lineEndOffset;
        while (offsets.lastNonSpaceOffsetInStartLine > 0 && (text.charAt(offsets.lastNonSpaceOffsetInStartLine - 1) == ' ' || text.charAt(offsets.lastNonSpaceOffsetInStartLine - 1) == '\t')) {
            --offsets.lastNonSpaceOffsetInStartLine;
        }
        int elemOffset = offsets.lastNonSpaceOffsetInStartLine > doc.getLineStartOffset(startLine) ? offsets.lastNonSpaceOffsetInStartLine - 1 : -1;
        offsets.elementAtStartLineEnd = elemOffset == -1 ? null : psiFile.findElementAt(elemOffset);
        offsets.commentAtLineEnd = JoinLinesHandler.getCommentElement(offsets.elementAtStartLineEnd);
        return offsets;
    }

    private static void tryConvertEndOfLineComment(Document doc, PsiElement commentElement) {
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(commentElement.getLanguage());
        if (commenter instanceof CodeDocumentationAwareCommenter) {
            CodeDocumentationAwareCommenter docCommenter = (CodeDocumentationAwareCommenter)commenter;
            String lineCommentPrefix = commenter.getLineCommentPrefix();
            String blockCommentPrefix = commenter.getBlockCommentPrefix();
            String blockCommentSuffix = commenter.getBlockCommentSuffix();
            if (commentElement.getNode().getElementType() == docCommenter.getLineCommentTokenType() && blockCommentPrefix != null && blockCommentSuffix != null && lineCommentPrefix != null) {
                String commentText = StringUtil.trimStart((String)commentElement.getText(), (String)lineCommentPrefix);
                String suffix = docCommenter.getBlockCommentSuffix();
                if (suffix != null && suffix.length() > 1) {
                    String fixedSuffix = suffix.charAt(0) + " " + suffix.substring(1);
                    commentText = commentText.replace(suffix, fixedSuffix);
                }
                try {
                    Project project = commentElement.getProject();
                    PsiParserFacade parserFacade = PsiParserFacade.SERVICE.getInstance((Project)project);
                    PsiComment newComment = parserFacade.createBlockCommentFromText(commentElement.getLanguage(), commentText);
                    commentElement.replace((PsiElement)newComment);
                    PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(doc);
                }
                catch (IncorrectOperationException e) {
                    LOG.info("Failed to replace line comment with block comment", (Throwable)e);
                }
            }
        }
    }

    private static PsiComment getCommentElement(@Nullable PsiElement element) {
        return (PsiComment)PsiTreeUtil.getParentOfType((PsiElement)element, PsiComment.class, (boolean)false);
    }

    private static class JoinLinesOffsets {
        int lineEndOffset;
        int lastNonSpaceOffsetInStartLine;
        int firstNonSpaceOffsetInNextLine;
        PsiComment commentAtLineEnd;
        PsiComment commentAtLineStart;
        PsiElement elementAtStartLineEnd;

        private JoinLinesOffsets() {
        }

        boolean isStartLineEndsWithComment() {
            return this.commentAtLineEnd != null;
        }

        boolean isNextLineStartsWithComment() {
            return this.commentAtLineStart != null;
        }

        boolean isJoiningSameComment() {
            return this.commentAtLineStart == this.commentAtLineEnd;
        }
    }
}

