/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.SelectWordUtil;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.CompositeLanguage;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedCaret;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.util.Processor;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectWordHandler
extends EditorActionHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.editorActions.SelectWordHandler");
    private final EditorActionHandler myOriginalHandler;

    public SelectWordHandler(EditorActionHandler originalHandler) {
        super(true);
        this.myOriginalHandler = originalHandler;
    }

    public void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
        Project project;
        assert (caret != null);
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: execute(editor='" + editor + "')");
        }
        if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) == null) {
            if (this.myOriginalHandler != null) {
                this.myOriginalHandler.execute(editor, caret, dataContext);
            }
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        TextRange range2 = SelectWordHandler.selectWord(caret, project);
        if (editor instanceof EditorWindow && (range2 == null || !SelectWordHandler.isInsideEditableInjection((EditorWindow)editor, range2, project) || TextRange.from((int)0, (int)editor.getDocument().getTextLength()).equals((Object)new TextRange(caret.getSelectionStart(), caret.getSelectionEnd())))) {
            editor = ((EditorWindow)editor).getDelegate();
            caret = ((InjectedCaret)caret).getDelegate();
            range2 = SelectWordHandler.selectWord(caret, project);
        }
        if (range2 == null) {
            if (this.myOriginalHandler != null) {
                this.myOriginalHandler.execute(editor, caret, dataContext);
            }
        } else {
            caret.setSelection(range2.getStartOffset(), range2.getEndOffset());
        }
    }

    private static boolean isInsideEditableInjection(EditorWindow editor, TextRange range2, Project project) {
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile((Document)editor.getDocument());
        if (file2 == null) {
            return true;
        }
        List editables = InjectedLanguageManager.getInstance((Project)project).intersectWithAllEditableFragments(file2, range2);
        return editables.size() == 1 && range2.equals(editables.get(0));
    }

    @Nullable(value="null means unable to select")
    private static TextRange selectWord(@NotNull Caret caret, @NotNull Project project) {
        PsiElement elementInOtherTree;
        PsiElement anotherElement;
        Document document = caret.getEditor().getDocument();
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (file2 == null) {
            return null;
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.select.word");
        int caretOffset = SelectWordHandler.adjustCaretOffset(caret);
        PsiElement element = SelectWordHandler.findElementAt(file2, caretOffset);
        if (element instanceof PsiWhiteSpace && caretOffset > 0 && !((anotherElement = SelectWordHandler.findElementAt(file2, caretOffset - 1)) instanceof PsiWhiteSpace)) {
            element = anotherElement;
        }
        while (element instanceof PsiWhiteSpace || element != null && StringUtil.isEmptyOrSpaces((String)element.getText())) {
            while (element.getNextSibling() == null) {
                if (element instanceof PsiFile) {
                    return null;
                }
                PsiElement parent = element.getParent();
                PsiElement[] children2 = parent.getChildren();
                if (children2.length > 0 && children2[children2.length - 1] == element) {
                    element = parent;
                    continue;
                }
                element = parent;
                break;
            }
            if (element instanceof PsiFile) {
                return null;
            }
            if ((element = element.getNextSibling()) == null) {
                return null;
            }
            TextRange range3 = element.getTextRange();
            if (range3 == null) {
                return null;
            }
            caretOffset = range3.getStartOffset();
        }
        if (element instanceof OuterLanguageElement && (elementInOtherTree = file2.getViewProvider().findElementAt(element.getTextOffset(), element.getLanguage())) != null && elementInOtherTree.getContainingFile() != element.getContainingFile()) {
            while (elementInOtherTree != null && elementInOtherTree.getPrevSibling() == null) {
                elementInOtherTree = elementInOtherTree.getParent();
            }
            if (elementInOtherTree != null && elementInOtherTree.getTextOffset() == caretOffset) {
                element = elementInOtherTree;
            }
        }
        SelectWordHandler.checkElementRange(document, element);
        TextRange selectionRange = new TextRange(caret.getSelectionStart(), caret.getSelectionEnd());
        Ref minimumRange = new Ref((Object)new TextRange(0, document.getTextLength()));
        SelectWordUtil.processRanges(element, document.getCharsSequence(), caretOffset, caret.getEditor(), (Processor<? super TextRange>)((Processor)range2 -> {
            if (range2.contains(selectionRange) && !range2.equals((Object)selectionRange) && ((TextRange)minimumRange.get()).contains(range2)) {
                minimumRange.set(range2);
                return true;
            }
            return false;
        }));
        return (TextRange)minimumRange.get();
    }

    private static void checkElementRange(Document document, PsiElement element) {
        if (element != null && element.getTextRange().getEndOffset() > document.getTextLength()) {
            throw new AssertionError((Object)DebugUtil.diagnosePsiDocumentInconsistency(element, document));
        }
    }

    private static int adjustCaretOffset(@NotNull Caret caret) {
        int caretOffset = caret.getOffset();
        if (caretOffset == 0) {
            return caretOffset;
        }
        CharSequence text = caret.getEditor().getDocument().getCharsSequence();
        char prev2 = text.charAt(caretOffset - 1);
        if (caretOffset < text.length() && !Character.isJavaIdentifierPart(text.charAt(caretOffset)) && Character.isJavaIdentifierPart(prev2)) {
            return caretOffset - 1;
        }
        if ((caretOffset == text.length() || Character.isWhitespace(text.charAt(caretOffset))) && !Character.isWhitespace(prev2)) {
            return caretOffset - 1;
        }
        return caretOffset;
    }

    @Nullable
    private static PsiElement findElementAt(@NotNull PsiFile file2, int caretOffset) {
        PsiElement elementAt = file2.findElementAt(caretOffset);
        if (elementAt != null && SelectWordHandler.isLanguageExtension(file2, elementAt)) {
            return file2.getViewProvider().findElementAt(caretOffset, file2.getLanguage());
        }
        return elementAt;
    }

    private static boolean isLanguageExtension(@NotNull PsiFile file2, @NotNull PsiElement elementAt) {
        Language elementLanguage = elementAt.getLanguage();
        if (file2.getLanguage() instanceof CompositeLanguage) {
            Language[] extensions;
            CompositeLanguage compositeLanguage = (CompositeLanguage)file2.getLanguage();
            for (Language extension : extensions = compositeLanguage.getLanguageExtensionsForFile(file2)) {
                if (extension != elementLanguage) continue;
                return true;
            }
        }
        return false;
    }
}

