/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandler;
import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandlerBase;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectWordUtil {
    private static ExtendWordSelectionHandler[] SELECTIONERS = new ExtendWordSelectionHandler[0];
    private static boolean ourExtensionsLoaded = false;
    public static final CharCondition JAVA_IDENTIFIER_PART_CONDITION = ch -> Character.isJavaIdentifierPart(ch);

    private SelectWordUtil() {
    }

    static ExtendWordSelectionHandler[] getExtendWordSelectionHandlers() {
        if (!ourExtensionsLoaded) {
            ourExtensionsLoaded = true;
            for (ExtendWordSelectionHandler handler2 : ExtendWordSelectionHandler.EP_NAME.getExtensionList()) {
                SELECTIONERS = (ExtendWordSelectionHandler[])ArrayUtil.append((Object[])SELECTIONERS, (Object)handler2);
            }
        }
        return SELECTIONERS;
    }

    public static void addWordSelection(boolean camel, CharSequence editorText, int cursorOffset, @NotNull List<? super TextRange> ranges) {
        SelectWordUtil.addWordSelection(camel, editorText, cursorOffset, ranges, JAVA_IDENTIFIER_PART_CONDITION);
    }

    public static void addWordOrLexemeSelection(boolean camel, @NotNull Editor editor, int cursorOffset, @NotNull List<? super TextRange> ranges) {
        SelectWordUtil.addWordOrLexemeSelection(camel, editor, cursorOffset, ranges, JAVA_IDENTIFIER_PART_CONDITION);
    }

    public static void addWordSelection(boolean camel, CharSequence editorText, int cursorOffset, @NotNull List<? super TextRange> ranges, CharCondition isWordPartCondition) {
        TextRange range2;
        TextRange camelRange;
        TextRange textRange = camelRange = camel ? SelectWordUtil.getCamelSelectionRange(editorText, cursorOffset, isWordPartCondition) : null;
        if (camelRange != null) {
            ranges.add((TextRange)camelRange);
        }
        if ((range2 = SelectWordUtil.getWordSelectionRange(editorText, cursorOffset, isWordPartCondition)) != null && !range2.equals((Object)camelRange)) {
            ranges.add((TextRange)range2);
        }
    }

    public static void addWordOrLexemeSelection(boolean camel, @NotNull Editor editor, int cursorOffset, @NotNull List<? super TextRange> ranges, CharCondition isWordPartCondition) {
        TextRange range2;
        TextRange camelRange;
        TextRange textRange = camelRange = camel ? SelectWordUtil.getCamelSelectionRange(editor.getDocument().getImmutableCharSequence(), cursorOffset, isWordPartCondition) : null;
        if (camelRange != null) {
            ranges.add((TextRange)camelRange);
        }
        if ((range2 = SelectWordUtil.getWordOrLexemeSelectionRange(editor, cursorOffset, isWordPartCondition)) != null && !range2.equals((Object)camelRange)) {
            ranges.add((TextRange)range2);
        }
    }

    @Nullable
    private static TextRange getCamelSelectionRange(CharSequence editorText, int cursorOffset, CharCondition isWordPartCondition) {
        if (cursorOffset < 0 || cursorOffset >= editorText.length()) {
            return null;
        }
        if (cursorOffset > 0 && !isWordPartCondition.value(editorText.charAt(cursorOffset)) && isWordPartCondition.value(editorText.charAt(cursorOffset - 1))) {
            --cursorOffset;
        }
        if (isWordPartCondition.value(editorText.charAt(cursorOffset))) {
            int start2;
            int end = cursorOffset + 1;
            int textLen = editorText.length();
            for (start2 = cursorOffset; start2 > 0 && isWordPartCondition.value(editorText.charAt(start2 - 1)) && !EditorActionUtil.isHumpBound(editorText, start2, true); --start2) {
            }
            while (end < textLen && isWordPartCondition.value(editorText.charAt(end)) && !EditorActionUtil.isHumpBound(editorText, end, false)) {
                ++end;
            }
            if (start2 + 1 < end) {
                return new TextRange(start2, end);
            }
        }
        return null;
    }

    @Nullable
    public static TextRange getWordOrLexemeSelectionRange(@NotNull Editor editor, int cursorOffset, @NotNull CharCondition isWordPartCondition) {
        return SelectWordUtil.getWordOrLexemeSelectionRange(editor, editor.getDocument().getImmutableCharSequence(), cursorOffset, isWordPartCondition);
    }

    @Nullable
    public static TextRange getWordSelectionRange(@NotNull CharSequence editorText, int cursorOffset, @NotNull CharCondition isWordPartCondition) {
        return SelectWordUtil.getWordOrLexemeSelectionRange(null, editorText, cursorOffset, isWordPartCondition);
    }

    @Nullable
    private static TextRange getWordOrLexemeSelectionRange(@Nullable Editor editor, @NotNull CharSequence editorText, int cursorOffset, @NotNull CharCondition isWordPartCondition) {
        int length = editorText.length();
        if (length == 0) {
            return null;
        }
        if (cursorOffset == length || cursorOffset > 0 && !isWordPartCondition.value(editorText.charAt(cursorOffset)) && isWordPartCondition.value(editorText.charAt(cursorOffset - 1))) {
            --cursorOffset;
        }
        if (isWordPartCondition.value(editorText.charAt(cursorOffset))) {
            int start2;
            int end = cursorOffset;
            for (start2 = cursorOffset; start2 > 0 && isWordPartCondition.value(editorText.charAt(start2 - 1)) && (editor == null || !EditorActionUtil.isLexemeBoundary(editor, start2)); --start2) {
            }
            while (end < length && isWordPartCondition.value(editorText.charAt(end)) && (end == start2 || editor == null || !EditorActionUtil.isLexemeBoundary(editor, end))) {
                ++end;
            }
            return new TextRange(start2, end);
        }
        return null;
    }

    public static void processRanges(@Nullable PsiElement element, @NotNull CharSequence text, int cursorOffset, @NotNull Editor editor, @NotNull Processor<? super TextRange> consumer) {
        if (element == null) {
            return;
        }
        PsiFile file2 = element.getContainingFile();
        FileViewProvider viewProvider = file2.getViewProvider();
        SelectWordUtil.processInFile(element, consumer, text, cursorOffset, editor);
        for (PsiFile psiFile : viewProvider.getAllFiles()) {
            PsiElement elementAt;
            ASTNode nodeAt;
            FileASTNode fileNode;
            if (psiFile == file2 || (fileNode = psiFile.getNode()) == null || (nodeAt = fileNode.findLeafElementAt(element.getTextOffset())) == null) continue;
            for (elementAt = nodeAt.getPsi(); !(elementAt instanceof PsiFile) && elementAt != null && !elementAt.getTextRange().contains(element.getTextRange()); elementAt = elementAt.getParent()) {
            }
            if (elementAt == null) continue;
            SelectWordUtil.processInFile(elementAt, consumer, text, cursorOffset, editor);
        }
    }

    private static void processInFile(@NotNull PsiElement element, @NotNull Processor<? super TextRange> consumer, @NotNull CharSequence text, int cursorOffset, @NotNull Editor editor) {
        DumbService.getInstance((Project)element.getProject()).withAlternativeResolveEnabled(() -> {
            for (PsiElement e = element; e != null && !(e instanceof PsiFile); e = e.getParent()) {
                if (!SelectWordUtil.processElement(e, consumer, text, cursorOffset, editor)) continue;
                return;
            }
        });
    }

    private static boolean processElement(@NotNull PsiElement element, @NotNull Processor<? super TextRange> processor2, @NotNull CharSequence text, int cursorOffset, @NotNull Editor editor) {
        ExtendWordSelectionHandler[] extendWordSelectionHandlers = SelectWordUtil.getExtendWordSelectionHandlers();
        int minimalTextRangeLength = 0;
        LinkedList availableSelectioners = ContainerUtil.newLinkedList();
        for (ExtendWordSelectionHandler selectioner : extendWordSelectionHandlers) {
            if (!selectioner.canSelect(element)) continue;
            int selectionerMinimalTextRange = selectioner instanceof ExtendWordSelectionHandlerBase ? ((ExtendWordSelectionHandlerBase)selectioner).getMinimalTextRangeLength(element, text, cursorOffset) : 0;
            minimalTextRangeLength = Math.max(minimalTextRangeLength, selectionerMinimalTextRange);
            availableSelectioners.add(selectioner);
        }
        boolean stop2 = false;
        for (ExtendWordSelectionHandler selectioner : availableSelectioners) {
            List<TextRange> ranges = SelectWordUtil.askSelectioner(element, text, cursorOffset, editor, selectioner);
            if (ranges == null) continue;
            for (TextRange range2 : ranges) {
                if (range2 == null || range2.getLength() < minimalTextRangeLength) continue;
                stop2 |= processor2.process((Object)range2);
            }
        }
        return stop2;
    }

    @Nullable
    private static List<TextRange> askSelectioner(@NotNull PsiElement element, @NotNull CharSequence text, int cursorOffset, @NotNull Editor editor, @NotNull ExtendWordSelectionHandler selectioner) {
        try {
            long stamp = editor.getDocument().getModificationStamp();
            List ranges = selectioner.select(element, text, cursorOffset, editor);
            if (stamp != editor.getDocument().getModificationStamp()) {
                throw new AssertionError((Object)("Selectioner " + selectioner + " has changed the document"));
            }
            return ranges;
        }
        catch (IndexNotReadyException e) {
            return null;
        }
    }

    public static void addWordHonoringEscapeSequences(CharSequence editorText, TextRange literalTextRange, int cursorOffset, Lexer lexer, List<? super TextRange> result2) {
        lexer.start(editorText, literalTextRange.getStartOffset(), literalTextRange.getEndOffset());
        while (lexer.getTokenType() != null) {
            if (lexer.getTokenStart() <= cursorOffset && cursorOffset < lexer.getTokenEnd()) {
                if (StringEscapesTokenTypes.STRING_LITERAL_ESCAPES.contains(lexer.getTokenType())) {
                    result2.add((TextRange)new TextRange(lexer.getTokenStart(), lexer.getTokenEnd()));
                    break;
                }
                TextRange word = SelectWordUtil.getWordSelectionRange(editorText, cursorOffset, JAVA_IDENTIFIER_PART_CONDITION);
                if (word == null) break;
                result2.add((TextRange)new TextRange(Math.max(word.getStartOffset(), lexer.getTokenStart()), Math.min(word.getEndOffset(), lexer.getTokenEnd())));
                break;
            }
            lexer.advance();
        }
    }

    @FunctionalInterface
    public static interface CharCondition {
        public boolean value(char var1);
    }
}

