/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.TextBlockTransferableData;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextBlockTransferable
implements Transferable {
    private final Collection<? extends TextBlockTransferableData> myExtraData;
    private final RawText myRawText;
    private final String myText;
    private final DataFlavor[] myTransferDataFlavors;

    public TextBlockTransferable(@NotNull String text, @NotNull Collection<? extends TextBlockTransferableData> extraData, @Nullable RawText rawText) {
        this.myText = TextBlockTransferable.cleanFromNullsIfNeeded(text);
        this.myExtraData = extraData;
        this.myRawText = rawText;
        ArrayList<DataFlavorWithPriority> dataFlavors = new ArrayList<DataFlavorWithPriority>();
        Collections.addAll(dataFlavors, new DataFlavorWithPriority(DataFlavor.stringFlavor, 0), new DataFlavorWithPriority(DataFlavor.plainTextFlavor, 0));
        DataFlavor flavor = RawText.getDataFlavor();
        if (this.myRawText != null && flavor != null) {
            dataFlavors.add(new DataFlavorWithPriority(flavor, 0));
        }
        for (TextBlockTransferableData textBlockTransferableData : extraData) {
            DataFlavor blockFlavor = textBlockTransferableData.getFlavor();
            if (blockFlavor == null) continue;
            dataFlavors.add(new DataFlavorWithPriority(blockFlavor, textBlockTransferableData.getPriority()));
        }
        dataFlavors.sort(Comparator.comparingInt(value -> -((DataFlavorWithPriority)value).priority));
        this.myTransferDataFlavors = (DataFlavor[])ContainerUtil.map2Array(dataFlavors, DataFlavor.class, value -> ((DataFlavorWithPriority)value).flavor);
    }

    @NotNull
    private static String cleanFromNullsIfNeeded(@NotNull String text) {
        return SystemInfo.isMac ? text : text.replace('\u0000', ' ');
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return this.myTransferDataFlavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        DataFlavor[] flavors;
        for (DataFlavor flavor1 : flavors = this.getTransferDataFlavors()) {
            if (!flavor.equals(flavor1)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        try {
            for (TextBlockTransferableData textBlockTransferableData : this.myExtraData) {
                if (!Comparing.equal((Object)textBlockTransferableData.getFlavor(), (Object)flavor)) continue;
                return textBlockTransferableData;
            }
            if (this.myRawText != null && Comparing.equal((Object)RawText.getDataFlavor(), (Object)flavor)) {
                return this.myRawText;
            }
            if (DataFlavor.stringFlavor.equals(flavor)) {
                return this.myText;
            }
            if (DataFlavor.plainTextFlavor.equals(flavor)) {
                return new StringReader(this.myText);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        throw new UnsupportedFlavorException(flavor);
    }

    @NotNull
    public static String convertLineSeparators(@NotNull Editor editor, @NotNull String input) {
        return TextBlockTransferable.convertLineSeparators(editor, input, Collections.emptyList());
    }

    @NotNull
    public static String convertLineSeparators(@NotNull Editor editor, @NotNull String input, @NotNull Collection<? extends TextBlockTransferableData> itemsToUpdate) {
        return TextBlockTransferable.convertLineSeparators(input, editor.isOneLineMode() ? " " : "\n", itemsToUpdate);
    }

    public static String convertLineSeparators(String text, String newSeparator, Collection<? extends TextBlockTransferableData> itemsToUpdate) {
        if (itemsToUpdate.size() > 0) {
            int size = 0;
            for (TextBlockTransferableData textBlockTransferableData : itemsToUpdate) {
                size += textBlockTransferableData.getOffsetCount();
            }
            int[] offsets = new int[size];
            boolean bl = false;
            for (TextBlockTransferableData textBlockTransferableData : itemsToUpdate) {
                int n;
                n = textBlockTransferableData.getOffsets(offsets, n);
            }
            text = StringUtil.convertLineSeparators((String)text, (String)newSeparator, (int[])offsets);
            boolean bl2 = false;
            for (TextBlockTransferableData textBlockTransferableData : itemsToUpdate) {
                int n;
                n = textBlockTransferableData.setOffsets(offsets, n);
            }
            return text;
        }
        return StringUtil.convertLineSeparators((String)text, (String)newSeparator);
    }

    private static class DataFlavorWithPriority {
        private final DataFlavor flavor;
        private final int priority;

        private DataFlavorWithPriority(DataFlavor flavor, int priority) {
            this.flavor = flavor;
            this.priority = priority;
        }
    }
}

