/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.TabOutScopesTracker;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;

public class TypedHandlerUtil {
    private static int computeBracesBalance(@NotNull Editor editor, int offset, @NotNull IElementType lt, @NotNull IElementType gt, @NotNull TokenSet invalidInsideReference, boolean forwardDirection) {
        HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(offset);
        if (!forwardDirection && iterator.getTokenType() != gt) {
            return -1;
        }
        while ((forwardDirection && iterator.getStart() > 0 || !forwardDirection && !iterator.atEnd()) && !invalidInsideReference.contains(iterator.getTokenType())) {
            TypedHandlerUtil.incLookup(!forwardDirection, iterator);
        }
        if ((forwardDirection || !iterator.atEnd()) && invalidInsideReference.contains(iterator.getTokenType())) {
            TypedHandlerUtil.incLookup(forwardDirection, iterator);
        }
        int balance = 0;
        while (!iterator.atEnd() && balance >= 0) {
            IElementType tokenType = iterator.getTokenType();
            if (tokenType == lt) {
                balance = forwardDirection ? ++balance : --balance;
            } else if (tokenType == gt) {
                balance = forwardDirection ? --balance : ++balance;
            } else if (invalidInsideReference.contains(tokenType)) break;
            TypedHandlerUtil.incLookup(forwardDirection, iterator);
        }
        return balance;
    }

    private static void incLookup(boolean forwardDirection, @NotNull HighlighterIterator iterator) {
        if (forwardDirection) {
            iterator.advance();
        } else {
            iterator.retreat();
        }
    }

    public static boolean isAfterClassLikeIdentifierOrDot(int offset, @NotNull Editor editor, @NotNull IElementType dot, @NotNull IElementType identifier, boolean allowAfterDot) {
        HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(offset);
        if (iterator.atEnd()) {
            return false;
        }
        if (offset != iterator.getEnd() && iterator.getStart() > 0) {
            iterator.retreat();
        }
        IElementType tokenType = iterator.getTokenType();
        if (allowAfterDot && tokenType == dot) {
            return true;
        }
        return TypedHandlerUtil.isClassLikeIdentifier(offset, editor, iterator, identifier);
    }

    public static boolean isClassLikeIdentifier(int offset, @NotNull Editor editor, @NotNull HighlighterIterator iterator, @NotNull IElementType idType) {
        if (iterator.getTokenType() == idType && iterator.getEnd() == offset) {
            CharSequence chars = editor.getDocument().getCharsSequence();
            char startChar = chars.charAt(iterator.getStart());
            if (!Character.isUpperCase(startChar)) {
                return false;
            }
            CharSequence word = chars.subSequence(iterator.getStart(), iterator.getEnd());
            if (word.length() == 1) {
                return true;
            }
            for (int i = 1; i < word.length(); ++i) {
                if (!Character.isLowerCase(word.charAt(i))) continue;
                return true;
            }
        }
        return false;
    }

    public static void handleAfterGenericLT(@NotNull Editor editor, @NotNull IElementType lt, @NotNull IElementType gt, @NotNull TokenSet invalidInsideReference) {
        if (!CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET) {
            return;
        }
        int offset = editor.getCaretModel().getOffset();
        if (TypedHandlerUtil.computeBracesBalance(editor, offset, lt, gt, invalidInsideReference, true) == 1) {
            editor.getDocument().insertString(offset, (CharSequence)">");
            TabOutScopesTracker.getInstance().registerEmptyScope(editor, offset);
        }
    }

    public static boolean handleGenericGT(@NotNull Editor editor, @NotNull IElementType lt, @NotNull IElementType gt, @NotNull TokenSet invalidInsideReference) {
        if (!CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        if (offset == editor.getDocument().getTextLength()) {
            return false;
        }
        if (TypedHandlerUtil.computeBracesBalance(editor, offset, lt, gt, invalidInsideReference, false) != 0) {
            return false;
        }
        EditorModificationUtil.moveCaretRelatively((Editor)editor, (int)1);
        return true;
    }

    public static void handleGenericLTDeletion(@NotNull Editor editor, int offset, @NotNull IElementType lt, @NotNull IElementType gt, @NotNull TokenSet invalidInsideReference) {
        if (TypedHandlerUtil.computeBracesBalance(editor, offset, lt, gt, invalidInsideReference, true) < 0) {
            editor.getDocument().deleteString(offset, offset + 1);
        }
    }
}

