/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.application.options.CodeStyle;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.xml.HtmlCodeStyleSettings;
import com.intellij.xml.util.HtmlUtil;
import org.jetbrains.annotations.NotNull;

public class XmlEditUtil {
    public static CodeStyleSettings.QuoteStyle quoteStyle(@NotNull PsiFile file2) {
        PsiElement context = file2.getContext();
        CodeStyleSettings.QuoteStyle style = XmlEditUtil.getQuoteStyleForFile(file2);
        if (context != null && !style.quote.isEmpty() && context.getText().startsWith(style.quote)) {
            return style == CodeStyleSettings.QuoteStyle.Double ? CodeStyleSettings.QuoteStyle.Single : CodeStyleSettings.QuoteStyle.Double;
        }
        return style;
    }

    public static String getAttributeQuote(@NotNull PsiFile file2) {
        if (HtmlUtil.hasHtml(file2) || HtmlUtil.supportsXmlTypedHandlers(file2)) {
            return XmlEditUtil.getQuoteStyleForFile((PsiFile)file2).quote;
        }
        return "\"";
    }

    @NotNull
    private static CodeStyleSettings.QuoteStyle getQuoteStyleForFile(@NotNull PsiFile file2) {
        return ((HtmlCodeStyleSettings)CodeStyle.getSettings((PsiFile)file2).getCustomSettings(HtmlCodeStyleSettings.class)).HTML_QUOTE_STYLE;
    }
}

