/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.application.options.editor.WebEditorOptions;
import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.codeInsight.editorActions.XmlEditUtil;
import com.intellij.codeInsight.editorActions.XmlGtTypedHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlEqTypedHandler
extends TypedHandlerDelegate {
    private boolean needToInsertQuotes = false;

    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2, @NotNull FileType fileType) {
        if (c == '=' && WebEditorOptions.getInstance().isInsertQuotesForAttributeValue() && XmlGtTypedHandler.fileContainsXmlLanguage(file2)) {
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            PsiElement atParent = XmlEqTypedHandler.getAttributeCandidate(editor, file2, false);
            if (atParent instanceof XmlAttribute && ((XmlAttribute)atParent).getValueElement() == null) {
                this.needToInsertQuotes = ((XmlAttribute)atParent).getValueElement() == null;
            }
        }
        return super.beforeCharTyped(c, project, editor, file2, fileType);
    }

    @Nullable
    private static PsiElement getAttributeCandidate(@NotNull Editor editor, @NotNull PsiFile file2, boolean typed) {
        int newOffset = editor.getCaretModel().getOffset() - (typed ? 2 : 1);
        if (newOffset < 0) {
            return null;
        }
        PsiElement at = file2.findElementAt(newOffset);
        return at != null ? at.getParent() : null;
    }

    @NotNull
    public TypedHandlerDelegate.Result charTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (this.needToInsertQuotes) {
            int offset = editor.getCaretModel().getOffset();
            PsiElement fileContext = file2.getContext();
            String toInsert = XmlEqTypedHandler.tryCompleteQuotes(fileContext);
            boolean showPopup = true;
            if (toInsert == null) {
                String quote = XmlEqTypedHandler.getDefaultQuote(file2);
                XmlExtension.AttributeValuePresentation presentation = XmlEqTypedHandler.getValuePresentation(editor, file2, quote);
                toInsert = presentation.getPrefix() + presentation.getPostfix();
                showPopup = presentation.showAutoPopup();
            }
            editor.getDocument().insertString(offset, (CharSequence)toInsert);
            editor.getCaretModel().moveToOffset(offset + toInsert.length() / 2);
            if (showPopup) {
                AutoPopupController.getInstance(project).scheduleAutoPopup(editor);
            }
            this.needToInsertQuotes = false;
        }
        return super.charTyped(c, project, editor, file2);
    }

    @Nullable
    private static String tryCompleteQuotes(@Nullable PsiElement fileContext) {
        if (fileContext != null) {
            if (fileContext.getText().startsWith("\"")) {
                return "''";
            }
            if (fileContext.getText().startsWith("'")) {
                return "\"\"";
            }
        }
        return null;
    }

    @NotNull
    private static String getDefaultQuote(@NotNull PsiFile file2) {
        return XmlEditUtil.getAttributeQuote(file2);
    }

    @NotNull
    private static XmlExtension.AttributeValuePresentation getValuePresentation(@NotNull Editor editor, @NotNull PsiFile file2, @NotNull String quote) {
        PsiElement atParent = XmlEqTypedHandler.getAttributeCandidate(editor, file2, true);
        XmlAttributeDescriptor descriptor = atParent instanceof XmlAttribute ? ((XmlAttribute)atParent).getDescriptor() : null;
        return XmlExtension.getExtension(file2).getAttributeValuePresentation(descriptor, quote, (PsiElement)file2);
    }
}

