/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandlerBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class XmlTagSelectioner
extends ExtendWordSelectionHandlerBase {
    @Override
    public boolean canSelect(@NotNull PsiElement e) {
        return e instanceof XmlTag;
    }

    @Override
    public List<TextRange> select(@NotNull PsiElement e, @NotNull CharSequence editorText, int cursorOffset, @NotNull Editor editor) {
        List<TextRange> result2 = super.select(e, editorText, cursorOffset, editor);
        PsiElement[] children2 = e.getChildren();
        XmlTagSelectioner.addTagContentSelection(children2, result2, editorText);
        PsiElement prev2 = e.getPrevSibling();
        while ((prev2 instanceof PsiWhiteSpace || prev2 instanceof XmlText || prev2 instanceof XmlComment) && (!(prev2 instanceof XmlText) || prev2.getText().trim().length() <= 0)) {
            if (prev2 instanceof XmlComment) {
                result2.addAll(XmlTagSelectioner.expandToWholeLine(editorText, new TextRange(prev2.getTextRange().getStartOffset(), e.getTextRange().getEndOffset()), false));
            }
            prev2 = prev2.getPrevSibling();
        }
        return result2;
    }

    private static void addTagContentSelection(PsiElement[] children2, List<? super TextRange> result2, CharSequence editorText) {
        PsiElement first = null;
        PsiElement last = null;
        for (PsiElement child2 : children2) {
            if (!(child2 instanceof XmlToken)) continue;
            XmlToken token = (XmlToken)child2;
            if (token.getTokenType() == XmlTokenType.XML_TAG_END) {
                first = token.getNextSibling();
            }
            if (token.getTokenType() != XmlTokenType.XML_END_TAG_START) continue;
            last = token.getPrevSibling();
            break;
        }
        if (first != null && last != null) {
            result2.addAll(XmlTagSelectioner.expandToWholeLine(editorText, new TextRange(first.getTextRange().getStartOffset(), last.getTextRange().getEndOffset()), false));
        }
    }
}

