/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.enter;

import com.intellij.codeInsight.editorActions.EnterHandler;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.codeInsight.editorActions.enter.EnterInCommentUtil;
import com.intellij.ide.todo.TodoConfiguration;
import com.intellij.lang.CodeDocumentationAwareCommenter;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.DocumentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;

public class EnterInBlockCommentHandler
extends EnterHandlerDelegateAdapter {
    private static final String WHITESPACE = " \t";

    @Override
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file2, @NotNull Editor editor, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        int refOffset;
        String linePrefix;
        int nonWsLineStart;
        int lineEndOffset;
        int lineStartOffset;
        int todoOffset;
        CodeDocumentationAwareCommenter commenter = EnterInCommentUtil.getDocumentationAwareCommenter(dataContext);
        if (commenter == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        int caretOffset = (Integer)caretOffsetRef.get();
        int blockCommentStartOffset = EnterInBlockCommentHandler.getBlockCommentStartOffset(editor, caretOffset, commenter);
        if (blockCommentStartOffset < 0) {
            return EnterHandlerDelegate.Result.Continue;
        }
        Document document = editor.getDocument();
        CharSequence text = document.getImmutableCharSequence();
        String docCommentPrefix = commenter.getDocumentationCommentPrefix();
        if (docCommentPrefix != null && StringUtil.startsWith((CharSequence)text.subSequence(blockCommentStartOffset, caretOffset), (CharSequence)docCommentPrefix)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        int beforeWhitespace = CharArrayUtil.shiftBackward((CharSequence)text, (int)(blockCommentStartOffset - 1), (String)WHITESPACE);
        if (beforeWhitespace > 0 && text.charAt(beforeWhitespace) != '\n') {
            return EnterHandlerDelegate.Result.Continue;
        }
        PsiDocumentManager.getInstance((Project)file2.getProject()).commitDocument(document);
        PsiElement element = file2.findElementAt(blockCommentStartOffset);
        if (!(element instanceof PsiComment) || ((PsiComment)element).getTokenType() != commenter.getBlockCommentTokenType()) {
            return EnterHandlerDelegate.Result.Continue;
        }
        if (!EnterHandler.isCommentComplete((PsiComment)element, commenter, editor)) {
            int currentEndOfLine = CharArrayUtil.shiftForwardUntil((CharSequence)text, (int)caretOffset, (String)"\n");
            document.insertString(currentEndOfLine, (CharSequence)("\n" + text.subSequence(beforeWhitespace + 1, blockCommentStartOffset) + " " + commenter.getBlockCommentSuffix()));
            return EnterHandlerDelegate.Result.Default;
        }
        int additionalIndent = 0;
        if (TodoConfiguration.getInstance().isMultiLine() && (todoOffset = EnterInCommentUtil.getTodoTextOffset(text, lineStartOffset = DocumentUtil.getLineStartOffset(caretOffset, document), caretOffset)) >= 0 && todoOffset == EnterInCommentUtil.getTodoTextOffset(text, lineStartOffset, lineEndOffset = DocumentUtil.getLineEndOffset(caretOffset, document)) && todoOffset >= (nonWsLineStart = CharArrayUtil.shiftForward((CharSequence)text, (int)lineStartOffset, (String)WHITESPACE))) {
            additionalIndent = todoOffset - nonWsLineStart + 1;
            document.insertString(caretOffset, (CharSequence)StringUtil.repeat((String)" ", (int)additionalIndent));
        }
        if ((linePrefix = commenter.getDocumentationCommentLinePrefix()) == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        int n = refOffset = document.getLineNumber(caretOffset) > document.getLineNumber(blockCommentStartOffset) ? document.getLineStartOffset(document.getLineNumber(blockCommentStartOffset) + 1) : caretOffset;
        if (StringUtil.startsWith((CharSequence)text, (int)CharArrayUtil.shiftForward((CharSequence)text, (int)refOffset, (String)WHITESPACE), (CharSequence)linePrefix)) {
            int endOffset = CharArrayUtil.shiftForward((CharSequence)text, (int)caretOffset, (String)WHITESPACE);
            if (endOffset < text.length() && text.charAt(endOffset) != '\n') {
                endOffset = caretOffset;
            }
            int valueLength = linePrefix.length() + 1;
            int endOffsetToReplace = endOffset > caretOffset ? endOffset : caretOffset + Math.min(additionalIndent, valueLength);
            document.replaceString(caretOffset, endOffsetToReplace, (CharSequence)(linePrefix + " "));
            caretAdvance.set((Object)Math.max(valueLength, additionalIndent));
            return EnterHandlerDelegate.Result.DefaultForceIndent;
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    private static int getBlockCommentStartOffset(@NotNull Editor editor, int offset, @NotNull CodeDocumentationAwareCommenter commenter) {
        EditorHighlighter highlighter = ((EditorEx)editor).getHighlighter();
        HighlighterIterator iterator = highlighter.createIterator(offset);
        if (iterator.atEnd() || iterator.getTokenType() != commenter.getBlockCommentTokenType()) {
            return -1;
        }
        String prefix = (String)ObjectUtils.notNull((Object)commenter.getBlockCommentPrefix(), (Object)"");
        int tokenStart = iterator.getStart();
        int tokenEnd = iterator.getEnd();
        int prefixEnd = tokenStart + prefix.length();
        if (prefixEnd > tokenEnd || prefixEnd > offset) {
            return -1;
        }
        String suffix = (String)ObjectUtils.notNull((Object)commenter.getBlockCommentSuffix(), (Object)"");
        if (StringUtil.endsWith((CharSequence)editor.getDocument().getImmutableCharSequence().subSequence(prefixEnd, tokenEnd), (CharSequence)suffix) && offset > tokenEnd - suffix.length()) {
            return -1;
        }
        return tokenStart;
    }
}

