/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.enter;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.editorActions.EnterHandler;
import com.intellij.codeInsight.editorActions.JavaLikeQuoteHandler;
import com.intellij.codeInsight.editorActions.QuoteHandler;
import com.intellij.codeInsight.editorActions.TypedHandler;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lexer.StringLiteralLexer;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnterInStringLiteralHandler
extends EnterHandlerDelegateAdapter {
    @Override
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file2, @NotNull Editor editor, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvanceRef, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        Language language = EnterHandler.getLanguage(dataContext);
        if (language == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        int caretOffset = (Integer)caretOffsetRef.get();
        JavaLikeQuoteHandler quoteHandler = this.getJavaLikeQuoteHandler(editor, (PsiElement)file2);
        if (!EnterInStringLiteralHandler.isInStringLiteral(editor, quoteHandler, caretOffset)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        PsiDocumentManager.getInstance((Project)file2.getProject()).commitDocument(editor.getDocument());
        PsiElement psiAtOffset = file2.findElementAt(caretOffset);
        if (psiAtOffset != null && psiAtOffset.getTextOffset() < caretOffset) {
            ASTNode token = psiAtOffset.getNode();
            if (quoteHandler.getConcatenatableStringTokenTypes().contains(token.getElementType())) {
                Document document = editor.getDocument();
                String text = document.getText();
                TextRange range2 = token.getTextRange();
                char literalStart = token.getText().charAt(0);
                StringLiteralLexer lexer = new StringLiteralLexer(literalStart, token.getElementType());
                lexer.start((CharSequence)text, range2.getStartOffset(), range2.getEndOffset());
                while (lexer.getTokenType() != null) {
                    if (lexer.getTokenStart() < caretOffset && caretOffset < lexer.getTokenEnd()) {
                        if (!StringEscapesTokenTypes.STRING_LITERAL_ESCAPES.contains(lexer.getTokenType())) break;
                        caretOffset = lexer.getTokenEnd();
                        break;
                    }
                    lexer.advance();
                }
                int caretAdvance = (Integer)caretAdvanceRef.get();
                if (quoteHandler.needParenthesesAroundConcatenation(psiAtOffset)) {
                    document.insertString(psiAtOffset.getTextRange().getEndOffset(), (CharSequence)")");
                    document.insertString(psiAtOffset.getTextRange().getStartOffset(), (CharSequence)"(");
                    ++caretOffset;
                    ++caretAdvance;
                }
                String insertedFragment = literalStart + " " + quoteHandler.getStringConcatenationOperatorRepresentation();
                document.insertString(caretOffset, (CharSequence)(insertedFragment + " " + literalStart));
                caretOffset += insertedFragment.length();
                caretAdvance = 1;
                if (CodeStyle.getLanguageSettings((PsiFile)file2).BINARY_OPERATION_SIGN_ON_NEXT_LINE) {
                    --caretOffset;
                    caretAdvance = 3;
                }
                caretOffsetRef.set((Object)caretOffset);
                caretAdvanceRef.set((Object)caretAdvance);
                return EnterHandlerDelegate.Result.DefaultForceIndent;
            }
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    @Nullable
    protected JavaLikeQuoteHandler getJavaLikeQuoteHandler(@NotNull Editor editor, @NotNull PsiElement psiAtOffset) {
        QuoteHandler fileTypeQuoteHandler = TypedHandler.getQuoteHandler(psiAtOffset.getContainingFile(), editor);
        return fileTypeQuoteHandler instanceof JavaLikeQuoteHandler ? (JavaLikeQuoteHandler)fileTypeQuoteHandler : null;
    }

    @Contract(value="_,null,_->false")
    private static boolean isInStringLiteral(@NotNull Editor editor, @Nullable JavaLikeQuoteHandler quoteHandler, int offset) {
        EditorHighlighter highlighter;
        HighlighterIterator iterator;
        IElementType type;
        return offset > 0 && quoteHandler != null && (StringEscapesTokenTypes.STRING_LITERAL_ESCAPES.contains(type = (iterator = (highlighter = ((EditorEx)editor).getHighlighter()).createIterator(offset - 1)).getTokenType()) || quoteHandler.isInsideLiteral(iterator)) && quoteHandler.getConcatenatableStringTokenTypes() != null;
    }
}

