/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.wordSelection;

import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandlerBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPlainText;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PlainTextLineSelectioner
extends ExtendWordSelectionHandlerBase {
    @Override
    public boolean canSelect(@NotNull PsiElement e) {
        return e instanceof PsiPlainText;
    }

    @Override
    public List<TextRange> select(@NotNull PsiElement e, @NotNull CharSequence editorText, int cursorOffset, @NotNull Editor editor) {
        return PlainTextLineSelectioner.selectPlainTextLine(e, editorText, cursorOffset);
    }

    public static List<TextRange> selectPlainTextLine(PsiElement e, CharSequence editorText, int cursorOffset) {
        int end;
        int start2;
        for (start2 = cursorOffset; start2 > 0 && editorText.charAt(start2 - 1) != '\n' && editorText.charAt(start2 - 1) != '\r'; --start2) {
        }
        for (end = cursorOffset; end < editorText.length() && editorText.charAt(end) != '\n' && editorText.charAt(end) != '\r'; ++end) {
        }
        TextRange range2 = new TextRange(start2, end);
        if (!e.getParent().getTextRange().contains(range2)) {
            return null;
        }
        ArrayList<TextRange> result2 = new ArrayList<TextRange>();
        result2.add(range2);
        return result2;
    }
}

