/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.folding.CollapseBlockHandler;
import com.intellij.codeInsight.folding.impl.EditorFoldingInfo;
import com.intellij.codeInsight.folding.impl.FoldingUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CollapseBlockHandlerImpl
implements CollapseBlockHandler {
    Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.folding.CollapseBlockHandler");

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        int[] targetCaretOffset = new int[]{-1};
        editor.getFoldingModel().runBatchFoldingOperation(() -> {
            EditorFoldingInfo info = EditorFoldingInfo.get(editor);
            FoldingModelEx model = (FoldingModelEx)editor.getFoldingModel();
            int offset = editor.getCaretModel().getOffset();
            PsiElement element = file2.findElementAt(offset - 1);
            if (!this.isEndBlockToken(element)) {
                element = file2.findElementAt(offset);
            }
            if (element == null) {
                return;
            }
            PsiElement block = this.findParentBlock(element);
            FoldRegion previous = null;
            FoldRegion myPrevious = null;
            while (block != null) {
                int end;
                TextRange range2 = this.getFoldingRange(block);
                if (!range2.containsOffset(offset)) {
                    block = this.findParentBlock(block);
                    continue;
                }
                int start2 = range2.getStartOffset();
                FoldRegion existing = FoldingUtil.findFoldRegion(editor, start2, end = range2.getEndOffset());
                if (existing != null) {
                    if (existing.isExpanded()) {
                        existing.setExpanded(false);
                        targetCaretOffset[0] = existing.getEndOffset();
                        return;
                    }
                    previous = existing;
                    if (info.getPsiElement(existing) == null) {
                        myPrevious = existing;
                    }
                    block = this.findParentBlock(block);
                    continue;
                }
                if (model.intersectsRegion(start2, end)) break;
                FoldRegion region = model.addFoldRegion(start2, end, this.getPlaceholderText());
                this.LOG.assertTrue(region != null);
                region.setExpanded(false);
                if (myPrevious != null && info.getPsiElement(region) == null) {
                    info.removeRegion(myPrevious);
                    model.removeFoldRegion(myPrevious);
                }
                targetCaretOffset[0] = block.getTextRange().getEndOffset() < offset ? start2 : end;
                return;
            }
            if (previous != null) {
                previous.setExpanded(false);
                if (myPrevious != null) {
                    info.removeRegion(myPrevious);
                    model.removeFoldRegion(myPrevious);
                }
                targetCaretOffset[0] = previous.getEndOffset();
            }
        });
        if (targetCaretOffset[0] >= 0) {
            editor.getCaretModel().moveToOffset(targetCaretOffset[0]);
        }
    }

    @Nullable
    protected abstract PsiElement findParentBlock(@Nullable PsiElement var1);

    protected abstract boolean isEndBlockToken(@Nullable PsiElement var1);

    @NotNull
    protected String getPlaceholderText() {
        return "{...}";
    }

    @NotNull
    protected TextRange getFoldingRange(@NotNull PsiElement element) {
        return element.getTextRange();
    }
}

