/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.codeInsight.folding.impl.EditorFoldingInfo;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiDocCommentBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CollapseExpandDocCommentsHandler
implements CodeInsightActionHandler {
    private static final Key<Boolean> DOC_COMMENT_MARK = Key.create((String)"explicit.fold.region.doc.comment.mark");
    private final boolean myExpand;

    public static void setDocCommentMark(@NotNull FoldRegion region, boolean value) {
        region.putUserData(DOC_COMMENT_MARK, (Object)value);
    }

    public CollapseExpandDocCommentsHandler(boolean isExpand) {
        this.myExpand = isExpand;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        CodeFoldingManager foldingManager = CodeFoldingManager.getInstance(project);
        foldingManager.updateFoldRegions(editor);
        FoldRegion[] allFoldRegions = editor.getFoldingModel().getAllFoldRegions();
        Runnable processor2 = () -> {
            for (FoldRegion region : allFoldRegions) {
                PsiElement element = EditorFoldingInfo.get(editor).getPsiElement(region);
                if (!(element instanceof PsiDocCommentBase) && !Boolean.TRUE.equals(region.getUserData(DOC_COMMENT_MARK))) continue;
                region.setExpanded(this.myExpand);
            }
        };
        editor.getFoldingModel().runBatchFoldingOperation(processor2);
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        return null;
    }
}

