/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.source.tree.injected.FoldingRegionWindow;
import gnu.trove.THashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorFoldingInfo {
    private static final Key<EditorFoldingInfo> KEY = Key.create((String)"EditorFoldingInfo.KEY");
    private final Map<FoldRegion, SmartPsiElementPointer<?>> myFoldRegionToSmartPointerMap = new THashMap();

    @NotNull
    public static EditorFoldingInfo get(@NotNull Editor editor) {
        if (editor instanceof EditorWindow) {
            return new EditorFoldingInfoWindow(EditorFoldingInfo.get(((EditorWindow)editor).getDelegate()));
        }
        EditorFoldingInfo info = (EditorFoldingInfo)editor.getUserData(KEY);
        if (info == null) {
            info = new EditorFoldingInfo();
            editor.putUserData(KEY, (Object)info);
        }
        return info;
    }

    @Nullable
    public PsiElement getPsiElement(@NotNull FoldRegion region) {
        SmartPsiElementPointer<?> pointer = this.myFoldRegionToSmartPointerMap.get(region);
        if (pointer == null) {
            return null;
        }
        PsiElement element = pointer.getElement();
        return element != null && element.isValid() ? element : null;
    }

    @Nullable
    TextRange getPsiElementRange(@NotNull FoldRegion region) {
        PsiElement element = this.getPsiElement(region);
        if (element == null) {
            return null;
        }
        PsiFile containingFile = element.getContainingFile();
        InjectedLanguageManager injectedManager = InjectedLanguageManager.getInstance((Project)containingFile.getProject());
        boolean isInjected = injectedManager.isInjectedFragment(containingFile);
        TextRange range2 = element.getTextRange();
        if (isInjected) {
            range2 = injectedManager.injectedToHost(element, range2);
        }
        return range2;
    }

    void addRegion(@NotNull FoldRegion region, @NotNull SmartPsiElementPointer<?> pointer) {
        this.myFoldRegionToSmartPointerMap.put(region, pointer);
    }

    public void removeRegion(@NotNull FoldRegion region) {
        this.myFoldRegionToSmartPointerMap.remove(region);
    }

    public void dispose() {
        this.myFoldRegionToSmartPointerMap.clear();
    }

    private static class EditorFoldingInfoWindow
    extends EditorFoldingInfo {
        private final EditorFoldingInfo myDelegate;

        private EditorFoldingInfoWindow(EditorFoldingInfo delegate) {
            this.myDelegate = delegate;
        }

        @Override
        @Nullable
        public PsiElement getPsiElement(@NotNull FoldRegion region) {
            return this.myDelegate.getPsiElement(EditorFoldingInfoWindow.getHostRegion(region));
        }

        @Override
        void addRegion(@NotNull FoldRegion region, @NotNull SmartPsiElementPointer<?> pointer) {
            this.myDelegate.addRegion(EditorFoldingInfoWindow.getHostRegion(region), pointer);
        }

        @Override
        public void removeRegion(@NotNull FoldRegion region) {
            this.myDelegate.removeRegion(EditorFoldingInfoWindow.getHostRegion(region));
        }

        @Override
        public void dispose() {
            this.myDelegate.dispose();
        }

        private static FoldRegion getHostRegion(@NotNull FoldRegion injectedRegion) {
            return injectedRegion instanceof FoldingRegionWindow ? ((FoldingRegionWindow)injectedRegion).getDelegate() : injectedRegion;
        }
    }
}

