/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl.actions;

import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.codeInsight.folding.impl.FoldingUtil;
import com.intellij.codeInsight.folding.impl.actions.BaseFoldingHandler;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CollapseRegionAction
extends EditorAction {
    public CollapseRegionAction() {
        super((EditorActionHandler)new BaseFoldingHandler(){

            public void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
                CodeFoldingManager foldingManager = CodeFoldingManager.getInstance(editor.getProject());
                foldingManager.updateFoldRegions(editor);
                int line = editor.getCaretModel().getLogicalPosition().line;
                Runnable processor2 = () -> {
                    FoldRegion region = FoldingUtil.findFoldRegionStartingAtLine(editor, line);
                    if (region != null && region.isExpanded()) {
                        region.setExpanded(false);
                    } else {
                        FoldRegion[] regions;
                        int offset = editor.getCaretModel().getOffset();
                        for (FoldRegion region1 : regions = FoldingUtil.getFoldRegionsAtOffset(editor, offset)) {
                            if (!region1.isExpanded()) continue;
                            region1.setExpanded(false);
                            break;
                        }
                    }
                };
                editor.getFoldingModel().runBatchFoldingOperation(processor2);
            }
        });
    }
}

