/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl.actions;

import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.codeInsight.folding.impl.actions.BaseFoldingHandler;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpandAllRegionsAction
extends EditorAction {
    public ExpandAllRegionsAction() {
        super((EditorActionHandler)new BaseFoldingHandler(){

            public void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
                Project project = editor.getProject();
                assert (project != null);
                PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
                CodeFoldingManager codeFoldingManager = CodeFoldingManager.getInstance(project);
                codeFoldingManager.updateFoldRegions(editor);
                List<FoldRegion> regions = this.getFoldRegionsForSelection(editor, caret);
                editor.getFoldingModel().runBatchFoldingOperation(() -> {
                    boolean anythingDone = false;
                    for (FoldRegion region : regions) {
                        Boolean collapsedByDefault = codeFoldingManager.isCollapsedByDefault(region);
                        if (region.isExpanded() || collapsedByDefault != null && collapsedByDefault.booleanValue()) continue;
                        region.setExpanded(true);
                        anythingDone = true;
                    }
                    if (!anythingDone) {
                        for (FoldRegion region : regions) {
                            region.setExpanded(true);
                        }
                    }
                });
            }
        });
    }
}

