/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.highlighting.BraceHighlightingHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.Alarm;
import com.intellij.util.Processor;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class BraceHighlighter
implements StartupActivity {
    private final Alarm myAlarm = new Alarm();

    public void runActivity(final @NotNull Project project) {
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return;
        }
        EditorEventMulticaster eventMulticaster = EditorFactory.getInstance().getEventMulticaster();
        eventMulticaster.addCaretListener(new CaretListener(){

            public void caretPositionChanged(@NotNull CaretEvent e) {
                if (e.getCaret() != e.getEditor().getCaretModel().getPrimaryCaret()) {
                    return;
                }
                BraceHighlighter.this.myAlarm.cancelAllRequests();
                Editor editor = e.getEditor();
                SelectionModel selectionModel = editor.getSelectionModel();
                if (editor.getProject() != project || selectionModel.hasSelection()) {
                    return;
                }
                BraceHighlighter.updateBraces(editor, BraceHighlighter.this.myAlarm);
            }
        }, (Disposable)project);
        SelectionListener selectionListener = new SelectionListener(){

            public void selectionChanged(@NotNull SelectionEvent e) {
                BraceHighlighter.this.myAlarm.cancelAllRequests();
                Editor editor = e.getEditor();
                if (editor.getProject() != project) {
                    return;
                }
                TextRange oldRange = e.getOldRange();
                TextRange newRange = e.getNewRange();
                if (oldRange != null && newRange != null && oldRange.isEmpty() == newRange.isEmpty()) {
                    return;
                }
                BraceHighlighter.updateBraces(editor, BraceHighlighter.this.myAlarm);
            }
        };
        eventMulticaster.addSelectionListener(selectionListener, (Disposable)project);
        DocumentListener documentListener = new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                Editor[] editors;
                BraceHighlighter.this.myAlarm.cancelAllRequests();
                for (Editor editor : editors = EditorFactory.getInstance().getEditors(e.getDocument(), project)) {
                    BraceHighlighter.updateBraces(editor, BraceHighlighter.this.myAlarm);
                }
            }
        };
        eventMulticaster.addDocumentListener(documentListener, (Disposable)project);
        project.getMessageBus().connect().subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void selectionChanged(@NotNull FileEditorManagerEvent e) {
                FileEditor newEditor;
                BraceHighlighter.this.myAlarm.cancelAllRequests();
                FileEditor oldEditor = e.getOldEditor();
                if (oldEditor instanceof TextEditor) {
                    BraceHighlighter.this.clearBraces(((TextEditor)oldEditor).getEditor());
                }
                if ((newEditor = e.getNewEditor()) instanceof TextEditor) {
                    BraceHighlighter.updateBraces(((TextEditor)newEditor).getEditor(), BraceHighlighter.this.myAlarm);
                }
            }
        });
    }

    static void updateBraces(@NotNull Editor editor, @NotNull Alarm alarm) {
        Document document = editor.getDocument();
        if (document instanceof DocumentEx && ((DocumentEx)document).isInBulkUpdate()) {
            return;
        }
        BraceHighlightingHandler.lookForInjectedAndMatchBracesInOtherThread(editor, alarm, (Processor<? super BraceHighlightingHandler>)((Processor)handler2 -> {
            handler2.updateBraces();
            return false;
        }));
    }

    private void clearBraces(@NotNull Editor editor) {
        BraceHighlightingHandler.lookForInjectedAndMatchBracesInOtherThread(editor, this.myAlarm, (Processor<? super BraceHighlightingHandler>)((Processor)handler2 -> {
            handler2.clearBraceHighlighters();
            return false;
        }));
    }

    @NotNull
    public static Alarm getAlarm() {
        return ((BraceHighlighter)Objects.requireNonNull(BraceHighlighter.POST_STARTUP_ACTIVITY.findExtension(BraceHighlighter.class))).myAlarm;
    }
}

