/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.highlighting.BraceHighlightingHandler;
import com.intellij.codeInsight.highlighting.BraceMatcher;
import com.intellij.codeInsight.highlighting.PairedBraceMatcherAdapter;
import com.intellij.codeInsight.highlighting.XmlAwareBraceMatcher;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageBraceMatching;
import com.intellij.lang.PairedBraceMatcher;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeExtensionPoint;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.containers.Stack;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BraceMatchingUtil {
    public static final int UNDEFINED_TOKEN_GROUP = -1;
    private static final Map<FileType, BraceMatcher> BRACE_MATCHERS = new HashMap<FileType, BraceMatcher>();

    private BraceMatchingUtil() {
    }

    public static boolean isPairedBracesAllowedBeforeTypeInFileType(@NotNull IElementType lbraceType, IElementType tokenType, @NotNull FileType fileType) {
        try {
            return BraceMatchingUtil.getBraceMatcher(fileType, lbraceType).isPairedBracesAllowedBeforeType(lbraceType, tokenType);
        }
        catch (AbstractMethodError abstractMethodError) {
            return true;
        }
    }

    public static void registerBraceMatcher(@NotNull FileType fileType, @NotNull BraceMatcher braceMatcher) {
        BRACE_MATCHERS.put(fileType, braceMatcher);
    }

    public static int getMatchedBraceOffset(@NotNull Editor editor, boolean forward, @NotNull PsiFile file2) {
        Document document = editor.getDocument();
        int offset = editor.getCaretModel().getOffset();
        EditorHighlighter editorHighlighter = BraceHighlightingHandler.getLazyParsableHighlighterIfAny(file2.getProject(), editor, file2);
        HighlighterIterator iterator = editorHighlighter.createIterator(offset);
        boolean matched = BraceMatchingUtil.matchBrace(document.getCharsSequence(), file2.getFileType(), iterator, forward);
        if (!matched) {
            throw new AssertionError();
        }
        return iterator.getStart();
    }

    @Nullable
    public static BraceHighlightingAndNavigationContext computeHighlightingAndNavigationContext(@NotNull Editor editor, @NotNull PsiFile file2) {
        return BraceMatchingUtil.computeHighlightingAndNavigationContext(editor, file2, editor.getCaretModel().getOffset());
    }

    @Nullable
    public static BraceHighlightingAndNavigationContext computeHighlightingAndNavigationContext(@NotNull Editor editor, @NotNull PsiFile file2, int offset) {
        int preOffsetTokenStart;
        EditorHighlighter highlighter = BraceHighlightingHandler.getLazyParsableHighlighterIfAny(file2.getProject(), editor, file2);
        CharSequence text = editor.getDocument().getCharsSequence();
        HighlighterIterator iterator = highlighter.createIterator(offset);
        FileType fileType = iterator.atEnd() ? null : BraceMatchingUtil.getFileType(file2, iterator.getStart());
        HighlighterIterator preOffsetIterator = offset > 0 ? highlighter.createIterator(offset - 1) : null;
        FileType preOffsetFileType = preOffsetIterator != null ? BraceMatchingUtil.getFileType(file2, preOffsetIterator.getStart()) : null;
        boolean isAfterLeftBrace = preOffsetIterator != null && BraceMatchingUtil.isLBraceToken(preOffsetIterator, text, preOffsetFileType);
        boolean isAfterRightBrace = !isAfterLeftBrace && preOffsetIterator != null && BraceMatchingUtil.isRBraceToken(preOffsetIterator, text, preOffsetFileType);
        boolean isBeforeLeftBrace = fileType != null && BraceMatchingUtil.isLBraceToken(iterator, text, fileType);
        boolean isBeforeRightBrace = !isBeforeLeftBrace && fileType != null && BraceMatchingUtil.isRBraceToken(iterator, text, fileType);
        int offsetTokenStart = iterator.atEnd() ? -1 : iterator.getStart();
        int n = preOffsetTokenStart = preOffsetIterator == null || preOffsetIterator.atEnd() ? -1 : preOffsetIterator.getStart();
        if (isAfterRightBrace && BraceMatchingUtil.matchBrace(text, preOffsetFileType, preOffsetIterator, false)) {
            return new BraceHighlightingAndNavigationContext(preOffsetTokenStart, preOffsetIterator.getStart());
        }
        if (isBeforeLeftBrace && BraceMatchingUtil.matchBrace(text, fileType, iterator, true)) {
            return new BraceHighlightingAndNavigationContext(offsetTokenStart, iterator.getEnd());
        }
        if (isAfterLeftBrace && BraceMatchingUtil.matchBrace(text, preOffsetFileType, preOffsetIterator, true)) {
            return new BraceHighlightingAndNavigationContext(preOffsetTokenStart, preOffsetIterator.getEnd());
        }
        if (isBeforeRightBrace && BraceMatchingUtil.matchBrace(text, fileType, iterator, false)) {
            return new BraceHighlightingAndNavigationContext(offsetTokenStart, iterator.getStart());
        }
        return null;
    }

    @NotNull
    public static FileType getFileType(PsiFile file2, int offset) {
        return PsiUtilBase.getPsiFileAtOffset((PsiFile)file2, (int)offset).getFileType();
    }

    public static synchronized boolean matchBrace(@NotNull CharSequence fileText, @NotNull FileType fileType, @NotNull HighlighterIterator iterator, boolean forward) {
        return new MatchBraceContext(fileText, fileType, iterator, forward).doBraceMatch();
    }

    public static synchronized boolean matchBrace(@NotNull CharSequence fileText, @NotNull FileType fileType, @NotNull HighlighterIterator iterator, boolean forward, boolean isStrict) {
        return new MatchBraceContext(fileText, fileType, iterator, forward, isStrict).doBraceMatch();
    }

    public static boolean findStructuralLeftBrace(@NotNull FileType fileType, @NotNull HighlighterIterator iterator, @NotNull CharSequence fileText) {
        Stack braceStack = new Stack();
        Stack tagNameStack = new Stack();
        BraceMatcher matcher = BraceMatchingUtil.getBraceMatcher(fileType, iterator);
        while (!iterator.atEnd()) {
            if (BraceMatchingUtil.isStructuralBraceToken(fileType, iterator, fileText)) {
                if (BraceMatchingUtil.isRBraceToken(iterator, fileText, fileType)) {
                    braceStack.push((Object)iterator.getTokenType());
                    tagNameStack.push((Object)BraceMatchingUtil.getTagName(matcher, fileText, iterator));
                }
                if (BraceMatchingUtil.isLBraceToken(iterator, fileText, fileType)) {
                    if (braceStack.isEmpty()) {
                        return true;
                    }
                    int group = matcher.getBraceTokenGroupId(iterator.getTokenType());
                    IElementType topTokenType = (IElementType)braceStack.pop();
                    IElementType tokenType = iterator.getTokenType();
                    boolean isStrict = BraceMatchingUtil.isStrictTagMatching(matcher, fileType, group);
                    boolean isCaseSensitive = BraceMatchingUtil.areTagsCaseSensitive(matcher, fileType, group);
                    String topTagName = null;
                    String tagName = null;
                    if (isStrict) {
                        topTagName = (String)tagNameStack.pop();
                        tagName = BraceMatchingUtil.getTagName(matcher, fileText, iterator);
                    }
                    if (!BraceMatchingUtil.isPairBraces(topTokenType, tokenType, fileType) || isStrict && !Comparing.equal((String)topTagName, (String)tagName, (boolean)isCaseSensitive)) {
                        return false;
                    }
                }
            }
            iterator.retreat();
        }
        return false;
    }

    public static boolean isStructuralBraceToken(@NotNull FileType fileType, @NotNull HighlighterIterator iterator, @NotNull CharSequence text) {
        BraceMatcher matcher = BraceMatchingUtil.getBraceMatcher(fileType, iterator);
        return matcher.isStructuralBrace(iterator, text, fileType);
    }

    public static boolean isLBraceToken(@NotNull HighlighterIterator iterator, @NotNull CharSequence fileText, @NotNull FileType fileType) {
        BraceMatcher braceMatcher = BraceMatchingUtil.getBraceMatcher(fileType, iterator);
        return braceMatcher.isLBraceToken(iterator, fileText, fileType);
    }

    public static boolean isRBraceToken(@NotNull HighlighterIterator iterator, @NotNull CharSequence fileText, @NotNull FileType fileType) {
        BraceMatcher braceMatcher = BraceMatchingUtil.getBraceMatcher(fileType, iterator);
        return braceMatcher.isRBraceToken(iterator, fileText, fileType);
    }

    public static boolean isPairBraces(@NotNull IElementType tokenType1, @NotNull IElementType tokenType2, @NotNull FileType fileType) {
        BraceMatcher matcher = BraceMatchingUtil.getBraceMatcher(fileType, tokenType1);
        return matcher.isPairBraces(tokenType1, tokenType2);
    }

    private static int getTokenGroup(@Nullable IElementType tokenType, FileType fileType) {
        return tokenType == null ? -1 : BraceMatchingUtil.getBraceMatcher(fileType, tokenType).getBraceTokenGroupId(tokenType);
    }

    public static int findLeftmostLParen(@NotNull HighlighterIterator iterator, @NotNull IElementType lparenTokenType, @NotNull CharSequence fileText, @NotNull FileType fileType) {
        return BraceMatchingUtil.findLeftOrRightParenth(iterator, lparenTokenType, fileText, fileType, false, false);
    }

    public static int findLeftLParen(@NotNull HighlighterIterator iterator, @NotNull IElementType lparenTokenType, @NotNull CharSequence fileText, @NotNull FileType fileType) {
        return BraceMatchingUtil.findLeftOrRightParenth(iterator, lparenTokenType, fileText, fileType, false, true);
    }

    public static int findRightmostRParen(@NotNull HighlighterIterator iterator, @NotNull IElementType rparenTokenType, @NotNull CharSequence fileText, @NotNull FileType fileType) {
        return BraceMatchingUtil.findLeftOrRightParenth(iterator, rparenTokenType, fileText, fileType, true, false);
    }

    private static int findLeftOrRightParenth(@NotNull HighlighterIterator iterator, @NotNull IElementType targetParenTokenType, @NotNull CharSequence fileText, @NotNull FileType fileType, boolean searchingForRight, boolean stopOnFirstFinishedGroup) {
        int lastBraceOffset = -1;
        Stack braceStack = new Stack();
        while (!iterator.atEnd()) {
            IElementType tokenType = iterator.getTokenType();
            if (BraceMatchingUtil.isBraceToken(iterator, fileText, fileType, searchingForRight)) {
                if (braceStack.isEmpty()) {
                    if (tokenType != targetParenTokenType) break;
                    lastBraceOffset = iterator.getStart();
                    if (stopOnFirstFinishedGroup) {
                        break;
                    }
                } else {
                    IElementType topToken = (IElementType)braceStack.pop();
                    if (!BraceMatchingUtil.isPairBraces(tokenType, topToken, fileType)) {
                        break;
                    }
                }
            } else if (BraceMatchingUtil.isBraceToken(iterator, fileText, fileType, !searchingForRight)) {
                braceStack.push((Object)iterator.getTokenType());
            }
            BraceMatchingUtil.advance(iterator, searchingForRight);
        }
        return lastBraceOffset;
    }

    private static boolean isBraceToken(@NotNull HighlighterIterator iterator, @NotNull CharSequence fileText, @NotNull FileType fileType, boolean searchingForRight) {
        return searchingForRight ? BraceMatchingUtil.isRBraceToken(iterator, fileText, fileType) : BraceMatchingUtil.isLBraceToken(iterator, fileText, fileType);
    }

    private static void advance(@NotNull HighlighterIterator iterator, boolean forward) {
        if (forward) {
            iterator.advance();
        } else {
            iterator.retreat();
        }
    }

    @NotNull
    public static BraceMatcher getBraceMatcher(@NotNull FileType fileType, @NotNull HighlighterIterator iterator) {
        IElementType tokenType = iterator.getTokenType();
        return tokenType == null ? BraceMatcherHolder.ourDefaultBraceMatcher : BraceMatchingUtil.getBraceMatcher(fileType, tokenType);
    }

    @NotNull
    public static BraceMatcher getBraceMatcher(@NotNull FileType fileType, @NotNull IElementType type) {
        return BraceMatchingUtil.getBraceMatcher(fileType, type.getLanguage());
    }

    @NotNull
    public static BraceMatcher getBraceMatcher(@NotNull FileType fileType, @NotNull Language lang) {
        Language language;
        PairedBraceMatcher matcher = (PairedBraceMatcher)LanguageBraceMatching.INSTANCE.forLanguage(lang);
        if (matcher != null) {
            if (matcher instanceof XmlAwareBraceMatcher) {
                return (XmlAwareBraceMatcher)matcher;
            }
            if (matcher instanceof PairedBraceMatcherAdapter) {
                return (BraceMatcher)matcher;
            }
            return new PairedBraceMatcherAdapter(matcher, lang);
        }
        BraceMatcher byFileType = BraceMatchingUtil.getBraceMatcherByFileType(fileType);
        if (byFileType != null) {
            return byFileType;
        }
        if (fileType instanceof LanguageFileType && lang != (language = ((LanguageFileType)fileType).getLanguage())) {
            BraceMatcher braceMatcher;
            LanguageFileType type1 = lang.getAssociatedFileType();
            if (type1 != null && (braceMatcher = BraceMatchingUtil.getBraceMatcherByFileType((FileType)type1)) != null) {
                return braceMatcher;
            }
            matcher = (PairedBraceMatcher)LanguageBraceMatching.INSTANCE.forLanguage(language);
            if (matcher != null) {
                return new PairedBraceMatcherAdapter(matcher, language);
            }
        }
        return BraceMatcherHolder.ourDefaultBraceMatcher;
    }

    @Nullable
    private static BraceMatcher getBraceMatcherByFileType(@NotNull FileType fileType) {
        BraceMatcher braceMatcher = BRACE_MATCHERS.get(fileType);
        if (braceMatcher == BraceMatcherHolder.nullBraceMatcher) {
            return null;
        }
        if (braceMatcher != null) {
            return braceMatcher;
        }
        for (FileTypeExtensionPoint ext : BraceMatcher.EP_NAME.getExtensionList()) {
            if (!fileType.getName().equals(ext.filetype)) continue;
            braceMatcher = (BraceMatcher)ext.getInstance();
            BRACE_MATCHERS.put(fileType, braceMatcher);
            return braceMatcher;
        }
        BRACE_MATCHERS.put(fileType, BraceMatcherHolder.nullBraceMatcher);
        return null;
    }

    private static boolean isStrictTagMatching(@NotNull BraceMatcher matcher, @NotNull FileType fileType, int group) {
        return matcher instanceof XmlAwareBraceMatcher && ((XmlAwareBraceMatcher)matcher).isStrictTagMatching(fileType, group);
    }

    private static boolean areTagsCaseSensitive(@NotNull BraceMatcher matcher, @NotNull FileType fileType, int tokenGroup) {
        return matcher instanceof XmlAwareBraceMatcher && ((XmlAwareBraceMatcher)matcher).areTagsCaseSensitive(fileType, tokenGroup);
    }

    @Nullable
    private static String getTagName(@NotNull BraceMatcher matcher, @NotNull CharSequence fileText, @NotNull HighlighterIterator iterator) {
        if (matcher instanceof XmlAwareBraceMatcher) {
            return ((XmlAwareBraceMatcher)matcher).getTagName(fileText, iterator);
        }
        return null;
    }

    public static final class BraceHighlightingAndNavigationContext {
        public final int currentBraceOffset;
        public final int navigationOffset;

        public BraceHighlightingAndNavigationContext(int currentBraceOffset, int navigationOffset) {
            this.currentBraceOffset = currentBraceOffset;
            this.navigationOffset = navigationOffset;
        }
    }

    private static class DefaultBraceMatcher
    implements BraceMatcher {
        private DefaultBraceMatcher() {
        }

        @Override
        public int getBraceTokenGroupId(IElementType tokenType) {
            return -1;
        }

        @Override
        public boolean isLBraceToken(HighlighterIterator iterator, CharSequence fileText, FileType fileType) {
            return false;
        }

        @Override
        public boolean isRBraceToken(HighlighterIterator iterator, CharSequence fileText, FileType fileType) {
            return false;
        }

        @Override
        public boolean isPairBraces(IElementType tokenType, IElementType tokenType2) {
            return false;
        }

        @Override
        public boolean isStructuralBrace(HighlighterIterator iterator, CharSequence text, FileType fileType) {
            return false;
        }

        @Override
        public IElementType getOppositeBraceTokenType(@NotNull IElementType type) {
            return null;
        }

        @Override
        public boolean isPairedBracesAllowedBeforeType(@NotNull IElementType lbraceType, @Nullable IElementType contextType) {
            return true;
        }

        @Override
        public int getCodeConstructStart(PsiFile file2, int openingBraceOffset) {
            return openingBraceOffset;
        }
    }

    private static class BraceMatcherHolder {
        private static final BraceMatcher ourDefaultBraceMatcher = new DefaultBraceMatcher();
        private static final BraceMatcher nullBraceMatcher = new DefaultBraceMatcher();

        private BraceMatcherHolder() {
        }
    }

    private static class MatchBraceContext {
        private final CharSequence fileText;
        private final FileType fileType;
        private final HighlighterIterator iterator;
        private final boolean forward;
        private final IElementType brace1Token;
        private final int group;
        private final String brace1TagName;
        private final boolean isStrict;
        private final boolean isCaseSensitive;
        @NotNull
        private final BraceMatcher myMatcher;
        private final Stack<IElementType> myBraceStack = new Stack();
        private final Stack<String> myTagNameStack = new Stack();

        MatchBraceContext(@NotNull CharSequence fileText, @NotNull FileType fileType, @NotNull HighlighterIterator iterator, boolean forward) {
            this(fileText, fileType, iterator, forward, BraceMatchingUtil.isStrictTagMatching(BraceMatchingUtil.getBraceMatcher(fileType, iterator), fileType, BraceMatchingUtil.getTokenGroup(iterator.getTokenType(), fileType)));
        }

        MatchBraceContext(@NotNull CharSequence fileText, @NotNull FileType fileType, @NotNull HighlighterIterator iterator, boolean forward, boolean strict) {
            this.fileText = fileText;
            this.fileType = fileType;
            this.iterator = iterator;
            this.forward = forward;
            this.myMatcher = BraceMatchingUtil.getBraceMatcher(fileType, iterator);
            this.brace1Token = this.iterator.getTokenType();
            this.group = BraceMatchingUtil.getTokenGroup(this.brace1Token, this.fileType);
            this.brace1TagName = BraceMatchingUtil.getTagName(this.myMatcher, this.fileText, this.iterator);
            this.isCaseSensitive = BraceMatchingUtil.areTagsCaseSensitive(this.myMatcher, this.fileType, this.group);
            this.isStrict = strict;
        }

        boolean doBraceMatch() {
            boolean matched;
            block10: {
                this.myBraceStack.clear();
                this.myTagNameStack.clear();
                this.myBraceStack.push((Object)this.brace1Token);
                if (this.isStrict) {
                    this.myTagNameStack.push((Object)this.brace1TagName);
                }
                matched = false;
                while (true) {
                    BraceMatchingUtil.advance(this.iterator, this.forward);
                    if (this.iterator.atEnd()) break block10;
                    IElementType tokenType = this.iterator.getTokenType();
                    if (BraceMatchingUtil.getTokenGroup(tokenType, this.fileType) != this.group) continue;
                    String tagName = BraceMatchingUtil.getTagName(this.myMatcher, this.fileText, this.iterator);
                    if (!this.isStrict && !Comparing.equal((String)this.brace1TagName, (String)tagName, (boolean)this.isCaseSensitive)) continue;
                    if (BraceMatchingUtil.isBraceToken(this.iterator, this.fileText, this.fileType, !this.forward)) {
                        this.myBraceStack.push((Object)tokenType);
                        if (!this.isStrict) continue;
                        this.myTagNameStack.push((Object)tagName);
                        continue;
                    }
                    if (!BraceMatchingUtil.isBraceToken(this.iterator, this.fileText, this.fileType, this.forward)) continue;
                    IElementType topTokenType = (IElementType)this.myBraceStack.pop();
                    String topTagName = null;
                    if (this.isStrict) {
                        topTagName = (String)this.myTagNameStack.pop();
                    }
                    if (!this.isStrict) {
                        IElementType baseType = this.myMatcher.getOppositeBraceTokenType(tokenType);
                        if (this.myBraceStack.contains((Object)baseType)) {
                            while (!BraceMatchingUtil.isPairBraces(topTokenType, tokenType, this.fileType) && !this.myBraceStack.empty()) {
                                topTokenType = (IElementType)this.myBraceStack.pop();
                            }
                        } else if (!(this.brace1TagName != null && this.brace1TagName.equals(tagName) || BraceMatchingUtil.isPairBraces(topTokenType, tokenType, this.fileType))) {
                            this.myBraceStack.push((Object)topTokenType);
                            continue;
                        }
                    }
                    if (!BraceMatchingUtil.isPairBraces(topTokenType, tokenType, this.fileType) || this.isStrict && !Comparing.equal((String)topTagName, (String)tagName, (boolean)this.isCaseSensitive)) {
                        matched = false;
                        break block10;
                    }
                    if (this.myBraceStack.isEmpty()) break;
                }
                matched = true;
            }
            return matched;
        }
    }
}

