/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
public interface CodeBlockSupportHandler {
    public static final LanguageExtension<CodeBlockSupportHandler> EP = new LanguageExtension("com.intellij.codeBlockSupportHandler");

    @NotNull
    public List<TextRange> getCodeBlockMarkerRanges(@NotNull PsiElement var1);

    @NotNull
    public TextRange getCodeBlockRange(@NotNull PsiElement var1);

    @NotNull
    public static TextRange findCodeBlockRange(@NotNull Editor editor, @NotNull PsiFile psiFile) {
        PsiElement contextElement = psiFile.findElementAt(TargetElementUtil.adjustOffset(psiFile, editor.getDocument(), editor.getCaretModel().getOffset()));
        if (contextElement == null) {
            return TextRange.EMPTY_RANGE;
        }
        for (CodeBlockSupportHandler handler2 : EP.allForLanguage(contextElement.getLanguage())) {
            TextRange codeBlockRange = handler2.getCodeBlockRange(contextElement);
            if (codeBlockRange.isEmpty()) continue;
            return codeBlockRange;
        }
        return TextRange.EMPTY_RANGE;
    }
}

