/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;

public abstract class HighlightHandlerBase {
    static void setupFindModel(Project project) {
        FindManager findManager = FindManager.getInstance((Project)project);
        FindModel model = findManager.getFindNextModel();
        if (model == null) {
            model = findManager.getFindInFileModel();
        }
        model.setSearchHighlighters(true);
        findManager.setFindWasPerformed();
        findManager.setFindNextModel(model);
    }

    public static String getLineTextErrorStripeTooltip(Document document, int offset, boolean escape) {
        int lineNumber = document.getLineNumber(offset);
        int lineStartOffset = document.getLineStartOffset(lineNumber);
        int lineEndOffset = document.getLineEndOffset(lineNumber);
        int lineFragmentEndOffset = Math.min(lineStartOffset + 140, lineEndOffset);
        String lineText = document.getImmutableCharSequence().subSequence(lineStartOffset, lineFragmentEndOffset).toString();
        if (lineFragmentEndOffset != lineEndOffset) {
            lineText = lineText.trim() + "...";
        }
        return "  " + (escape ? StringUtil.escapeXmlEntities((String)lineText.trim()) : lineText.trim()) + "  ";
    }
}

