/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.util.BitUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightManagerImpl
extends HighlightManager {
    private final Project myProject;
    private final Key<Map<RangeHighlighter, HighlightInfo>> HIGHLIGHT_INFO_MAP_KEY = Key.create((String)"HIGHLIGHT_INFO_MAP_KEY");

    public HighlightManagerImpl(Project project, ActionManagerEx actionManagerEx, EditorFactory editorFactory) {
        this.myProject = project;
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this.myProject).subscribe(AnActionListener.TOPIC, (Object)new MyAnActionListener());
        DocumentListener documentListener = new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                Editor[] editors;
                Document document = event.getDocument();
                for (Editor editor : editors = EditorFactory.getInstance().getEditors(document)) {
                    Map map2 = HighlightManagerImpl.this.getHighlightInfoMap(editor, false);
                    if (map2 == null) {
                        return;
                    }
                    ArrayList<RangeHighlighter> highlightersToRemove = new ArrayList<RangeHighlighter>();
                    for (RangeHighlighter highlighter : map2.keySet()) {
                        HighlightInfo info = (HighlightInfo)map2.get(highlighter);
                        if (!info.editor.getDocument().equals(document) || !BitUtil.isSet((int)info.flags, (int)4)) continue;
                        highlightersToRemove.add(highlighter);
                    }
                    for (RangeHighlighter highlighter : highlightersToRemove) {
                        HighlightManagerImpl.this.removeSegmentHighlighter(editor, highlighter);
                    }
                }
            }
        };
        editorFactory.getEventMulticaster().addDocumentListener(documentListener, (Disposable)this.myProject);
    }

    @Nullable
    private Map<RangeHighlighter, HighlightInfo> getHighlightInfoMap(@NotNull Editor editor, boolean toCreate) {
        Map map2;
        if (editor instanceof EditorWindow) {
            editor = ((EditorWindow)editor).getDelegate();
        }
        if ((map2 = (Map)editor.getUserData(this.HIGHLIGHT_INFO_MAP_KEY)) == null && toCreate) {
            map2 = (Map)((UserDataHolderEx)editor).putUserDataIfAbsent(this.HIGHLIGHT_INFO_MAP_KEY, new HashMap());
        }
        return map2;
    }

    @NotNull
    public RangeHighlighter[] getHighlighters(@NotNull Editor editor) {
        Map<RangeHighlighter, HighlightInfo> highlightersMap = this.getHighlightInfoMap(editor, false);
        if (highlightersMap == null) {
            return RangeHighlighter.EMPTY_ARRAY;
        }
        HashSet<RangeHighlighter> set2 = new HashSet<RangeHighlighter>();
        for (Map.Entry<RangeHighlighter, HighlightInfo> entry : highlightersMap.entrySet()) {
            HighlightInfo info = entry.getValue();
            if (!info.editor.equals(editor)) continue;
            set2.add(entry.getKey());
        }
        return set2.toArray(RangeHighlighter.EMPTY_ARRAY);
    }

    private RangeHighlighter addSegmentHighlighter(@NotNull Editor editor, int startOffset, int endOffset, TextAttributes attributes, @HighlightManager.HideFlags int flags) {
        RangeHighlighter highlighter = editor.getMarkupModel().addRangeHighlighter(startOffset, endOffset, 5999, attributes, HighlighterTargetArea.EXACT_RANGE);
        HighlightInfo info = new HighlightInfo(editor instanceof EditorWindow ? ((EditorWindow)editor).getDelegate() : editor, flags);
        Map<RangeHighlighter, HighlightInfo> map2 = this.getHighlightInfoMap(editor, true);
        map2.put(highlighter, info);
        return highlighter;
    }

    public boolean removeSegmentHighlighter(@NotNull Editor editor, @NotNull RangeHighlighter highlighter) {
        Map<RangeHighlighter, HighlightInfo> map2 = this.getHighlightInfoMap(editor, false);
        if (map2 == null) {
            return false;
        }
        HighlightInfo info = map2.get(highlighter);
        if (info == null) {
            return false;
        }
        MarkupModel markupModel = info.editor.getMarkupModel();
        if (((MarkupModelEx)markupModel).containsHighlighter(highlighter)) {
            highlighter.dispose();
        }
        map2.remove(highlighter);
        return true;
    }

    public void addOccurrenceHighlights(@NotNull Editor editor, @NotNull PsiReference[] occurrences, @NotNull TextAttributes attributes, boolean hideByTextChange, Collection<RangeHighlighter> outHighlighters) {
        if (occurrences.length == 0) {
            return;
        }
        int flags = 1;
        if (hideByTextChange) {
            flags |= 4;
        }
        Color scrollMarkColor = HighlightManagerImpl.getScrollMarkColor(attributes, editor.getColorsScheme());
        int oldOffset = editor.getCaretModel().getOffset();
        int horizontalScrollOffset = editor.getScrollingModel().getHorizontalScrollOffset();
        int verticalScrollOffset = editor.getScrollingModel().getVerticalScrollOffset();
        for (PsiReference occurrence : occurrences) {
            Project project;
            PsiElement element = occurrence.getElement();
            int startOffset = element.getTextRange().getStartOffset();
            int start2 = startOffset + occurrence.getRangeInElement().getStartOffset();
            int end = startOffset + occurrence.getRangeInElement().getEndOffset();
            PsiFile containingFile = element.getContainingFile();
            Editor textEditor = InjectedLanguageUtil.openEditorFor(containingFile, project = element.getProject());
            if (textEditor == null) continue;
            this.addOccurrenceHighlight(textEditor, start2, end, attributes, flags, outHighlighters, scrollMarkColor);
        }
        editor.getCaretModel().moveToOffset(oldOffset);
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        editor.getScrollingModel().scrollHorizontally(horizontalScrollOffset);
        editor.getScrollingModel().scrollVertically(verticalScrollOffset);
    }

    public void addOccurrenceHighlight(@NotNull Editor editor, int start2, int end, TextAttributes attributes, int flags, Collection<RangeHighlighter> outHighlighters, Color scrollMarkColor) {
        RangeHighlighter highlighter = this.addSegmentHighlighter(editor, start2, end, attributes, flags);
        if (highlighter instanceof RangeHighlighterEx) {
            ((RangeHighlighterEx)highlighter).setVisibleIfFolded(true);
        }
        if (outHighlighters != null) {
            outHighlighters.add(highlighter);
        }
        if (scrollMarkColor != null) {
            highlighter.setErrorStripeMarkColor(scrollMarkColor);
        }
    }

    public void addRangeHighlight(@NotNull Editor editor, int startOffset, int endOffset, @NotNull TextAttributes attributes, boolean hideByTextChange, @Nullable Collection<RangeHighlighter> highlighters) {
        this.addRangeHighlight(editor, startOffset, endOffset, attributes, hideByTextChange, false, highlighters);
    }

    public void addRangeHighlight(@NotNull Editor editor, int startOffset, int endOffset, @NotNull TextAttributes attributes, boolean hideByTextChange, boolean hideByAnyKey, @Nullable Collection<RangeHighlighter> highlighters) {
        int flags = 1;
        if (hideByTextChange) {
            flags |= 4;
        }
        if (hideByAnyKey) {
            flags |= 2;
        }
        Color scrollMarkColor = HighlightManagerImpl.getScrollMarkColor(attributes, editor.getColorsScheme());
        this.addOccurrenceHighlight(editor, startOffset, endOffset, attributes, flags, highlighters, scrollMarkColor);
    }

    public void addOccurrenceHighlights(@NotNull Editor editor, @NotNull PsiElement[] elements, @NotNull TextAttributes attributes, boolean hideByTextChange, Collection<RangeHighlighter> outHighlighters) {
        if (elements.length == 0) {
            return;
        }
        int flags = 1;
        if (hideByTextChange) {
            flags |= 4;
        }
        Color scrollMarkColor = HighlightManagerImpl.getScrollMarkColor(attributes, editor.getColorsScheme());
        if (editor instanceof EditorWindow) {
            editor = ((EditorWindow)editor).getDelegate();
        }
        for (PsiElement element : elements) {
            TextRange range2 = element.getTextRange();
            range2 = InjectedLanguageManager.getInstance((Project)this.myProject).injectedToHost(element, range2);
            this.addOccurrenceHighlight(editor, HighlightManagerImpl.trimOffsetToDocumentSize(editor, range2.getStartOffset()), HighlightManagerImpl.trimOffsetToDocumentSize(editor, range2.getEndOffset()), attributes, flags, outHighlighters, scrollMarkColor);
        }
    }

    private static int trimOffsetToDocumentSize(@NotNull Editor editor, int offset) {
        if (offset < 0) {
            return 0;
        }
        int textLength = editor.getDocument().getTextLength();
        return offset < textLength ? offset : textLength;
    }

    @Nullable
    private static Color getScrollMarkColor(@NotNull TextAttributes attributes, @NotNull EditorColorsScheme colorScheme) {
        if (attributes.getErrorStripeColor() != null) {
            return attributes.getErrorStripeColor();
        }
        if (attributes.getBackgroundColor() != null) {
            boolean isDark = ColorUtil.isDark((Color)colorScheme.getDefaultBackground());
            return isDark ? attributes.getBackgroundColor().brighter() : attributes.getBackgroundColor().darker();
        }
        return null;
    }

    public boolean hideHighlights(@NotNull Editor editor, @HighlightManager.HideFlags int mask) {
        Map<RangeHighlighter, HighlightInfo> map2 = this.getHighlightInfoMap(editor, false);
        if (map2 == null) {
            return false;
        }
        boolean done = false;
        ArrayList<RangeHighlighter> highlightersToRemove = new ArrayList<RangeHighlighter>();
        for (RangeHighlighter highlighter : map2.keySet()) {
            HighlightInfo info = map2.get(highlighter);
            if (!info.editor.equals(editor) || (info.flags & mask) == 0) continue;
            highlightersToRemove.add(highlighter);
            done = true;
        }
        for (RangeHighlighter highlighter : highlightersToRemove) {
            this.removeSegmentHighlighter(editor, highlighter);
        }
        return done;
    }

    boolean hasHideByEscapeHighlighters(@NotNull Editor editor) {
        Map<RangeHighlighter, HighlightInfo> map2 = this.getHighlightInfoMap(editor, false);
        if (map2 != null) {
            for (HighlightInfo info : map2.values()) {
                if (!info.editor.equals(editor) || (info.flags & 1) == 0) continue;
                return true;
            }
        }
        return false;
    }

    private static class HighlightInfo {
        final Editor editor;
        @HighlightManager.HideFlags
        final int flags;

        HighlightInfo(Editor editor, @HighlightManager.HideFlags int flags) {
            this.editor = editor;
            this.flags = flags;
        }
    }

    private class MyAnActionListener
    implements AnActionListener {
        private MyAnActionListener() {
        }

        public void beforeActionPerformed(@NotNull AnAction action, @NotNull DataContext dataContext, @NotNull AnActionEvent event) {
            this.requestHideHighlights(dataContext);
        }

        public void beforeEditorTyping(char c, @NotNull DataContext dataContext) {
            this.requestHideHighlights(dataContext);
        }

        private void requestHideHighlights(@NotNull DataContext dataContext) {
            Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
            if (editor == null) {
                return;
            }
            HighlightManagerImpl.this.hideHighlights(editor, 2);
        }
    }
}

