/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerFactory;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HighlightUsagesHandlerFactoryBase
implements HighlightUsagesHandlerFactory {
    @Override
    @Nullable
    public final HighlightUsagesHandlerBase createHighlightUsagesHandler(@NotNull Editor editor, @NotNull PsiFile file2) {
        PsiElement target2 = HighlightUsagesHandlerFactoryBase.findTarget(editor, file2);
        if (target2 == null) {
            return null;
        }
        return this.createHighlightUsagesHandler(editor, file2, target2);
    }

    @Override
    @Nullable
    public final HighlightUsagesHandlerBase createHighlightUsagesHandler(@NotNull Editor editor, @NotNull PsiFile file2, @NotNull ProperTextRange visibleRange) {
        PsiElement target2 = HighlightUsagesHandlerFactoryBase.findTarget(editor, file2);
        if (target2 == null) {
            return null;
        }
        return this.createHighlightUsagesHandler(editor, file2, target2, visibleRange);
    }

    @Nullable
    public abstract HighlightUsagesHandlerBase createHighlightUsagesHandler(@NotNull Editor var1, @NotNull PsiFile var2, @NotNull PsiElement var3);

    @Nullable
    public HighlightUsagesHandlerBase createHighlightUsagesHandler(@NotNull Editor editor, @NotNull PsiFile file2, @NotNull PsiElement target2, @NotNull ProperTextRange visibleRange) {
        return this.createHighlightUsagesHandler(editor, file2, target2);
    }

    private static PsiElement findTarget(@NotNull Editor editor, @NotNull PsiFile file2) {
        int offset = TargetElementUtil.adjustOffset(file2, editor.getDocument(), editor.getCaretModel().getOffset());
        return file2.findElementAt(offset);
    }
}

