/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.ide.IdeBundle;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.paths.WebReference;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;

public class HyperlinkAnnotator
implements Annotator {
    private static final Key<String> messageKey = Key.create((String)"hyperlink.message");

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (holder.isBatchMode()) {
            return;
        }
        for (PsiReference reference : element.getReferences()) {
            if (!(reference instanceof WebReference)) continue;
            String message = (String)holder.getCurrentAnnotationSession().getUserData(messageKey);
            if (message == null) {
                message = HyperlinkAnnotator.getMessage();
                holder.getCurrentAnnotationSession().putUserData(messageKey, (Object)message);
            }
            TextRange range2 = reference.getRangeInElement().shiftRight(element.getTextRange().getStartOffset());
            Annotation annotation = holder.createInfoAnnotation(range2, message);
            annotation.setTextAttributes(CodeInsightColors.INACTIVE_HYPERLINK_ATTRIBUTES);
        }
    }

    @NotNull
    private static String getMessage() {
        Shortcut keyboardShortcut;
        String message = IdeBundle.message((String)"open.url.in.browser.tooltip", (Object[])new Object[0]);
        Object[] shortcuts = KeymapManager.getInstance().getActiveKeymap().getShortcuts("GotoDeclaration");
        String shortcutText = "";
        Shortcut mouseShortcut = (Shortcut)ContainerUtil.find((Object[])shortcuts, shortcut -> !shortcut.isKeyboard());
        if (mouseShortcut != null) {
            shortcutText = shortcutText + KeymapUtil.getShortcutText((Shortcut)mouseShortcut);
            shortcutText = shortcutText.replace("Button1 ", "");
        }
        if ((keyboardShortcut = (Shortcut)ContainerUtil.find((Object[])shortcuts, shortcut -> shortcut.isKeyboard())) != null) {
            if (!shortcutText.isEmpty()) {
                shortcutText = shortcutText + ", ";
            }
            shortcutText = shortcutText + KeymapUtil.getShortcutText((Shortcut)keyboardShortcut);
        }
        if (!shortcutText.isEmpty()) {
            message = message + " (" + shortcutText + ")";
        }
        return message;
    }
}

