/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

public class ReadWriteUtil {
    public static ReadWriteAccessDetector.Access getReadWriteAccess(@NotNull PsiElement[] primaryElements, @NotNull PsiElement element) {
        for (ReadWriteAccessDetector detector : ReadWriteAccessDetector.EP_NAME.getExtensionList()) {
            if (!ReadWriteUtil.isReadWriteAccessibleElements(primaryElements, detector)) continue;
            return detector.getExpressionAccess(element);
        }
        return null;
    }

    private static boolean isReadWriteAccessibleElements(@NotNull PsiElement[] primaryElements, @NotNull ReadWriteAccessDetector detector) {
        for (PsiElement element : primaryElements) {
            if (detector.isReadWriteAccessible(element)) continue;
            return false;
        }
        return true;
    }
}

