/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting.actions;

import com.intellij.codeInsight.highlighting.HighlightUsagesHandler;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class HighlightUsagesAction
extends AnAction
implements DumbAware {
    public HighlightUsagesAction() {
        this.setInjectedContext(true);
    }

    public void update(@NotNull AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        presentation.setEnabled(e.getProject() != null && CommonDataKeys.EDITOR.getData(e.getDataContext()) != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(e.getDataContext());
        Project project = e.getProject();
        if (editor == null || project == null) {
            return;
        }
        String commandName = this.getTemplatePresentation().getText();
        if (commandName == null) {
            commandName = "";
        }
        CommandProcessor.getInstance().executeCommand(project, () -> {
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
            try {
                HighlightUsagesHandler.invoke(project, editor, psiFile);
            }
            catch (IndexNotReadyException ex) {
                DumbService.getInstance((Project)project).showDumbModeNotification(ActionsBundle.message((String)"action.HighlightUsagesInFile.not.ready", (Object[])new Object[0]));
            }
        }, commandName, null);
    }
}

