/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.hint.DeclarationRangeHandler;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.MixinExtension;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeclarationRangeUtil {
    @NotNull
    public static TextRange getDeclarationRange(@NotNull PsiElement container) {
        TextRange textRange = DeclarationRangeUtil.getPossibleDeclarationAtRange(container);
        assert (textRange != null) : "Declaration range is invalid for " + container.getClass();
        return textRange;
    }

    @Nullable
    public static TextRange getPossibleDeclarationAtRange(@NotNull PsiElement container) {
        DeclarationRangeHandler handler2 = (DeclarationRangeHandler)MixinExtension.getInstance((ExtensionPointName)DeclarationRangeHandler.EP_NAME, (Object)container);
        return handler2 != null ? handler2.getDeclarationRange(container) : null;
    }
}

