/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.TooltipController;
import com.intellij.codeInsight.hint.TooltipGroup;
import com.intellij.codeInsight.hint.TooltipLinkHandlerEP;
import com.intellij.codeInsight.hint.TooltipRenderer;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.ide.TooltipEvent;
import com.intellij.ide.actions.ActionsCollector;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.ui.ComponentWithMnemonics;
import com.intellij.ui.HintHint;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.ListenerUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.Html;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextDelegate;
import com.intellij.util.ui.accessibility.ScreenReader;
import com.intellij.util.ui.update.ComparableObject;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LineTooltipRenderer
extends ComparableObject.Impl
implements TooltipRenderer {
    @NonNls
    @Nullable
    protected String myText;
    private volatile boolean myActiveLink;
    protected final int myCurrentWidth;

    public LineTooltipRenderer(@Nullable String text, @NotNull Object[] comparable) {
        this(text, 0, comparable);
    }

    public LineTooltipRenderer(@Nullable String text, int width, @NotNull Object[] comparable) {
        super(comparable);
        this.myCurrentWidth = width;
        this.myText = text;
    }

    @NotNull
    private static JPanel createMainPanel(@NotNull HintHint hintHint, @NotNull JComponent pane, final @NotNull JEditorPane editorPane) {
        JPanel grid = new JPanel((LayoutManager)new GridBagLayout()){

            @Override
            public AccessibleContext getAccessibleContext() {
                return new AccessibleContextDelegate(editorPane.getAccessibleContext()){

                    protected Container getDelegateParent() {
                        return this.getParent();
                    }
                };
            }
        };
        GridBag bag = new GridBag().anchor(10).weightx(1.0).weighty(1.0).fillCell();
        pane.setBorder((Border)JBUI.Borders.empty((int)6, (int)8, (int)6, (int)12));
        grid.add((Component)pane, bag);
        grid.setBackground(hintHint.getTextBackground());
        grid.setBorder((Border)JBUI.Borders.empty());
        grid.setOpaque(hintHint.isOpaqueAllowed());
        return grid;
    }

    @Override
    public LightweightHint show(final @NotNull Editor editor, @NotNull Point p, boolean alignToRight, @NotNull TooltipGroup group, final @NotNull HintHint hintHint) {
        if (this.myText == null) {
            return null;
        }
        String tooltipPreText = this.myText.replaceAll(String.valueOf('\u001b'), "");
        String dressedText = this.dressDescription(editor, tooltipPreText, this.myCurrentWidth > 0);
        final boolean expanded = this.myCurrentWidth > 0 && !dressedText.equals(tooltipPreText);
        HintManagerImpl hintManager = HintManagerImpl.getInstanceImpl();
        final JComponent contentComponent = editor.getContentComponent();
        JComponent editorComponent = editor.getComponent();
        if (!editorComponent.isShowing()) {
            return null;
        }
        JLayeredPane layeredPane = editorComponent.getRootPane().getLayeredPane();
        final JEditorPane editorPane = IdeTooltipManager.initPane(new Html(dressedText).setKeepFont(true), hintHint, layeredPane);
        hintHint.setContentActive(this.isContentAction(dressedText));
        if (!hintHint.isAwtTooltip()) {
            LineTooltipRenderer.correctLocation(editor, editorPane, p, alignToRight, expanded, this.myCurrentWidth);
        }
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)editorPane, (boolean)true);
        scrollPane.setHorizontalScrollBarPolicy(30);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setOpaque(hintHint.isOpaqueAllowed());
        scrollPane.getViewport().setOpaque(hintHint.isOpaqueAllowed());
        scrollPane.setBackground(hintHint.getTextBackground());
        scrollPane.getViewport().setBackground(hintHint.getTextBackground());
        scrollPane.setViewportBorder(null);
        editorPane.setBorder((Border)JBUI.Borders.emptyBottom((int)2));
        if (hintHint.isRequestFocus()) {
            editorPane.setFocusable(true);
        }
        final ArrayList actions = ContainerUtil.newArrayList();
        final JPanel grid = LineTooltipRenderer.createMainPanel(hintHint, scrollPane, editorPane);
        if (ScreenReader.isActive()) {
            grid.setFocusTraversalPolicyProvider(true);
            grid.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy(){

                @Override
                public Component getDefaultComponent(Container aContainer) {
                    return editorPane;
                }

                @Override
                public boolean getImplicitDownCycleTraversal() {
                    return true;
                }
            });
        }
        final LightweightHint hint = new LightweightHint(grid){

            @Override
            public void hide() {
                LineTooltipRenderer.this.onHide(editorPane);
                super.hide();
                for (AnAction action : actions) {
                    action.unregisterCustomShortcutSet(contentComponent);
                }
            }

            @Override
            protected boolean canAutoHideOn(TooltipEvent event) {
                if (!LineTooltipRenderer.this.canAutoHideOn(event)) {
                    return false;
                }
                return super.canAutoHideOn(event);
            }
        };
        final TooltipReloader reloader = toExpand -> this.reloadFor(hint, editor, p, editorPane, alignToRight, group, hintHint, toExpand);
        actions.add(new AnAction(){
            {
                this.registerCustomShortcutSet(KeymapUtil.getActiveKeymapShortcuts((String)"ShowErrorDescription"), contentComponent);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                hintHint.setRequestFocus(ScreenReader.isActive() && e.getInputEvent() instanceof KeyEvent);
                ActionsCollector.getInstance().record("tooltip.actions.show.description.shortcut", ((Object)((Object)this)).getClass());
                reloader.reload(!expanded);
            }
        });
        editorPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                LineTooltipRenderer.this.myActiveLink = true;
                if (e.getEventType() == HyperlinkEvent.EventType.EXITED) {
                    LineTooltipRenderer.this.myActiveLink = false;
                    return;
                }
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    URL url = e.getURL();
                    if (url != null) {
                        BrowserUtil.browse((URL)url);
                        hint.hide();
                        return;
                    }
                    String description = e.getDescription();
                    if (description != null && LineTooltipRenderer.handle(description, editor)) {
                        hint.hide();
                        return;
                    }
                    ActionsCollector.getInstance().record("tooltip.actions.show.description.morelink", this.getClass());
                    reloader.reload(!expanded);
                }
            }
        });
        this.fillPanel(editor, grid, hint, hintHint, actions, reloader);
        grid.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!LineTooltipRenderer.this.myActiveLink) {
                    MouseEvent newMouseEvent = SwingUtilities.convertMouseEvent(e.getComponent(), e, contentComponent);
                    hint.hide();
                    contentComponent.dispatchEvent(newMouseEvent);
                }
            }
        });
        ListenerUtil.addMouseListener(grid, new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                Container candidate;
                if (expanded) {
                    return;
                }
                Container parentContainer = grid;
                while (!(parentContainer instanceof ComponentWithMnemonics) && (candidate = parentContainer.getParent()) != null) {
                    parentContainer = candidate;
                }
                MouseEvent newMouseEvent = SwingUtilities.convertMouseEvent(e.getComponent(), e, parentContainer);
                if (parentContainer.contains(newMouseEvent.getPoint())) {
                    return;
                }
                hint.hide();
            }
        });
        hintManager.showEditorHint(hint, editor, p, 58, 0, false, hintHint);
        return hint;
    }

    protected boolean isContentAction(String dressedText) {
        return LineTooltipRenderer.isActiveHtml(dressedText);
    }

    protected boolean canAutoHideOn(@NotNull TooltipEvent event) {
        return true;
    }

    private void reloadFor(@NotNull LightweightHint hint, @NotNull Editor editor, @NotNull Point p, @NotNull JComponent pane, boolean alignToRight, @NotNull TooltipGroup group, @NotNull HintHint hintHint, boolean expand) {
        hint.hide();
        hintHint.setShowImmediately(true);
        TooltipController.getInstance().showTooltip(editor, new Point(p.x - 3, p.y - 3), this.createRenderer(this.myText, expand ? pane.getWidth() : 0), alignToRight, group, hintHint);
    }

    protected void fillPanel(@NotNull Editor editor, @NotNull JPanel component, @NotNull LightweightHint hint, @NotNull HintHint hintHint, @NotNull ArrayList<AnAction> actions, @NotNull TooltipReloader expandCallback) {
        hintHint.setComponentBorder((Border)JBUI.Borders.empty());
        hintHint.setBorderInsets((Insets)JBUI.insets((int)0));
    }

    private static boolean handle(@NotNull String ref, @NotNull Editor editor) {
        return TooltipLinkHandlerEP.handleLink(ref, editor);
    }

    public static void correctLocation(Editor editor, JComponent tooltipComponent, Point p, boolean alignToRight, boolean expanded, int currentWidth) {
        JComponent editorComponent = editor.getComponent();
        JLayeredPane layeredPane = editorComponent.getRootPane().getLayeredPane();
        int widthLimit = layeredPane.getWidth() - 10;
        int heightLimit = layeredPane.getHeight() - 5;
        Dimension dimension = LineTooltipRenderer.correctLocation(editor, p, alignToRight, expanded, tooltipComponent, layeredPane, widthLimit, heightLimit, currentWidth);
        tooltipComponent.setSize(dimension);
        tooltipComponent.setMaximumSize(dimension);
        tooltipComponent.setMinimumSize(dimension);
        tooltipComponent.setPreferredSize(dimension);
    }

    private static Dimension correctLocation(Editor editor, Point p, boolean alignToRight, boolean expanded, JComponent tooltipComponent, JLayeredPane layeredPane, int widthLimit, int heightLimit, int currentWidth) {
        Dimension preferredSize = tooltipComponent.getPreferredSize();
        int width = expanded ? 3 * currentWidth / 2 : preferredSize.width;
        int height = expanded ? Math.max(preferredSize.height, 150) : preferredSize.height;
        Dimension dimension = new Dimension(width, height);
        if (alignToRight) {
            p.x = Math.max(0, p.x - width);
        }
        p.x += 3;
        p.y += 3;
        if (p.x >= widthLimit - width) {
            p.x = widthLimit - width;
            width = Math.min(width, widthLimit);
            dimension = new Dimension(width, height += 20);
        }
        if (p.x < 3) {
            p.x = 3;
        }
        if (p.y > heightLimit - height) {
            p.y = heightLimit - height;
            height = Math.min(heightLimit, height);
            dimension = new Dimension(width, height);
        }
        if (p.y < 3) {
            p.y = 3;
        }
        LineTooltipRenderer.locateOutsideMouseCursor(editor, layeredPane, p, width, height, heightLimit);
        return dimension;
    }

    private static void locateOutsideMouseCursor(Editor editor, JComponent editorComponent, Point p, int width, int height, int heightLimit) {
        PointerInfo pointerInfo = MouseInfo.getPointerInfo();
        if (pointerInfo == null) {
            return;
        }
        Point mouse = pointerInfo.getLocation();
        SwingUtilities.convertPointFromScreen(mouse, editorComponent);
        Rectangle tooltipRect = new Rectangle(p, new Dimension(width, height));
        tooltipRect.setBounds(tooltipRect.x, tooltipRect.y - editor.getLineHeight(), width, height + 2 * editor.getLineHeight());
        if (tooltipRect.contains(mouse)) {
            p.y = mouse.y + height + editor.getLineHeight() > heightLimit && mouse.y - height - editor.getLineHeight() > 0 ? mouse.y - height - editor.getLineHeight() : mouse.y + editor.getLineHeight();
        }
    }

    protected void onHide(@NotNull JComponent contentComponent) {
    }

    @NotNull
    protected LineTooltipRenderer createRenderer(@Nullable String text, int width) {
        return new LineTooltipRenderer(text, width, this.getEqualityObjects());
    }

    @NotNull
    protected String dressDescription(@NotNull Editor editor, @NotNull String tooltipText, boolean expanded) {
        return tooltipText;
    }

    protected static boolean isActiveHtml(@NotNull String html) {
        return html.contains("</a>");
    }

    public void addBelow(@NotNull String text) {
        String newBody;
        if (this.myText == null) {
            newBody = UIUtil.getHtmlBody((String)text);
        } else {
            String html1 = UIUtil.getHtmlBody((String)this.myText);
            String html2 = UIUtil.getHtmlBody((String)text);
            newBody = html1 + "<hr size=1 noshade>" + html2;
        }
        this.myText = XmlStringUtil.wrapInHtml((CharSequence)newBody);
    }

    @Nullable
    public String getText() {
        return this.myText;
    }

    @FunctionalInterface
    protected static interface TooltipReloader {
        public void reload(boolean var1);
    }
}

