/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.codeInsight.hint.ParameterInfoController;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.ParameterInfoUIContextEx;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.Function;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParameterInfoComponent
extends JPanel {
    private Object[] myObjects;
    private int myCurrentParameterIndex;
    private PsiElement myParameterOwner;
    private Object myHighlighted;
    @NotNull
    private final ParameterInfoHandler myHandler;
    private final JPanel myMainPanel;
    private OneElementComponent[] myPanels;
    private JLabel myShortcutLabel;
    private final boolean myAllowSwitchLabel;
    private final Font NORMAL_FONT;
    private final Font BOLD_FONT;
    private static final Color BACKGROUND = JBColor.namedColor((String)"ParameterInfo.background", (Color)HintUtil.getInformationColor());
    private static final Color FOREGROUND = JBColor.namedColor((String)"ParameterInfo.foreground", (Color)new JBColor(0x1D1D1D, 0xBBBBBB));
    private static final Color HIGHLIGHTED_COLOR = JBColor.namedColor((String)"ParameterInfo.currentParameterForeground", (Color)new JBColor(0x1D1D1D, 0xE8E8E8));
    private static final Color DISABLED_COLOR = JBColor.namedColor((String)"ParameterInfo.disabledForeground", (Color)new JBColor(0xA8A8A8, 0x777777));
    private static final Color CONTEXT_HELP_FOREGROUND = JBColor.namedColor((String)"ParameterInfo.infoForeground", (Color)new JBColor(0x787878, 0x878787));
    static final Color BORDER_COLOR = JBColor.namedColor((String)"ParameterInfo.borderColor", (Color)HintUtil.INFORMATION_BORDER_COLOR);
    private static final Color HIGHLIGHTED_BACKGROUND = JBColor.namedColor((String)"ParameterInfo.currentOverloadBackground", (Color)BORDER_COLOR);
    private static final Color SEPARATOR_COLOR = JBColor.namedColor((String)"ParameterInfo.lineSeparatorColor", (Color)BORDER_COLOR);
    private static final Border EMPTY_BORDER = JBUI.Borders.empty((int)2, (int)10);
    private static final Border BOTTOM_BORDER = new CompoundBorder(JBUI.Borders.customLine((Color)SEPARATOR_COLOR, (int)0, (int)0, (int)1, (int)0), EMPTY_BORDER);
    protected int myWidthLimit = 500;
    private final int myMaxVisibleRows = Registry.intValue((String)"parameter.info.max.visible.rows");
    private static final Comparator<TextRange> TEXT_RANGE_COMPARATOR = (o1, o2) -> {
        if (o1.getStartOffset() == o2.getStartOffset()) {
            return o1.getEndOffset() > o2.getEndOffset() ? 1 : -1;
        }
        if (o1.getStartOffset() > o2.getStartOffset()) {
            return 1;
        }
        if (o1.getEndOffset() > o2.getEndOffset()) {
            return 1;
        }
        return -1;
    };
    private final boolean myRequestFocus;

    public static ParameterInfoUIContextEx createContext(Object[] objects, Editor editor, @NotNull ParameterInfoHandler handler2, int currentParameterIndex) {
        return ParameterInfoComponent.createContext(objects, editor, handler2, currentParameterIndex, null);
    }

    public static ParameterInfoUIContextEx createContext(Object[] objects, Editor editor, @NotNull ParameterInfoHandler handler2, int currentParameterIndex, @Nullable PsiElement parameterOwner) {
        ParameterInfoComponent infoComponent = new ParameterInfoComponent(objects, editor, handler2);
        infoComponent.setCurrentParameterIndex(currentParameterIndex);
        infoComponent.setParameterOwner(parameterOwner);
        ParameterInfoComponent parameterInfoComponent = infoComponent;
        parameterInfoComponent.getClass();
        return parameterInfoComponent.new MyParameterContext(false);
    }

    ParameterInfoComponent(Object[] objects, Editor editor, @NotNull ParameterInfoHandler handler2) {
        this(objects, editor, handler2, false, false);
    }

    ParameterInfoComponent(Object[] objects, Editor editor, @NotNull ParameterInfoHandler handler2, boolean requestFocus, boolean allowSwitchLabel) {
        super(new BorderLayout());
        this.myRequestFocus = requestFocus;
        if (!ApplicationManager.getApplication().isUnitTestMode() && !ApplicationManager.getApplication().isHeadlessEnvironment()) {
            JComponent editorComponent = editor.getComponent();
            JLayeredPane layeredPane = editorComponent.getRootPane().getLayeredPane();
            this.myWidthLimit = layeredPane.getWidth();
        }
        this.NORMAL_FONT = editor != null && Registry.is((String)"parameter.info.editor.font") ? editor.getColorsScheme().getFont(EditorFontType.PLAIN) : UIUtil.getLabelFont();
        this.BOLD_FONT = editor != null && Registry.is((String)"parameter.info.editor.font") ? editor.getColorsScheme().getFont(EditorFontType.BOLD) : this.NORMAL_FONT.deriveFont(1);
        this.myObjects = objects;
        this.setBackground(BACKGROUND);
        this.myHandler = handler2;
        this.myMainPanel = new JPanel(new GridBagLayout());
        this.setPanels();
        if (this.myRequestFocus) {
            AccessibleContextUtil.setName((Component)this, (String)"Parameter Info. Press TAB to navigate through each element. Press ESC to close.");
        }
        JScrollPane pane = ScrollPaneFactory.createScrollPane((Component)this.myMainPanel, (boolean)true);
        this.add((Component)pane, "Center");
        this.myAllowSwitchLabel = allowSwitchLabel && !(editor instanceof EditorWindow);
        this.setShortcutLabel();
        this.myCurrentParameterIndex = -1;
    }

    private void setPanels() {
        this.myMainPanel.removeAll();
        this.myPanels = new OneElementComponent[this.myObjects.length];
        for (int i = 0; i < this.myObjects.length; ++i) {
            this.myPanels[i] = new OneElementComponent();
            this.myMainPanel.add((Component)this.myPanels[i], new GridBagConstraints(0, i, 1, 1, 1.0, 0.0, 17, 2, (Insets)JBUI.emptyInsets(), 0, 0));
        }
    }

    private void setShortcutLabel() {
        if (this.myShortcutLabel != null) {
            this.remove(this.myShortcutLabel);
        }
        String upShortcut = KeymapUtil.getFirstKeyboardShortcutText((String)"MethodOverloadSwitchUp");
        String downShortcut = KeymapUtil.getFirstKeyboardShortcutText((String)"MethodOverloadSwitchDown");
        if (!this.myAllowSwitchLabel || this.myObjects.length <= 1 || !this.myHandler.supportsOverloadSwitching() || upShortcut.isEmpty() && downShortcut.isEmpty()) {
            this.myShortcutLabel = null;
        } else {
            this.myShortcutLabel = new JLabel(upShortcut.isEmpty() || downShortcut.isEmpty() ? CodeInsightBundle.message((String)"parameter.info.switch.overload.shortcuts.single", (Object[])new Object[]{upShortcut.isEmpty() ? downShortcut : upShortcut}) : CodeInsightBundle.message((String)"parameter.info.switch.overload.shortcuts", (Object[])new Object[]{upShortcut, downShortcut}));
            this.myShortcutLabel.setForeground(CONTEXT_HELP_FOREGROUND);
            Font labelFont = UIUtil.getLabelFont();
            this.myShortcutLabel.setFont(labelFont.deriveFont(labelFont.getSize2D() - (float)(SystemInfo.isWindows ? 1 : 2)));
            this.myShortcutLabel.setBorder((Border)JBUI.Borders.empty((int)6, (int)10, (int)0, (int)10));
            this.add((Component)this.myShortcutLabel, "South");
        }
    }

    void setDescriptors(Object[] descriptors) {
        this.myObjects = descriptors;
        this.setPanels();
        this.setShortcutLabel();
    }

    @Override
    public Dimension getPreferredSize() {
        long visibleRows = Stream.of(this.myPanels).filter(Component::isVisible).count();
        Dimension preferredSize = super.getPreferredSize();
        if (visibleRows <= (long)this.myMaxVisibleRows) {
            return preferredSize;
        }
        return new Dimension(preferredSize.width + 20, 200);
    }

    @Override
    public String toString() {
        return Stream.of(this.myPanels).filter(Component::isVisible).map(c -> c.toString() + (c.getBorder() == BOTTOM_BORDER ? "\n-" : "")).collect(Collectors.joining("\n"));
    }

    public Object getHighlighted() {
        return this.myHighlighted;
    }

    public boolean isRequestFocus() {
        return this.myRequestFocus;
    }

    public ParameterInfoController.Model update(boolean singleParameterInfo) {
        MyParameterContext context = new MyParameterContext(singleParameterInfo);
        for (int i = 0; i < this.myObjects.length; ++i) {
            context.i = i;
            Object o = this.myObjects[i];
            if (singleParameterInfo && this.myObjects.length > 1 && !context.isHighlighted()) {
                this.setVisible(i, false);
                continue;
            }
            this.setVisible(i, true);
            this.myHandler.updateUI(o, (ParameterInfoUIContext)context);
            if (!context.isHighlighted()) continue;
            this.myMainPanel.scrollRectToVisible(this.myPanels[i].getBounds());
        }
        if (this.myShortcutLabel != null) {
            this.myShortcutLabel.setVisible(!singleParameterInfo);
        }
        return context.result;
    }

    public Object[] getObjects() {
        return this.myObjects;
    }

    void setEnabled(int index, boolean enabled) {
        this.myPanels[index].setEnabled(enabled);
    }

    void setVisible(int index, boolean visible) {
        this.myPanels[index].setVisible(visible);
    }

    boolean isEnabled(int index) {
        return this.myPanels[index].isEnabled();
    }

    public void setCurrentParameterIndex(int currentParameterIndex) {
        this.myCurrentParameterIndex = currentParameterIndex;
    }

    public int getCurrentParameterIndex() {
        return this.myCurrentParameterIndex;
    }

    public void setParameterOwner(PsiElement element) {
        this.myParameterOwner = element;
    }

    public PsiElement getParameterOwner() {
        return this.myParameterOwner;
    }

    public void setHighlightedParameter(Object element) {
        this.myHighlighted = element;
    }

    private static String getOpeningTag(@NotNull String value) {
        return "<" + value + ">";
    }

    private static String getClosingTag(@NotNull String value) {
        int index = value.indexOf(32);
        return "</" + (0 <= index ? value.substring(0, index) : value) + ">";
    }

    private static String getTagValue(@NotNull ParameterInfoUIContextEx.Flag flag) {
        if (flag == ParameterInfoUIContextEx.Flag.HIGHLIGHT) {
            return "b color=" + ColorUtil.toHex((Color)HIGHLIGHTED_COLOR);
        }
        if (flag == ParameterInfoUIContextEx.Flag.DISABLE) {
            return "font color=" + ColorUtil.toHex((Color)DISABLED_COLOR);
        }
        if (flag == ParameterInfoUIContextEx.Flag.STRIKEOUT) {
            return "strike";
        }
        throw new IllegalArgumentException("flag=" + flag);
    }

    private class OneLineComponent
    extends JPanel {
        JLabel myLabel;
        private boolean isDisabledBeforeHighlight;

        private OneLineComponent() {
            super(new GridBagLayout());
            this.myLabel = new JLabel("", 2);
            this.isDisabledBeforeHighlight = false;
            this.myLabel.setOpaque(true);
            this.myLabel.setFont(ParameterInfoComponent.this.NORMAL_FONT);
            if (ParameterInfoComponent.this.myRequestFocus) {
                this.myLabel.setFocusable(true);
            }
            this.add((Component)this.myLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        }

        @Override
        public String toString() {
            return this.myLabel.getText();
        }

        private String setup(String text, boolean isDisabled, boolean isStrikeout, Color background, @Nullable TextRange range2) {
            TreeMap<TextRange, ParameterInfoUIContextEx.Flag> flagsMap = new TreeMap<TextRange, ParameterInfoUIContextEx.Flag>(TEXT_RANGE_COMPARATOR);
            if (range2 != null) {
                flagsMap.put(range2, ParameterInfoUIContextEx.Flag.HIGHLIGHT);
            }
            if (isDisabled) {
                flagsMap.put(TextRange.create((int)0, (int)text.length()), ParameterInfoUIContextEx.Flag.DISABLE);
            }
            if (isStrikeout) {
                flagsMap.put(TextRange.create((int)0, (int)text.length()), ParameterInfoUIContextEx.Flag.STRIKEOUT);
            }
            return this.setup(text, flagsMap, background);
        }

        private String setup(@NotNull String text, @NotNull Map<TextRange, ParameterInfoUIContextEx.Flag> flagsMap, @NotNull Color background) {
            if (flagsMap.isEmpty()) {
                return this.doSetup(text, background);
            }
            String labelText = this.buildLabelText(text, flagsMap);
            return this.doSetup(labelText, background);
        }

        private String doSetup(@NotNull String text, @NotNull Color background) {
            this.myLabel.setBackground(background);
            this.setBackground(background);
            this.myLabel.setForeground(FOREGROUND);
            this.myLabel.setText(XmlStringUtil.wrapInHtml((CharSequence)text));
            return this.myLabel.getText();
        }

        private String buildLabelText(@NotNull String text, @NotNull Map<TextRange, ParameterInfoUIContextEx.Flag> flagsMap) {
            StringBuilder labelText = new StringBuilder(text);
            String disabledTag = ParameterInfoComponent.getTagValue(ParameterInfoUIContextEx.Flag.DISABLE);
            HashMap<Integer, Integer> faultMap = new HashMap<Integer, Integer>();
            if (this.isDisabledBeforeHighlight) {
                String tag = ParameterInfoComponent.getOpeningTag(disabledTag);
                labelText.insert(0, tag);
                faultMap.put(0, tag.length());
            }
            for (Map.Entry<TextRange, ParameterInfoUIContextEx.Flag> entry : flagsMap.entrySet()) {
                TextRange highlightRange = entry.getKey();
                ParameterInfoUIContextEx.Flag flag = entry.getValue();
                String tagValue = ParameterInfoComponent.getTagValue(flag);
                String tag = ParameterInfoComponent.getOpeningTag(tagValue);
                int startOffset = highlightRange.getStartOffset();
                int endOffset = highlightRange.getEndOffset() + tag.length();
                for (Map.Entry entry1 : faultMap.entrySet()) {
                    if ((Integer)entry1.getKey() < highlightRange.getStartOffset()) {
                        startOffset += ((Integer)entry1.getValue()).intValue();
                    }
                    if ((Integer)entry1.getKey() >= highlightRange.getEndOffset()) continue;
                    endOffset += ((Integer)entry1.getValue()).intValue();
                }
                if (flag == ParameterInfoUIContextEx.Flag.HIGHLIGHT && this.isDisabledBeforeHighlight) {
                    String disableCloseTag = ParameterInfoComponent.getClosingTag(disabledTag);
                    labelText.insert(startOffset, disableCloseTag);
                    faultMap.put(highlightRange.getStartOffset(), disableCloseTag.length());
                }
                labelText.insert(startOffset, tag);
                faultMap.put(highlightRange.getStartOffset(), tag.length());
                String endTag = ParameterInfoComponent.getClosingTag(tagValue);
                labelText.insert(endOffset, endTag);
                faultMap.put(highlightRange.getEndOffset(), endTag.length());
            }
            return labelText.toString();
        }

        public void setDisabledBeforeHighlight() {
            this.isDisabledBeforeHighlight = true;
        }
    }

    private class OneElementComponent
    extends JPanel {
        private OneLineComponent[] myOneLineComponents;

        OneElementComponent() {
            super(new GridBagLayout());
            this.setOpaque(true);
            this.myOneLineComponents = new OneLineComponent[0];
        }

        @Override
        public String toString() {
            boolean highlighted = this.myOneLineComponents.length > 0 && !BACKGROUND.equals(this.myOneLineComponents[0].getBackground());
            String text = Stream.of(this.myOneLineComponents).filter(Objects::nonNull).map(Object::toString).collect(Collectors.joining());
            return highlighted ? '[' + text + ']' : text;
        }

        private void setup(String htmlText, Color background) {
            this.removeAll();
            this.setBackground(background);
            this.myOneLineComponents = new OneLineComponent[1];
            this.myOneLineComponents[0] = new OneLineComponent();
            this.myOneLineComponents[0].doSetup(htmlText, background);
            this.add((Component)this.myOneLineComponents[0], new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        }

        private String setup(String text, Function<? super String, String> escapeFunction, int highlightStartOffset, int highlightEndOffset, boolean isDisabled, boolean strikeout, boolean isDisabledBeforeHighlight, Color background) {
            StringBuilder buf = new StringBuilder();
            this.removeAll();
            this.setBackground(background);
            String[] lines2 = UIUtil.splitText((String)text, (FontMetrics)this.getFontMetrics(ParameterInfoComponent.this.BOLD_FONT), (int)ParameterInfoComponent.this.myWidthLimit, (char)',');
            this.myOneLineComponents = new OneLineComponent[lines2.length];
            int lineOffset = 0;
            boolean hasHighlighting = highlightStartOffset >= 0 && highlightEndOffset > highlightStartOffset;
            TextRange highlightingRange = hasHighlighting ? new TextRange(highlightStartOffset, highlightEndOffset) : null;
            for (int i = 0; i < lines2.length; ++i) {
                String line = lines2[i];
                this.myOneLineComponents[i] = new OneLineComponent();
                TextRange lRange = new TextRange(lineOffset, lineOffset + line.length());
                TextRange hr = highlightingRange == null ? null : lRange.intersection(highlightingRange);
                hr = hr == null ? null : hr.shiftRight(-lineOffset);
                String before = this.escapeString(hr == null ? line : line.substring(0, hr.getStartOffset()), escapeFunction);
                String in = hr == null ? "" : this.escapeString(hr.substring(line), escapeFunction);
                String after = hr == null ? "" : this.escapeString(line.substring(hr.getEndOffset()), escapeFunction);
                TextRange escapedHighlightingRange = in.isEmpty() ? null : TextRange.create((int)before.length(), (int)(before.length() + in.length()));
                buf.append(this.myOneLineComponents[i].setup(before + in + after, isDisabled, strikeout, background, escapedHighlightingRange));
                if (isDisabledBeforeHighlight && (highlightStartOffset < 0 || highlightEndOffset > lineOffset)) {
                    this.myOneLineComponents[i].setDisabledBeforeHighlight();
                }
                this.add((Component)this.myOneLineComponents[i], new GridBagConstraints(0, i, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
                lineOffset += line.length();
            }
            return buf.toString();
        }

        private String escapeString(String line, Function<? super String, String> escapeFunction) {
            line = XmlStringUtil.escapeString((String)line);
            return escapeFunction == null ? line : (String)escapeFunction.fun((Object)line);
        }

        public String setup(ParameterInfoController.Model result2, String[] texts, Function<? super String, String> escapeFunction, EnumSet<ParameterInfoUIContextEx.Flag>[] flags, Color background) {
            String paramText;
            StringBuilder buf = new StringBuilder();
            this.removeAll();
            this.setBackground(background);
            int index = 0;
            int curOffset = 0;
            ArrayList<OneLineComponent> components = new ArrayList<OneLineComponent>();
            ArrayList<Integer> startOffsets = new ArrayList<Integer>();
            ArrayList<Integer> endOffsets = new ArrayList<Integer>();
            TreeMap<TextRange, ParameterInfoUIContextEx.Flag> flagsMap = new TreeMap<TextRange, ParameterInfoUIContextEx.Flag>(TEXT_RANGE_COMPARATOR);
            StringBuilder fullLine = new StringBuilder();
            StringBuilder line = new StringBuilder();
            for (int i = 0; i < texts.length && (paramText = this.escapeString(texts[i], escapeFunction)) != null; ++i) {
                startOffsets.add(fullLine.length());
                fullLine.append(texts[i]);
                endOffsets.add(fullLine.length());
                line.append(texts[i]);
                EnumSet<ParameterInfoUIContextEx.Flag> flag = flags[i];
                if (flag.contains(ParameterInfoUIContextEx.Flag.HIGHLIGHT)) {
                    result2.current = i;
                    flagsMap.put(TextRange.create((int)curOffset, (int)(curOffset + paramText.trim().length())), ParameterInfoUIContextEx.Flag.HIGHLIGHT);
                }
                if (flag.contains(ParameterInfoUIContextEx.Flag.DISABLE)) {
                    flagsMap.put(TextRange.create((int)curOffset, (int)(curOffset + paramText.trim().length())), ParameterInfoUIContextEx.Flag.DISABLE);
                }
                if (flag.contains(ParameterInfoUIContextEx.Flag.STRIKEOUT)) {
                    flagsMap.put(TextRange.create((int)curOffset, (int)(curOffset + paramText.trim().length())), ParameterInfoUIContextEx.Flag.STRIKEOUT);
                }
                curOffset += paramText.length();
                if (line.length() < 50) continue;
                OneLineComponent component = new OneLineComponent();
                buf.append(component.setup(this.escapeString(line.toString(), escapeFunction), flagsMap, background));
                this.add((Component)component, new GridBagConstraints(0, index, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                ++index;
                flagsMap.clear();
                curOffset = 0;
                line = new StringBuilder();
                components.add(component);
            }
            ParameterInfoController.SignatureItem item = new ParameterInfoController.SignatureItem(fullLine.toString(), false, false, startOffsets, endOffsets);
            result2.signatures.add(item);
            OneLineComponent component = new OneLineComponent();
            buf.append(component.setup(this.escapeString(line.toString(), escapeFunction), flagsMap, background));
            this.add((Component)component, new GridBagConstraints(0, index, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            components.add(component);
            this.myOneLineComponents = components.toArray(new OneLineComponent[0]);
            return buf.toString();
        }
    }

    class MyParameterContext
    implements ParameterInfoUIContextEx {
        private final boolean mySingleParameterInfo;
        private int i;
        private Function<String, String> myEscapeFunction;
        private final ParameterInfoController.Model result = new ParameterInfoController.Model();

        MyParameterContext(boolean singleParameterInfo) {
            this.mySingleParameterInfo = singleParameterInfo;
        }

        public String setupUIComponentPresentation(String text, int highlightStartOffset, int highlightEndOffset, boolean isDisabled, boolean strikeout, boolean isDisabledBeforeHighlight, Color background) {
            List split = StringUtil.split((String)text, (String)",", (boolean)false);
            StringBuilder plainLine = new StringBuilder();
            ArrayList<Integer> startOffsets = new ArrayList<Integer>();
            ArrayList<Integer> endOffsets = new ArrayList<Integer>();
            TextRange highlightRange = highlightStartOffset >= 0 && highlightEndOffset >= highlightStartOffset ? new TextRange(highlightStartOffset, highlightEndOffset) : null;
            for (int j = 0; j < split.size(); ++j) {
                String line = (String)split.get(j);
                int startOffset = plainLine.length();
                startOffsets.add(startOffset);
                plainLine.append(line);
                int endOffset = plainLine.length();
                endOffsets.add(endOffset);
                if (highlightRange == null || !highlightRange.intersects(new TextRange(startOffset, endOffset))) continue;
                this.result.current = j;
            }
            ParameterInfoController.SignatureItem item = new ParameterInfoController.SignatureItem(plainLine.toString(), strikeout, isDisabled, startOffsets, endOffsets);
            this.result.signatures.add(item);
            String resultedText = ParameterInfoComponent.this.myPanels[this.i].setup(text, (Function<? super String, String>)this.myEscapeFunction, highlightStartOffset, highlightEndOffset, isDisabled, strikeout, isDisabledBeforeHighlight, background);
            ParameterInfoComponent.this.myPanels[this.i].setBorder(this.isLastParameterOwner() || this.isSingleParameterInfo() ? EMPTY_BORDER : BOTTOM_BORDER);
            return resultedText;
        }

        public void setupRawUIComponentPresentation(String htmlText) {
            ParameterInfoController.RawSignatureItem item = new ParameterInfoController.RawSignatureItem(htmlText);
            this.result.current = this.getCurrentParameterIndex();
            this.result.signatures.add(item);
            ParameterInfoComponent.this.myPanels[this.i].setup(htmlText, this.getDefaultParameterColor());
            ParameterInfoComponent.this.myPanels[this.i].setBorder(this.isLastParameterOwner() || this.isSingleParameterInfo() ? EMPTY_BORDER : BOTTOM_BORDER);
        }

        public String setupUIComponentPresentation(String[] texts, EnumSet<ParameterInfoUIContextEx.Flag>[] flags, Color background) {
            String resultedText = ParameterInfoComponent.this.myPanels[this.i].setup(this.result, texts, this.myEscapeFunction, flags, background);
            ParameterInfoComponent.this.myPanels[this.i].setBorder(this.isLastParameterOwner() || this.isSingleParameterInfo() ? EMPTY_BORDER : BOTTOM_BORDER);
            return resultedText;
        }

        public void setEscapeFunction(@Nullable Function<String, String> escapeFunction) {
            this.myEscapeFunction = escapeFunction;
        }

        public boolean isUIComponentEnabled() {
            return ParameterInfoComponent.this.isEnabled(this.i);
        }

        public void setUIComponentEnabled(boolean enabled) {
            ParameterInfoComponent.this.setEnabled(this.i, enabled);
        }

        public boolean isLastParameterOwner() {
            return this.i == ParameterInfoComponent.this.myPanels.length - 1;
        }

        public int getCurrentParameterIndex() {
            return ParameterInfoComponent.this.myCurrentParameterIndex;
        }

        public PsiElement getParameterOwner() {
            return ParameterInfoComponent.this.myParameterOwner;
        }

        public boolean isSingleOverload() {
            return ParameterInfoComponent.this.myPanels.length == 1;
        }

        public boolean isSingleParameterInfo() {
            return this.mySingleParameterInfo;
        }

        private boolean isHighlighted() {
            return ParameterInfoComponent.this.myObjects[this.i].equals(ParameterInfoComponent.this.myHighlighted);
        }

        public Color getDefaultParameterColor() {
            return this.mySingleParameterInfo || !this.isHighlighted() ? BACKGROUND : HIGHLIGHTED_BACKGROUND;
        }
    }
}

