/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.daemon.impl.ParameterHintsPresentationManager;
import com.intellij.codeInsight.hint.ExternalParameterInfoChangesProvider;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.ParameterInfoComponent;
import com.intellij.codeInsight.hint.ParameterInfoListener;
import com.intellij.codeInsight.hint.ShowParameterInfoHandler;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.ide.IdeTooltip;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.parameterInfo.DeleteParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoHandlerWithTabActionSupport;
import com.intellij.lang.parameterInfo.ParameterInfoUtils;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.HintHint;
import com.intellij.ui.LightweightHint;
import com.intellij.util.Alarm;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.LockSupport;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParameterInfoController
extends UserDataHolderBase
implements VisibleAreaListener,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.hint.ParameterInfoController");
    private static final String WHITESPACE = " \t";
    private final Project myProject;
    @NotNull
    private final Editor myEditor;
    private final RangeMarker myLbraceMarker;
    private LightweightHint myHint;
    private final ParameterInfoComponent myComponent;
    private boolean myKeepOnHintHidden;
    private final CaretListener myEditorCaretListener;
    @NotNull
    private final ParameterInfoHandler<Object, Object> myHandler;
    private final MyBestLocationPointProvider myProvider;
    private final ParameterInfoListener[] myListeners;
    private final Alarm myAlarm = new Alarm();
    private static final int DELAY = 200;
    private boolean mySingleParameterInfo;
    private boolean myDisposed;
    private static final Key<List<ParameterInfoController>> ALL_CONTROLLERS_KEY = Key.create((String)"ParameterInfoController.ALL_CONTROLLERS_KEY");

    public static ParameterInfoController findControllerAtOffset(Editor editor, int offset) {
        List<ParameterInfoController> allControllers = ParameterInfoController.getAllControllers(editor);
        for (int i = 0; i < allControllers.size(); ++i) {
            ParameterInfoController controller = allControllers.get(i);
            if (controller.myLbraceMarker.getStartOffset() != offset) continue;
            if (controller.myKeepOnHintHidden || controller.myHint.isVisible()) {
                return controller;
            }
            Disposer.dispose((Disposable)controller);
            --i;
        }
        return null;
    }

    private static List<ParameterInfoController> getAllControllers(@NotNull Editor editor) {
        ArrayList array = (ArrayList)editor.getUserData(ALL_CONTROLLERS_KEY);
        if (array == null) {
            array = new ArrayList();
            editor.putUserData(ALL_CONTROLLERS_KEY, array);
        }
        return array;
    }

    public static boolean existsForEditor(@NotNull Editor editor) {
        return !ParameterInfoController.getAllControllers(editor).isEmpty();
    }

    public static boolean existsWithVisibleHintForEditor(@NotNull Editor editor, boolean anyHintType) {
        return ParameterInfoController.getAllControllers(editor).stream().anyMatch(c -> c.isHintShown(anyHintType));
    }

    public boolean isHintShown(boolean anyType) {
        return this.myHint.isVisible() && (!this.mySingleParameterInfo || anyType);
    }

    public ParameterInfoController(@NotNull Project project, @NotNull Editor editor, int lbraceOffset, Object[] descriptors, Object highlighted, PsiElement parameterOwner, @NotNull ParameterInfoHandler handler2, boolean showHint2, boolean requestFocus) {
        this.myProject = project;
        this.myEditor = editor;
        this.myHandler = handler2;
        this.myProvider = new MyBestLocationPointProvider(editor);
        this.myListeners = (ParameterInfoListener[])ParameterInfoListener.EP_NAME.getExtensions();
        this.myLbraceMarker = editor.getDocument().createRangeMarker(lbraceOffset, lbraceOffset);
        this.myComponent = new ParameterInfoComponent(descriptors, editor, handler2, requestFocus, true);
        this.myHint = this.createHint();
        this.myKeepOnHintHidden = !showHint2;
        this.mySingleParameterInfo = !showHint2;
        this.myHint.setSelectingHint(true);
        this.myComponent.setParameterOwner(parameterOwner);
        this.myComponent.setHighlightedParameter(highlighted);
        List<ParameterInfoController> allControllers = ParameterInfoController.getAllControllers(this.myEditor);
        allControllers.add(this);
        this.myEditorCaretListener = new CaretListener(){

            public void caretPositionChanged(@NotNull CaretEvent e) {
                UndoManager undoManager = UndoManager.getInstance((Project)ParameterInfoController.this.myProject);
                if (!undoManager.isUndoInProgress() && !undoManager.isRedoInProgress()) {
                    ParameterInfoController.this.syncUpdateOnCaretMove();
                    ParameterInfoController.this.rescheduleUpdate();
                }
            }
        };
        this.myEditor.getCaretModel().addCaretListener(this.myEditorCaretListener);
        this.myEditor.getScrollingModel().addVisibleAreaListener((VisibleAreaListener)this);
        this.myEditor.getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                ParameterInfoController.this.rescheduleUpdate();
            }
        }, (Disposable)this);
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)this);
        connection.subscribe(ExternalParameterInfoChangesProvider.TOPIC, (e, offset) -> {
            if (e != null && (e != this.myEditor || this.myLbraceMarker.getStartOffset() != offset)) {
                return;
            }
            this.updateWhenAllCommitted();
        });
        PropertyChangeListener lookupListener = evt -> {
            Lookup lookup;
            if ("activeLookup".equals(evt.getPropertyName()) && (lookup = (Lookup)evt.getNewValue()) != null) {
                this.adjustPositionForLookup(lookup);
            }
        };
        LookupManager.getInstance(project).addPropertyChangeListener(lookupListener, this);
        EditorUtil.disposeWithEditor(this.myEditor, this);
        this.myComponent.update(this.mySingleParameterInfo);
        if (showHint2) {
            this.showHint(requestFocus, this.mySingleParameterInfo);
        }
        this.updateComponent();
    }

    void setDescriptors(Object[] descriptors) {
        this.myComponent.setDescriptors(descriptors);
    }

    private void syncUpdateOnCaretMove() {
        this.myHandler.syncUpdateOnCaretMove((UpdateParameterInfoContext)new MyLazyUpdateParameterInfoContext());
    }

    private LightweightHint createHint() {
        WrapperPanel wrapper2 = new WrapperPanel();
        wrapper2.add(this.myComponent);
        return new LightweightHint(wrapper2);
    }

    public void dispose() {
        if (this.myDisposed) {
            return;
        }
        this.myDisposed = true;
        this.hideHint();
        this.myHandler.dispose((DeleteParameterInfoContext)new MyDeleteParameterInfoContext());
        List<ParameterInfoController> allControllers = ParameterInfoController.getAllControllers(this.myEditor);
        allControllers.remove((Object)this);
        this.myEditor.getCaretModel().removeCaretListener(this.myEditorCaretListener);
        this.myEditor.getScrollingModel().removeVisibleAreaListener((VisibleAreaListener)this);
    }

    public void visibleAreaChanged(@NotNull VisibleAreaEvent e) {
        if (Registry.is((String)"editor.keep.completion.hints.even.longer")) {
            this.rescheduleUpdate();
        }
    }

    public void showHint(boolean requestFocus, boolean singleParameterInfo) {
        if (this.myHint.isVisible()) {
            this.myHint.getComponent().remove(this.myComponent);
            this.hideHint();
            this.myHint = this.createHint();
        }
        this.mySingleParameterInfo = singleParameterInfo && this.myKeepOnHintHidden;
        Pair pos = this.myProvider.getBestPointPosition(this.myHint, this.myComponent.getParameterOwner(), this.myLbraceMarker.getStartOffset(), null, (short)1);
        HintHint hintHint = HintManagerImpl.createHintHint(this.myEditor, (Point)pos.getFirst(), this.myHint, (Short)pos.getSecond());
        hintHint.setExplicitClose(true);
        hintHint.setRequestFocus(requestFocus);
        hintHint.setShowImmediately(true);
        hintHint.setBorderColor(ParameterInfoComponent.BORDER_COLOR);
        hintHint.setBorderInsets((Insets)JBUI.insets((int)4, (int)1, (int)4, (int)1));
        hintHint.setComponentBorder((Border)JBUI.Borders.empty());
        int flags = 129;
        if (!singleParameterInfo && this.myKeepOnHintHidden) {
            flags |= 8;
        }
        Editor editorToShow = this.myEditor instanceof EditorWindow ? ((EditorWindow)this.myEditor).getDelegate() : this.myEditor;
        HintManagerImpl.getInstanceImpl().showEditorHint(this.myHint, editorToShow, (Point)pos.getFirst(), flags, 0, false, hintHint);
        this.updateComponent();
    }

    private void adjustPositionForLookup(@NotNull Lookup lookup) {
        JRootPane root;
        if (this.myEditor.isDisposed()) {
            Disposer.dispose((Disposable)this);
            return;
        }
        if (!this.myHint.isVisible()) {
            if (!this.myKeepOnHintHidden) {
                Disposer.dispose((Disposable)this);
            }
            return;
        }
        IdeTooltip tooltip = this.myHint.getCurrentIdeTooltip();
        if (tooltip != null && (root = this.myEditor.getComponent().getRootPane()) != null) {
            Point p = tooltip.getShowingPoint().getPoint((Component)root.getLayeredPane());
            if (lookup.isPositionedAboveCaret()) {
                if (Balloon.Position.above == tooltip.getPreferredPosition()) {
                    this.myHint.pack();
                    this.myHint.updatePosition(Balloon.Position.below);
                    this.myHint.updateLocation(p.x, p.y + tooltip.getPositionChangeY());
                }
            } else if (Balloon.Position.below == tooltip.getPreferredPosition()) {
                this.myHint.pack();
                this.myHint.updatePosition(Balloon.Position.above);
                this.myHint.updateLocation(p.x, p.y - tooltip.getPositionChangeY());
            }
        }
    }

    private void rescheduleUpdate() {
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest(() -> this.updateWhenAllCommitted(), 200, ModalityState.stateForComponent((Component)this.myEditor.getComponent()));
    }

    private void updateWhenAllCommitted() {
        if (!this.myDisposed && !this.myProject.isDisposed()) {
            PsiDocumentManager.getInstance((Project)this.myProject).performLaterWhenAllCommitted(() -> {
                try {
                    DumbService.getInstance((Project)this.myProject).withAlternativeResolveEnabled(this::updateComponent);
                }
                catch (IndexNotReadyException e) {
                    LOG.info((Throwable)e);
                    Disposer.dispose((Disposable)this);
                }
            });
        }
    }

    public void updateComponent() {
        if (!this.myKeepOnHintHidden && !this.myHint.isVisible() && !ApplicationManager.getApplication().isHeadlessEnvironment() || this.myEditor instanceof EditorWindow && !((EditorWindow)this.myEditor).isValid()) {
            Disposer.dispose((Disposable)this);
            return;
        }
        PsiFile file2 = PsiUtilBase.getPsiFileInEditor((Editor)this.myEditor, (Project)this.myProject);
        CharSequence chars = this.myEditor.getDocument().getCharsSequence();
        int caretOffset = this.myEditor.getCaretModel().getOffset();
        int offset = this.myHandler.isWhitespaceSensitive() ? caretOffset : CharArrayUtil.shiftBackward((CharSequence)chars, (int)(caretOffset - 1), (String)WHITESPACE) + 1;
        MyUpdateParameterInfoContext context = new MyUpdateParameterInfoContext(offset, file2);
        Object elementForUpdating = this.myHandler.findElementForUpdatingParameterInfo((UpdateParameterInfoContext)context);
        if (elementForUpdating != null) {
            boolean knownParameter;
            this.myHandler.updateParameterInfo(elementForUpdating, (UpdateParameterInfoContext)context);
            boolean bl = knownParameter = (this.myComponent.getObjects().length == 1 || this.myComponent.getHighlighted() != null) && this.myComponent.getCurrentParameterIndex() != -1;
            if (this.mySingleParameterInfo && !knownParameter && this.myHint.isVisible()) {
                this.hideHint();
            }
            if (this.myKeepOnHintHidden && knownParameter && !this.myHint.isVisible()) {
                AutoPopupController.getInstance(this.myProject).autoPopupParameterInfo(this.myEditor, null);
            }
            if (!this.myDisposed && (this.myHint.isVisible() && !this.myEditor.isDisposed() && (this.myEditor.getComponent().getRootPane() != null || ApplicationManager.getApplication().isUnitTestMode()) || ApplicationManager.getApplication().isHeadlessEnvironment())) {
                Model result2 = this.myComponent.update(this.mySingleParameterInfo);
                result2.project = this.myProject;
                result2.range = this.myComponent.getParameterOwner().getTextRange();
                result2.editor = this.myEditor;
                for (ParameterInfoListener listener2 : this.myListeners) {
                    listener2.hintUpdated(result2);
                }
                if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
                    return;
                }
                IdeTooltip tooltip = this.myHint.getCurrentIdeTooltip();
                short position = tooltip != null ? ParameterInfoController.toShort(tooltip.getPreferredPosition()) : (short)1;
                Pair pos = this.myProvider.getBestPointPosition(this.myHint, elementForUpdating instanceof PsiElement ? (PsiElement)elementForUpdating : null, caretOffset, this.myEditor.getCaretModel().getVisualPosition(), position);
                HintManagerImpl.adjustEditorHintPosition(this.myHint, this.myEditor, (Point)pos.getFirst(), (Short)pos.getSecond());
            }
        } else {
            this.hideHint();
            if (!this.myKeepOnHintHidden) {
                Disposer.dispose((Disposable)this);
            }
        }
    }

    @HintManager.PositionFlags
    private static short toShort(Balloon.Position position) {
        switch (position) {
            case above: {
                return 1;
            }
            case atLeft: {
                return 3;
            }
            case atRight: {
                return 4;
            }
        }
        return 2;
    }

    static boolean hasPrevOrNextParameter(Editor editor, int lbraceOffset, boolean isNext) {
        ParameterInfoController controller = ParameterInfoController.findControllerAtOffset(editor, lbraceOffset);
        return controller != null && controller.getPrevOrNextParameterOffset(isNext) != -1;
    }

    static void prevOrNextParameter(Editor editor, int lbraceOffset, boolean isNext) {
        int newOffset;
        ParameterInfoController controller = ParameterInfoController.findControllerAtOffset(editor, lbraceOffset);
        int n = newOffset = controller != null ? controller.getPrevOrNextParameterOffset(isNext) : -1;
        if (newOffset != -1) {
            controller.moveToParameterAtOffset(newOffset);
        }
    }

    private void moveToParameterAtOffset(int offset) {
        PsiFile file2 = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myEditor.getDocument());
        Object argsList = ParameterInfoController.findArgumentList(file2, offset, -1);
        if (argsList == null && !CodeInsightSettings.getInstance().SHOW_PARAMETER_NAME_HINTS_ON_COMPLETION) {
            return;
        }
        if (!this.myHint.isVisible()) {
            AutoPopupController.getInstance(this.myProject).autoPopupParameterInfo(this.myEditor, null);
        }
        offset = this.adjustOffsetToInlay(offset);
        this.myEditor.getCaretModel().moveToOffset(offset);
        this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        this.myEditor.getSelectionModel().removeSelection();
        if (argsList != null) {
            this.myHandler.updateParameterInfo(argsList, (UpdateParameterInfoContext)new MyUpdateParameterInfoContext(offset, file2));
        }
    }

    private int adjustOffsetToInlay(int offset) {
        CharSequence text = this.myEditor.getDocument().getImmutableCharSequence();
        int hostWhitespaceStart = CharArrayUtil.shiftBackward((CharSequence)text, (int)offset, (String)WHITESPACE) + 1;
        int hostWhitespaceEnd = CharArrayUtil.shiftForward((CharSequence)text, (int)offset, (String)WHITESPACE);
        Editor hostEditor = this.myEditor;
        if (this.myEditor instanceof EditorWindow) {
            hostEditor = ((EditorWindow)this.myEditor).getDelegate();
            hostWhitespaceStart = ((EditorWindow)this.myEditor).getDocument().injectedToHost(hostWhitespaceStart);
            hostWhitespaceEnd = ((EditorWindow)this.myEditor).getDocument().injectedToHost(hostWhitespaceEnd);
        }
        List<Inlay> inlays = ParameterHintsPresentationManager.getInstance().getParameterHintsInRange(hostEditor, hostWhitespaceStart, hostWhitespaceEnd);
        for (Inlay inlay : inlays) {
            int inlayOffset = inlay.getOffset();
            if (this.myEditor instanceof EditorWindow) {
                if (((EditorWindow)this.myEditor).getDocument().getHostRange(inlayOffset) == null) continue;
                inlayOffset = ((EditorWindow)this.myEditor).getDocument().hostToInjected(inlayOffset);
            }
            return inlayOffset;
        }
        return offset;
    }

    private int getPrevOrNextParameterOffset(boolean isNext) {
        int currentParameterIndex;
        PsiElement argList;
        if (!(this.myHandler instanceof ParameterInfoHandlerWithTabActionSupport)) {
            return -1;
        }
        ParameterInfoHandlerWithTabActionSupport handler2 = (ParameterInfoHandlerWithTabActionSupport)this.myHandler;
        boolean noDelimiter = handler2.getActualParameterDelimiterType() == TokenType.WHITE_SPACE;
        int caretOffset = this.myEditor.getCaretModel().getOffset();
        CharSequence text = this.myEditor.getDocument().getImmutableCharSequence();
        int offset = noDelimiter ? caretOffset : CharArrayUtil.shiftBackward((CharSequence)text, (int)(caretOffset - 1), (String)WHITESPACE) + 1;
        int lbraceOffset = this.myLbraceMarker.getStartOffset();
        PsiFile file2 = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myEditor.getDocument());
        PsiElement psiElement = argList = lbraceOffset < offset ? (PsiElement)ParameterInfoController.findArgumentList(file2, offset, lbraceOffset) : null;
        if (argList == null) {
            return -1;
        }
        Object[] parameters = handler2.getActualParameters(argList);
        int n = currentParameterIndex = noDelimiter ? JBIterable.of((Object[])parameters).indexOf(o -> o.getTextRange().containsOffset(offset)) : ParameterInfoUtils.getCurrentParameterIndex((ASTNode)argList.getNode(), (int)offset, (IElementType)handler2.getActualParameterDelimiterType());
        if (CodeInsightSettings.getInstance().SHOW_PARAMETER_NAME_HINTS_ON_COMPLETION) {
            int prevOrNextParameterIndex;
            if (currentParameterIndex < 0 || currentParameterIndex >= parameters.length && parameters.length > 0) {
                return -1;
            }
            if (offset >= argList.getTextRange().getEndOffset()) {
                currentParameterIndex = isNext ? -1 : parameters.length;
            }
            if ((prevOrNextParameterIndex = currentParameterIndex + (isNext ? 1 : -1)) < 0 || prevOrNextParameterIndex >= parameters.length) {
                PsiElement parameterOwner = this.myComponent.getParameterOwner();
                return parameterOwner != null && parameterOwner.isValid() ? parameterOwner.getTextRange().getEndOffset() : -1;
            }
            return ParameterInfoController.getParameterNavigationOffset((PsiElement)parameters[prevOrNextParameterIndex], text);
        }
        int prevOrNextParameterIndex = isNext && currentParameterIndex < parameters.length - 1 ? currentParameterIndex + 1 : (!isNext && currentParameterIndex > 0 ? currentParameterIndex - 1 : -1);
        return prevOrNextParameterIndex != -1 ? parameters[prevOrNextParameterIndex].getTextRange().getStartOffset() : -1;
    }

    private static int getParameterNavigationOffset(@NotNull PsiElement parameter, @NotNull CharSequence text) {
        int rangeStart = parameter.getTextRange().getStartOffset();
        int rangeEnd = parameter.getTextRange().getEndOffset();
        int offset = CharArrayUtil.shiftBackward((CharSequence)text, (int)(rangeEnd - 1), (String)WHITESPACE) + 1;
        return offset > rangeStart ? offset : CharArrayUtil.shiftForward((CharSequence)text, (int)rangeEnd, (String)WHITESPACE);
    }

    @Nullable
    public static <E extends PsiElement> E findArgumentList(PsiFile file2, int offset, int lbraceOffset) {
        if (file2 == null) {
            return null;
        }
        ParameterInfoHandler[] handlers = ShowParameterInfoHandler.getHandlers(file2.getProject(), PsiUtilCore.getLanguageAtOffset((PsiFile)file2, (int)offset), file2.getViewProvider().getBaseLanguage());
        if (handlers != null) {
            for (ParameterInfoHandler handler2 : handlers) {
                ParameterInfoHandlerWithTabActionSupport parameterInfoHandler2;
                PsiElement e;
                if (!(handler2 instanceof ParameterInfoHandlerWithTabActionSupport) || (e = ParameterInfoUtils.findArgumentList((PsiFile)file2, (int)offset, (int)lbraceOffset, (ParameterInfoHandlerWithTabActionSupport)(parameterInfoHandler2 = (ParameterInfoHandlerWithTabActionSupport)handler2))) == null) continue;
                return (E)e;
            }
        }
        return null;
    }

    public Object[] getObjects() {
        return this.myComponent.getObjects();
    }

    public Object getHighlighted() {
        return this.myComponent.getHighlighted();
    }

    public void setPreservedOnHintHidden(boolean value) {
        this.myKeepOnHintHidden = value;
    }

    public static void waitForDelayedActions(@NotNull Editor editor, long timeout, @NotNull TimeUnit unit) throws TimeoutException {
        long deadline = System.currentTimeMillis() + unit.toMillis(timeout);
        while (System.currentTimeMillis() < deadline) {
            List<ParameterInfoController> controllers = ParameterInfoController.getAllControllers(editor);
            boolean hasPendingRequests = false;
            for (ParameterInfoController controller : controllers) {
                if (controller.myAlarm.isEmpty()) continue;
                hasPendingRequests = true;
                break;
            }
            if (hasPendingRequests) {
                LockSupport.parkNanos(10000000L);
                UIUtil.dispatchAllInvocationEvents();
                continue;
            }
            return;
        }
        throw new TimeoutException();
    }

    static Pair<Point, Short> chooseBestHintPosition(Editor editor, VisualPosition pos, LightweightHint hint, short preferredPosition, boolean showLookupHint) {
        boolean p2Ok;
        Point p2;
        Point p1;
        if (ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return Pair.pair((Object)new Point(), (Object)6);
        }
        HintManagerImpl hintManager = HintManagerImpl.getInstanceImpl();
        Dimension hintSize = hint.getComponent().getPreferredSize();
        JComponent editorComponent = editor.getComponent();
        JLayeredPane layeredPane = editorComponent.getRootPane().getLayeredPane();
        if (showLookupHint) {
            p1 = hintManager.getHintPosition(hint, editor, (short)2);
            p2 = hintManager.getHintPosition(hint, editor, (short)1);
        } else {
            p1 = HintManagerImpl.getHintPosition(hint, editor, pos, (short)2);
            p2 = HintManagerImpl.getHintPosition(hint, editor, pos, (short)1);
        }
        boolean p1Ok = p1.y + hintSize.height < layeredPane.getHeight();
        boolean bl = p2Ok = p2.y >= 0;
        if (!showLookupHint && preferredPosition != 6) {
            if (preferredPosition == 1) {
                if (p2Ok) {
                    return new Pair((Object)p2, (Object)1);
                }
            } else if (preferredPosition == 2 && p1Ok) {
                return new Pair((Object)p1, (Object)2);
            }
        }
        if (p1Ok) {
            return new Pair((Object)p1, (Object)2);
        }
        if (p2Ok) {
            return new Pair((Object)p2, (Object)1);
        }
        int aboveSpace = p2.y;
        int underSpace = layeredPane.getHeight() - p1.y;
        return aboveSpace > underSpace ? new Pair((Object)new Point(p2.x, 0), (Object)2) : new Pair((Object)p1, (Object)1);
    }

    public static boolean areParameterTemplatesEnabledOnCompletion() {
        return Registry.is((String)"java.completion.argument.live.template") && !CodeInsightSettings.getInstance().SHOW_PARAMETER_NAME_HINTS_ON_COMPLETION;
    }

    protected void hideHint() {
        this.myHint.hide();
        for (ParameterInfoListener listener2 : this.myListeners) {
            listener2.hintHidden(this.myProject);
        }
    }

    private class MyDeleteParameterInfoContext
    implements DeleteParameterInfoContext {
        private MyDeleteParameterInfoContext() {
        }

        public PsiElement getParameterOwner() {
            return ParameterInfoController.this.myComponent.getParameterOwner();
        }

        public Editor getEditor() {
            return ParameterInfoController.this.myEditor;
        }

        public UserDataHolderEx getCustomContext() {
            return ParameterInfoController.this;
        }
    }

    private static class WrapperPanel
    extends JPanel {
        WrapperPanel() {
            super(new BorderLayout());
            this.setBorder((Border)JBUI.Borders.empty());
        }

        @Override
        public Color getForeground() {
            return this.getComponentCount() == 0 ? super.getForeground() : this.getComponent(0).getForeground();
        }

        @Override
        public Color getBackground() {
            return this.getComponentCount() == 0 ? super.getBackground() : this.getComponent(0).getBackground();
        }

        @Override
        public Font getFont() {
            return this.getComponentCount() == 0 ? super.getFont() : this.getComponent(0).getFont();
        }

        @Override
        public String toString() {
            return this.getComponentCount() == 0 ? "<empty>" : this.getComponent(0).toString();
        }
    }

    private static class MyBestLocationPointProvider {
        private final Editor myEditor;
        private int previousOffset = -1;
        private Point previousBestPoint;
        private Short previousBestPosition;

        MyBestLocationPointProvider(Editor editor) {
            this.myEditor = editor;
        }

        @NotNull
        private Pair<Point, Short> getBestPointPosition(LightweightHint hint, PsiElement list2, int offset, VisualPosition pos, short preferredPosition) {
            Pair position;
            boolean isMultiline;
            TextRange range2;
            TextRange rangeWithoutParens;
            if (list2 != null && !(rangeWithoutParens = TextRange.from((int)((range2 = list2.getTextRange()).getStartOffset() + 1), (int)Math.max(range2.getLength() - 2, 0))).contains(offset)) {
                offset = offset < rangeWithoutParens.getStartOffset() ? rangeWithoutParens.getStartOffset() : rangeWithoutParens.getEndOffset();
                pos = null;
            }
            if (this.previousOffset == offset) {
                return Pair.create((Object)this.previousBestPoint, (Object)this.previousBestPosition);
            }
            boolean bl = isMultiline = list2 != null && StringUtil.containsAnyChar((String)list2.getText(), (String)"\n\r");
            if (pos == null) {
                pos = EditorUtil.inlayAwareOffsetToVisualPosition(this.myEditor, offset);
            }
            if (!isMultiline) {
                position = ParameterInfoController.chooseBestHintPosition(this.myEditor, pos, hint, preferredPosition, false);
            } else {
                Point p = HintManagerImpl.getHintPosition(hint, this.myEditor, pos, (short)1);
                position = new Pair((Object)p, (Object)1);
            }
            this.previousBestPoint = (Point)position.getFirst();
            this.previousBestPosition = (Short)position.getSecond();
            this.previousOffset = offset;
            return position;
        }
    }

    public static class Model {
        public final List<SignatureItemModel> signatures = new ArrayList<SignatureItemModel>();
        public int current = -1;
        public TextRange range;
        public Editor editor;
        public Project project;
    }

    public static class SignatureItem
    implements SignatureItemModel {
        public final String text;
        public final boolean deprecated;
        public final boolean disabled;
        public final List<Integer> startOffsets;
        public final List<Integer> endOffsets;

        SignatureItem(String text, boolean deprecated, boolean disabled, List<Integer> startOffsets, List<Integer> endOffsets) {
            this.text = text;
            this.deprecated = deprecated;
            this.disabled = disabled;
            this.startOffsets = startOffsets;
            this.endOffsets = endOffsets;
        }
    }

    public static class RawSignatureItem
    implements SignatureItemModel {
        public final String htmlText;

        RawSignatureItem(String htmlText) {
            this.htmlText = htmlText;
        }
    }

    public static interface SignatureItemModel {
    }

    private class MyLazyUpdateParameterInfoContext
    extends MyUpdateParameterInfoContext {
        private PsiFile myFile;

        private MyLazyUpdateParameterInfoContext() {
            super(ParameterInfoController.this.myEditor.getCaretModel().getOffset(), null);
        }

        @Override
        public PsiFile getFile() {
            if (this.myFile == null) {
                this.myFile = PsiUtilBase.getPsiFileInEditor((Editor)ParameterInfoController.this.myEditor, (Project)ParameterInfoController.this.myProject);
            }
            return this.myFile;
        }
    }

    private class MyUpdateParameterInfoContext
    implements UpdateParameterInfoContext {
        private final int myOffset;
        private final PsiFile myFile;

        MyUpdateParameterInfoContext(int offset, PsiFile file2) {
            this.myOffset = offset;
            this.myFile = file2;
        }

        public int getParameterListStart() {
            return ParameterInfoController.this.myLbraceMarker.getStartOffset();
        }

        public int getOffset() {
            return this.myOffset;
        }

        public Project getProject() {
            return ParameterInfoController.this.myProject;
        }

        public PsiFile getFile() {
            return this.myFile;
        }

        @NotNull
        public Editor getEditor() {
            return ParameterInfoController.this.myEditor;
        }

        public void removeHint() {
            ParameterInfoController.this.hideHint();
            if (!ParameterInfoController.this.myKeepOnHintHidden) {
                Disposer.dispose((Disposable)ParameterInfoController.this);
            }
        }

        public void setParameterOwner(PsiElement o) {
            ParameterInfoController.this.myComponent.setParameterOwner(o);
        }

        public PsiElement getParameterOwner() {
            return ParameterInfoController.this.myComponent.getParameterOwner();
        }

        public void setHighlightedParameter(Object method) {
            ParameterInfoController.this.myComponent.setHighlightedParameter(method);
        }

        public Object getHighlightedParameter() {
            return ParameterInfoController.this.myComponent.getHighlighted();
        }

        public void setCurrentParameter(int index) {
            ParameterInfoController.this.myComponent.setCurrentParameterIndex(index);
        }

        public boolean isUIComponentEnabled(int index) {
            return ParameterInfoController.this.myComponent.isEnabled(index);
        }

        public void setUIComponentEnabled(int index, boolean enabled) {
            ParameterInfoController.this.myComponent.setEnabled(index, enabled);
        }

        public Object[] getObjectsToView() {
            return ParameterInfoController.this.myComponent.getObjects();
        }

        public boolean isPreservedOnHintHidden() {
            return ParameterInfoController.this.myKeepOnHintHidden;
        }

        public void setPreservedOnHintHidden(boolean value) {
            ParameterInfoController.this.myKeepOnHintHidden = value;
        }

        public boolean isInnermostContext() {
            PsiElement ourOwner = ParameterInfoController.this.myComponent.getParameterOwner();
            if (ourOwner == null || !ourOwner.isValid()) {
                return false;
            }
            TextRange ourRange = ourOwner.getTextRange();
            if (ourRange == null) {
                return false;
            }
            List allControllers = ParameterInfoController.getAllControllers(ParameterInfoController.this.myEditor);
            for (ParameterInfoController controller : allControllers) {
                TextRange range2;
                PsiElement parameterOwner;
                if (controller == ParameterInfoController.this || (parameterOwner = controller.myComponent.getParameterOwner()) == null || !parameterOwner.isValid() || (range2 = parameterOwner.getTextRange()) == null || !range2.contains(this.myOffset) || !ourRange.contains(range2)) continue;
                return false;
            }
            return true;
        }

        public boolean isSingleParameterInfo() {
            return ParameterInfoController.this.mySingleParameterInfo;
        }

        public UserDataHolderEx getCustomContext() {
            return ParameterInfoController.this;
        }
    }
}

