/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.hint.ElementLocationUtil;
import com.intellij.codeInsight.hint.ImplementationViewComponent;
import com.intellij.codeInsight.hint.ImplementationViewElement;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0010H\u0016R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011R\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001a\u001a\u0004\u0018\u00010\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0019R\u0014\u0010\u001c\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0019R\u0014\u0010\u001e\u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u000eR\u0016\u0010#\u001a\u0004\u0018\u00010\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0019\u00a8\u0006("}, d2={"Lcom/intellij/codeInsight/hint/PsiImplementationViewElement;", "Lcom/intellij/codeInsight/hint/ImplementationViewElement;", "psiElement", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)V", "containingFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getContainingFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "containingMemberOrSelf", "getContainingMemberOrSelf", "()Lcom/intellij/codeInsight/hint/ImplementationViewElement;", "elementForShowUsages", "getElementForShowUsages", "()Lcom/intellij/psi/PsiElement;", "isNamed", "", "()Z", "locationIcon", "Ljavax/swing/Icon;", "getLocationIcon", "()Ljavax/swing/Icon;", "locationText", "", "getLocationText", "()Ljava/lang/String;", "name", "getName", "presentableText", "getPresentableText", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getPsiElement", "text", "getText", "navigate", "", "focusEditor", "intellij.platform.lang.impl"})
public final class PsiImplementationViewElement
extends ImplementationViewElement {
    @NotNull
    private final PsiElement psiElement;

    @Override
    @NotNull
    public Project getProject() {
        return this.psiElement.getProject();
    }

    @Override
    public boolean isNamed() {
        return this.psiElement instanceof PsiNamedElement;
    }

    @Override
    @Nullable
    public String getName() {
        PsiElement psiElement = this.psiElement;
        if (!(psiElement instanceof PsiNamedElement)) {
            psiElement = null;
        }
        PsiNamedElement psiNamedElement = (PsiNamedElement)psiElement;
        return psiNamedElement != null ? psiNamedElement.getName() : null;
    }

    @Override
    @Nullable
    public VirtualFile getContainingFile() {
        PsiFile psiFile = this.psiElement.getContainingFile();
        return psiFile != null && (psiFile = psiFile.getOriginalFile()) != null ? psiFile.getVirtualFile() : null;
    }

    @Override
    @Nullable
    public String getText() {
        return ImplementationViewComponent.getNewText(this.psiElement);
    }

    @Override
    @NotNull
    public String getPresentableText() {
        PsiElement psiElement = this.psiElement;
        if (!(psiElement instanceof NavigationItem)) {
            psiElement = null;
        }
        NavigationItem navigationItem = (NavigationItem)psiElement;
        ItemPresentation presentation = navigationItem != null ? navigationItem.getPresentation() : null;
        VirtualFile virtualFile = this.getContainingFile();
        if (virtualFile == null) {
            return "";
        }
        VirtualFile vFile = virtualFile;
        String presentableName = vFile.getPresentableName();
        if (presentation == null) {
            return presentableName;
        }
        String elementPresentation = presentation.getPresentableText();
        String locationString = presentation.getLocationString();
        return Intrinsics.areEqual((Object)vFile.getName(), (Object)(elementPresentation + "." + vFile.getExtension())) ? presentableName + (!StringUtil.isEmptyOrSpaces((String)locationString) ? ' ' + locationString : "") : presentableName + " (" + elementPresentation + ')';
    }

    @Override
    @Nullable
    public String getLocationText() {
        return ElementLocationUtil.renderElementLocation(this.psiElement, (Ref<Icon>)new Ref());
    }

    @Override
    @Nullable
    public Icon getLocationIcon() {
        Ref ref;
        Ref it = ref = new Ref();
        boolean bl = false;
        ElementLocationUtil.renderElementLocation(this.psiElement, (Ref<Icon>)it);
        return (Icon)ref.get();
    }

    @Override
    @NotNull
    public ImplementationViewElement getContainingMemberOrSelf() {
        PsiElement parent = PsiTreeUtil.getStubOrPsiParent((PsiElement)this.psiElement);
        if (parent == null || parent instanceof PsiFile && Intrinsics.areEqual((Object)((PsiFile)parent).getVirtualFile(), (Object)this.getContainingFile())) {
            return this;
        }
        return new PsiImplementationViewElement(parent);
    }

    @Override
    public void navigate(boolean focusEditor) {
        PsiElement navigationElement = this.psiElement.getNavigationElement();
        PsiFile psiFile = navigationElement.getContainingFile();
        if (psiFile == null || (psiFile = psiFile.getOriginalFile()) == null) {
            return;
        }
        PsiFile file2 = psiFile;
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        VirtualFile virtualFile2 = virtualFile;
        Project project = this.psiElement.getProject();
        FileEditorManagerEx fileEditorManager = FileEditorManagerEx.getInstanceEx(project);
        OpenFileDescriptor descriptor = new OpenFileDescriptor(project, virtualFile2, navigationElement.getTextOffset());
        fileEditorManager.openTextEditor(descriptor, focusEditor);
    }

    @Override
    @Nullable
    public PsiElement getElementForShowUsages() {
        return !(this.psiElement instanceof PsiBinaryFile) ? this.psiElement : null;
    }

    @NotNull
    public final PsiElement getPsiElement() {
        return this.psiElement;
    }

    public PsiImplementationViewElement(@NotNull PsiElement psiElement) {
        this.psiElement = psiElement;
    }
}

