/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint.actions;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.hint.ImplementationViewComponent;
import com.intellij.codeInsight.hint.ImplementationViewElement;
import com.intellij.codeInsight.hint.ImplementationViewSession;
import com.intellij.codeInsight.hint.ImplementationViewSessionFactory;
import com.intellij.codeInsight.hint.PsiImplementationViewElement;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.navigation.BackgroundUpdaterTask;
import com.intellij.codeInsight.navigation.ImplementationSearcher;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PopupAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ListComponentUpdater;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.reference.SoftReference;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.popup.PopupPositionManager;
import com.intellij.ui.popup.PopupUpdateProcessor;
import com.intellij.usages.UsageView;
import com.intellij.util.Processor;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ShowImplementationsAction
extends AnAction
implements PopupAction {
    @NonNls
    public static final String CODEASSISTS_QUICKDEFINITION_LOOKUP_FEATURE = "codeassists.quickdefinition.lookup";
    @NonNls
    public static final String CODEASSISTS_QUICKDEFINITION_FEATURE = "codeassists.quickdefinition";
    private Reference<JBPopup> myPopupRef;
    private Reference<ImplementationsUpdaterTask> myTaskRef;

    public ShowImplementationsAction() {
        this.setEnabledInModalContext(true);
        this.setInjectedContext(true);
    }

    public boolean startInTransaction() {
        return true;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        this.performForContext(e.getDataContext(), true);
    }

    public void performForContext(DataContext dataContext) {
        this.performForContext(dataContext, true);
    }

    public void update(@NotNull AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        e.getPresentation().setEnabled(project != null);
    }

    public void performForContext(@NotNull DataContext dataContext, boolean invokedByShortcut) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        boolean isInvokedFromEditor = CommonDataKeys.EDITOR.getData(dataContext) != null;
        for (ImplementationViewSessionFactory factory : ImplementationViewSessionFactory.EP_NAME.getExtensionList()) {
            ImplementationViewSession session2 = factory.createSession(dataContext, project, this.isSearchDeep(), this.isIncludeAlwaysSelf());
            if (session2 == null) continue;
            this.showImplementations(session2, isInvokedFromEditor, invokedByShortcut);
        }
    }

    private void updateElementImplementations(Object lookupItemObject, ImplementationViewSession session2) {
        ImplementationViewSession newSession = session2.getFactory().createSessionForLookupElement(session2.getProject(), session2.getEditor(), session2.getFile(), lookupItemObject, this.isSearchDeep(), this.isIncludeAlwaysSelf());
        if (newSession != null) {
            Disposer.dispose((Disposable)session2);
            this.showImplementations(newSession, false, false);
        }
    }

    protected void showImplementations(final @NotNull ImplementationViewSession session2, boolean invokedFromEditor, boolean invokedByShortcut) {
        VirtualFile secondContainingFile;
        VirtualFile containingFile;
        List<ImplementationViewElement> impls = session2.getImplementationElements();
        if (impls.size() == 0) {
            return;
        }
        Project project = session2.getProject();
        FeatureUsageTracker.getInstance().triggerFeatureUsed(CODEASSISTS_QUICKDEFINITION_FEATURE);
        if (LookupManager.getInstance(project).getActiveLookup() != null) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed(CODEASSISTS_QUICKDEFINITION_LOOKUP_FEATURE);
        }
        VirtualFile virtualFile = session2.getFile();
        int index = 0;
        if (invokedFromEditor && virtualFile != null && impls.size() > 1 && virtualFile.equals(containingFile = impls.get(0).getContainingFile()) && (secondContainingFile = impls.get(1).getContainingFile()) != null && !secondContainingFile.equals(containingFile)) {
            index = 1;
        }
        Ref usageView = new Ref();
        String title = CodeInsightBundle.message((String)"implementation.view.title", (Object[])new Object[]{session2.getText()});
        JBPopup popup2 = (JBPopup)SoftReference.dereference(this.myPopupRef);
        if (popup2 != null && popup2.isVisible() && popup2 instanceof AbstractPopup) {
            ImplementationViewComponent component = (ImplementationViewComponent)((AbstractPopup)popup2).getComponent();
            popup2.setCaption(title);
            component.update(impls, index);
            this.updateInBackground(session2, component, title, (AbstractPopup)popup2, (Ref<UsageView>)usageView);
            if (invokedByShortcut) {
                ((AbstractPopup)popup2).focusPreferredComponent();
            }
            return;
        }
        ImplementationViewComponent component = new ImplementationViewComponent(impls, index);
        if (component.hasElementsToShow()) {
            PopupUpdateProcessor updateProcessor = new PopupUpdateProcessor(project){

                public void updatePopup(Object lookupItemObject) {
                    ShowImplementationsAction.this.updateElementImplementations(lookupItemObject, session2);
                }
            };
            popup2 = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)component, component.getPreferredFocusableComponent()).setProject(project).addListener((JBPopupListener)updateProcessor).addUserData((Object)updateProcessor).setDimensionServiceKey(project, "javadoc.popup", false).setResizable(true).setMovable(true).setRequestFocus(invokedFromEditor && LookupManager.getActiveLookup(session2.getEditor()) == null).setTitle(title).setCouldPin(popup1 -> {
                usageView.set((Object)component.showInUsageView());
                popup1.cancel();
                this.myTaskRef = null;
                return false;
            }).setCancelCallback(() -> {
                ImplementationsUpdaterTask task2 = (ImplementationsUpdaterTask)((Object)((Object)SoftReference.dereference(this.myTaskRef)));
                if (task2 != null) {
                    task2.cancelTask();
                }
                Disposer.dispose((Disposable)session2);
                return Boolean.TRUE;
            }).createPopup();
            this.updateInBackground(session2, component, title, (AbstractPopup)popup2, (Ref<UsageView>)usageView);
            PopupPositionManager.positionPopupInBestPosition(popup2, session2.getEditor(), DataManager.getInstance().getDataContext());
            component.setHint(popup2, title);
            this.myPopupRef = new WeakReference<JBPopup>(popup2);
        }
    }

    private void updateInBackground(@NotNull ImplementationViewSession session2, @NotNull ImplementationViewComponent component, String title, @NotNull AbstractPopup popup2, @NotNull Ref<UsageView> usageView) {
        ImplementationsUpdaterTask updaterTask = (ImplementationsUpdaterTask)((Object)SoftReference.dereference(this.myTaskRef));
        if (updaterTask != null) {
            updaterTask.cancelTask();
        }
        if (!session2.needUpdateInBackground()) {
            return;
        }
        ImplementationsUpdaterTask task2 = new ImplementationsUpdaterTask(session2, title, component);
        task2.init(popup2, new ImplementationViewComponentUpdater(component, session2.elementRequiresIncludeSelf() ? 1 : 0), usageView);
        this.myTaskRef = new WeakReference<ImplementationsUpdaterTask>(task2);
        ProgressManager.getInstance().runProcessWithProgressAsynchronously((Task.Backgroundable)task2, (ProgressIndicator)new BackgroundableProcessIndicator(task2));
    }

    protected boolean isIncludeAlwaysSelf() {
        return true;
    }

    protected boolean isSearchDeep() {
        return false;
    }

    private static class ImplementationsUpdaterTask
    extends BackgroundUpdaterTask {
        private final String myCaption;
        private final ImplementationViewSession mySession;
        private final ImplementationViewComponent myComponent;
        private List<ImplementationViewElement> myElements;

        private ImplementationsUpdaterTask(ImplementationViewSession session2, String caption, ImplementationViewComponent component) {
            super(session2.getProject(), ImplementationSearcher.SEARCHING_FOR_IMPLEMENTATIONS, null);
            this.myCaption = caption;
            this.mySession = session2;
            this.myComponent = component;
        }

        @Override
        public String getCaption(int size) {
            return this.myCaption;
        }

        @Override
        public void run(@NotNull ProgressIndicator indicator) {
            super.run(indicator);
            this.myElements = this.mySession.searchImplementationsInBackground(indicator, (Processor<PsiElement>)((Processor)this::updateComponent));
        }

        @Override
        public int getCurrentSize() {
            if (this.myElements != null) {
                return this.myElements.size();
            }
            return super.getCurrentSize();
        }

        @Override
        public void onSuccess() {
            if (!this.cancelTask()) {
                this.myComponent.update(this.myElements, this.myComponent.getIndex());
            }
            super.onSuccess();
        }
    }

    private static class ImplementationViewComponentUpdater
    implements ListComponentUpdater {
        private final ImplementationViewComponent myComponent;
        private final int myIncludeSelfIdx;

        ImplementationViewComponentUpdater(ImplementationViewComponent component, int includeSelfIdx) {
            this.myComponent = component;
            this.myIncludeSelfIdx = includeSelfIdx;
        }

        public void paintBusy(boolean paintBusy) {
        }

        public void replaceModel(@NotNull List<? extends PsiElement> data) {
            ImplementationViewElement[] elements = this.myComponent.getElements();
            int includeSelfIdx = this.myIncludeSelfIdx;
            int startIdx = elements.length - includeSelfIdx;
            ArrayList<ImplementationViewElement> result2 = new ArrayList<ImplementationViewElement>();
            Collections.addAll(result2, elements);
            for (PsiElement psiElement : data.subList(startIdx, data.size())) {
                result2.add(new PsiImplementationViewElement(psiElement));
            }
            this.myComponent.update(result2, this.myComponent.getIndex());
        }
    }
}

