/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.hints.HintInfo;
import com.intellij.codeInsight.hints.InlayParameterHintsExtension;
import com.intellij.codeInsight.hints.InlayParameterHintsProvider;
import com.intellij.codeInsight.hints.PopupActionsKt;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u00012\u00020\u0002:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\b\u0010\u0007\u001a\u00020\u0005H\u0002J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\u0005H\u0016J!\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0096\u0002J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/codeInsight/hints/DisableCustomHintsOption;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "()V", "lastOptionName", "", "getFamilyName", "getIntentionText", "getOptionHintAtOffset", "Lcom/intellij/codeInsight/hints/HintInfo$OptionInfo;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "isAvailable", "", "startInWriteAction", "Companion", "intellij.platform.lang.impl"})
public final class DisableCustomHintsOption
implements IntentionAction,
LowPriorityAction {
    private String lastOptionName = "";
    private static final String presentableFamilyName;
    public static final Companion Companion;

    @NotNull
    public String getText() {
        return this.getIntentionText();
    }

    private final String getIntentionText() {
        if (StringsKt.startsWith((String)this.lastOptionName, (String)"show", (boolean)true)) {
            String string = this.lastOptionName;
            StringBuilder stringBuilder = new StringBuilder().append("Do not ");
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
            String string4 = string3;
            return stringBuilder.append(string4).toString();
        }
        return CodeInsightBundle.message((String)"inlay.hints.disable.custom.option", (Object[])new Object[]{this.lastOptionName});
    }

    @NotNull
    public String getFamilyName() {
        return presentableFamilyName;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        if ((InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(file2.getLanguage()) == null) {
            return false;
        }
        if (!PopupActionsKt.access$hasEditorParameterHintAtOffset(editor, file2)) {
            return false;
        }
        HintInfo.OptionInfo optionInfo = this.getOptionHintAtOffset(editor, file2);
        if (optionInfo == null) {
            return false;
        }
        HintInfo.OptionInfo option2 = optionInfo;
        this.lastOptionName = option2.getOptionName();
        return true;
    }

    private final HintInfo.OptionInfo getOptionHintAtOffset(Editor editor, PsiFile file2) {
        int offset = editor.getCaretModel().getOffset();
        HintInfo hintInfo = PopupActionsKt.access$getHintInfoFromProvider(offset, file2, editor);
        if (!(hintInfo instanceof HintInfo.OptionInfo)) {
            hintInfo = null;
        }
        return (HintInfo.OptionInfo)hintInfo;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        HintInfo.OptionInfo optionInfo = this.getOptionHintAtOffset(editor, file2);
        if (optionInfo == null) {
            return;
        }
        HintInfo.OptionInfo option2 = optionInfo;
        option2.disable();
        PopupActionsKt.access$refreshAllOpenEditors();
    }

    public boolean startInWriteAction() {
        return false;
    }

    static {
        Companion = new Companion(null);
        presentableFamilyName = CodeInsightBundle.message((String)"inlay.hints.intention.family.name", (Object[])new Object[0]);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/codeInsight/hints/DisableCustomHintsOption$Companion;", "", "()V", "presentableFamilyName", "", "kotlin.jvm.PlatformType", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

