/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeHighlighting.EditorBoundHighlightingPass;
import com.intellij.codeInsight.daemon.impl.ParameterHintsPresentationManager;
import com.intellij.codeInsight.hints.HintInfo;
import com.intellij.codeInsight.hints.HintInfoFilter;
import com.intellij.codeInsight.hints.HintWidthAdjustment;
import com.intellij.codeInsight.hints.InlayParameterHintsExtension;
import com.intellij.codeInsight.hints.InlayParameterHintsProvider;
import com.intellij.codeInsight.hints.MethodInfoBlacklistFilter;
import com.intellij.codeInsight.hints.ParameterHintsPassFactory;
import com.intellij.codeInsight.hints.ParameterHintsUpdater;
import com.intellij.diff.util.DiffUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.ex.util.CaretVisualPositionKeeper;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class ParameterHintsPass
extends EditorBoundHighlightingPass {
    private final TIntObjectHashMap<List<HintData>> myHints = new TIntObjectHashMap();
    private final TIntObjectHashMap<String> myShowOnlyIfExistedBeforeHints = new TIntObjectHashMap();
    private final SyntaxTraverser<PsiElement> myTraverser;
    private final PsiElement myRootElement;
    private final HintInfoFilter myHintInfoFilter;
    private final boolean myForceImmediateUpdate;

    public static void syncUpdate(@NotNull PsiElement element, @NotNull Editor editor) {
        MethodInfoBlacklistFilter filter = MethodInfoBlacklistFilter.forLanguage(element.getLanguage());
        ParameterHintsPass pass = new ParameterHintsPass(element, editor, filter, true);
        try {
            pass.doCollectInformation(new ProgressIndicatorBase());
        }
        catch (IndexNotReadyException e) {
            return;
        }
        pass.applyInformationToEditor();
    }

    public ParameterHintsPass(@NotNull PsiElement element, @NotNull Editor editor, @NotNull HintInfoFilter hintsFilter, boolean forceImmediateUpdate) {
        super(editor, element.getContainingFile(), true);
        this.myRootElement = element;
        this.myTraverser = SyntaxTraverser.psiTraverser((PsiElement)element);
        this.myHintInfoFilter = hintsFilter;
        this.myForceImmediateUpdate = forceImmediateUpdate;
    }

    @Override
    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        assert (this.myDocument != null);
        this.myHints.clear();
        Language language = this.myFile.getLanguage();
        InlayParameterHintsProvider provider = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(language);
        if (provider == null || !provider.canShowHintsWhenDisabled() && !ParameterHintsPass.isEnabled() || DiffUtil.isDiffEditor(this.myEditor)) {
            return;
        }
        this.myTraverser.forEach(element -> this.process((PsiElement)element, provider));
    }

    private static boolean isEnabled() {
        return EditorSettingsExternalizable.getInstance().isShowParameterNameHints();
    }

    private void process(PsiElement element, InlayParameterHintsProvider provider) {
        List hints = provider.getParameterHints(element);
        if (hints.isEmpty()) {
            return;
        }
        HintInfo info = provider.getHintInfo(element);
        boolean showHints = info == null || info instanceof HintInfo.OptionInfo || this.myHintInfoFilter.showHint(info);
        Stream<Object> inlays = hints.stream();
        if (!showHints) {
            inlays = inlays.filter(inlayInfo -> !inlayInfo.isFilterByBlacklist());
        }
        inlays.forEach(hint -> {
            int offset = hint.getOffset();
            if (!this.canShowHintsAtOffset(offset)) {
                return;
            }
            String presentation = provider.getInlayPresentation(hint.getText());
            if (hint.isShowOnlyIfExistedBefore()) {
                this.myShowOnlyIfExistedBeforeHints.put(offset, (Object)presentation);
            } else {
                ArrayList<HintData> hintList = (ArrayList<HintData>)this.myHints.get(offset);
                if (hintList == null) {
                    hintList = new ArrayList<HintData>();
                    this.myHints.put(offset, hintList);
                }
                HintWidthAdjustment widthAdjustment = ParameterHintsPass.convertHintPresentation(hint.getWidthAdjustment(), provider);
                hintList.add(new HintData(presentation, hint.getRelatesToPrecedingText(), widthAdjustment));
            }
        });
    }

    private static HintWidthAdjustment convertHintPresentation(HintWidthAdjustment widthAdjustment, InlayParameterHintsProvider provider) {
        String adjusterHintPresentation;
        String hintText;
        if (widthAdjustment != null && (hintText = widthAdjustment.getHintTextToMatch()) != null && !hintText.equals(adjusterHintPresentation = provider.getInlayPresentation(hintText))) {
            widthAdjustment = new HintWidthAdjustment(widthAdjustment.getEditorTextToMatch(), adjusterHintPresentation, widthAdjustment.getAdjustmentPosition());
        }
        return widthAdjustment;
    }

    @Override
    public void doApplyInformationToEditor() {
        CaretVisualPositionKeeper keeper = new CaretVisualPositionKeeper(this.myEditor);
        ParameterHintsPresentationManager manager = ParameterHintsPresentationManager.getInstance();
        List<Inlay> hints = this.hintsInRootElementArea(manager);
        ParameterHintsUpdater updater = new ParameterHintsUpdater(this.myEditor, hints, this.myHints, this.myShowOnlyIfExistedBeforeHints, this.myForceImmediateUpdate);
        updater.update();
        keeper.restoreOriginalLocation(false);
        if (ParameterHintsUpdater.hintRemovalDelayed(this.myEditor)) {
            ParameterHintsPassFactory.forceHintsUpdateOnNextPass(this.myEditor);
        } else if (this.myRootElement == this.myFile) {
            ParameterHintsPassFactory.putCurrentPsiModificationStamp(this.myEditor, this.myFile);
        }
    }

    @NotNull
    private List<Inlay> hintsInRootElementArea(ParameterHintsPresentationManager manager) {
        assert (this.myDocument != null);
        TextRange range2 = this.myRootElement.getTextRange();
        int elementStart = range2.getStartOffset();
        int elementEnd = range2.getEndOffset();
        if (this.myDocument.getTextLength() != range2.getLength()) {
            ++elementStart;
            --elementEnd;
        }
        return manager.getParameterHintsInRange(this.myEditor, elementStart, elementEnd);
    }

    private boolean canShowHintsAtOffset(int offset) {
        TextRange rootRange = this.myRootElement.getTextRange();
        if (!rootRange.containsOffset(offset)) {
            return false;
        }
        if (offset > rootRange.getStartOffset() && offset < rootRange.getEndOffset()) {
            return true;
        }
        return this.myDocument != null && this.myDocument.getTextLength() == rootRange.getLength();
    }

    public static class HintData {
        public final String presentationText;
        public final boolean relatesToPrecedingText;
        public final HintWidthAdjustment widthAdjustment;

        public HintData(String text, boolean relatesToPrecedingText, HintWidthAdjustment widthAdjustment) {
            this.presentationText = text;
            this.relatesToPrecedingText = relatesToPrecedingText;
            this.widthAdjustment = widthAdjustment;
        }
    }
}

