/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.ParameterHintsPresentationManager;
import com.intellij.codeInsight.hints.HintInfo;
import com.intellij.codeInsight.hints.InlayParameterHintsExtension;
import com.intellij.codeInsight.hints.InlayParameterHintsProvider;
import com.intellij.codeInsight.hints.ParameterHintsPassFactory;
import com.intellij.codeInsight.hints.PopupActionsKt$sam$com_intellij_openapi_util_Condition$0;
import com.intellij.codeInsight.hints.settings.ParameterNameHintsConfigurable;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000N\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\b\u0010\n\u001a\u00020\u000bH\u0002\u001a$\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010\u001a\f\u0010\u0012\u001a\u00020\u0011*\u00020\u0011H\u0002\u001a\f\u0010\u0013\u001a\u00020\u0011*\u00020\u0011H\u0002\u001a\u0014\u0010\u0014\u001a\u00020\t*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001a\u0012\u0010\u0018\u001a\u00020\t*\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u0007\u001a\n\u0010\u0019\u001a\u00020\u0011*\u00020\u001a\u00a8\u0006\u001b"}, d2={"getHintInfoFromProvider", "Lcom/intellij/codeInsight/hints/HintInfo;", "offset", "", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "hasEditorParameterHintAtOffset", "", "refreshAllOpenEditors", "", "showParameterHintsDialog", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getPattern", "Lkotlin/Function1;", "", "capitalize", "capitalizeFirstLetter", "hasDisabledOptionHintInfo", "Lcom/intellij/codeInsight/hints/InlayParameterHintsProvider;", "element", "Lcom/intellij/psi/PsiElement;", "isOwnsInlayInEditor", "toPattern", "Lcom/intellij/codeInsight/hints/HintInfo$MethodInfo;", "intellij.platform.lang.impl"})
public final class PopupActionsKt {
    public static final void showParameterHintsDialog(@NotNull AnActionEvent e, @NotNull Function1<? super HintInfo, String> getPattern) {
        HintInfo.MethodInfo methodInfo;
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(e.getDataContext());
        if (psiFile == null) {
            return;
        }
        PsiFile file2 = psiFile;
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(e.getDataContext());
        if (editor == null) {
            return;
        }
        Editor editor2 = editor;
        Language fileLanguage = file2.getLanguage();
        if ((InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(fileLanguage) == null) {
            return;
        }
        int offset = editor2.getCaretModel().getOffset();
        HintInfo hintInfo = PopupActionsKt.getHintInfoFromProvider(offset, file2, editor2);
        if (hintInfo == null) {
            return;
        }
        HintInfo info = hintInfo;
        HintInfo hintInfo2 = info;
        if (!(hintInfo2 instanceof HintInfo.MethodInfo)) {
            hintInfo2 = null;
        }
        if ((methodInfo = (HintInfo.MethodInfo)hintInfo2) == null || (methodInfo = methodInfo.getLanguage()) == null) {
            methodInfo = fileLanguage;
        }
        HintInfo.MethodInfo selectedLanguage = methodInfo;
        ParameterNameHintsConfigurable dialog2 = new ParameterNameHintsConfigurable((Language)selectedLanguage, (String)getPattern.invoke((Object)info));
        dialog2.show();
    }

    private static final boolean hasDisabledOptionHintInfo(@NotNull InlayParameterHintsProvider $receiver, PsiElement element) {
        HintInfo info = $receiver.getHintInfo(element);
        return info instanceof HintInfo.OptionInfo && !((HintInfo.OptionInfo)info).isOptionEnabled();
    }

    private static final boolean hasEditorParameterHintAtOffset(Editor editor, PsiFile file2) {
        if (editor instanceof EditorWindow) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file2.findElementAt(offset);
        PsiElement psiElement = element;
        int startOffset = psiElement != null && (psiElement = psiElement.getTextRange()) != null ? psiElement.getStartOffset() : offset;
        PsiElement psiElement2 = element;
        int endOffset = psiElement2 != null && (psiElement2 = psiElement2.getTextRange()) != null ? psiElement2.getEndOffset() : offset;
        return !ParameterHintsPresentationManager.getInstance().getParameterHintsInRange(editor, startOffset, endOffset).isEmpty();
    }

    private static final void refreshAllOpenEditors() {
        Project[] $receiver$iv;
        ParameterHintsPassFactory.forceHintsUpdateOnNextPass();
        Project[] projectArray = $receiver$iv = ProjectManager.getInstance().getOpenProjects();
        int n = projectArray.length;
        for (int i = 0; i < n; ++i) {
            VirtualFile[] $receiver$iv2;
            Project element$iv;
            Project it = element$iv = projectArray[i];
            boolean bl = false;
            PsiManager psiManager = PsiManager.getInstance((Project)it);
            DaemonCodeAnalyzer daemonCodeAnalyzer = DaemonCodeAnalyzer.getInstance((Project)it);
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)it);
            VirtualFile[] virtualFileArray = $receiver$iv2 = fileEditorManager.getSelectedFiles();
            int n2 = virtualFileArray.length;
            for (int j = 0; j < n2; ++j) {
                PsiFile psiFile;
                VirtualFile element$iv2;
                VirtualFile it2 = element$iv2 = virtualFileArray[j];
                boolean bl2 = false;
                if (psiManager.findFile(it2) == null) continue;
                PsiFile it3 = psiFile;
                boolean bl3 = false;
                daemonCodeAnalyzer.restart(it3);
            }
        }
    }

    private static final HintInfo getHintInfoFromProvider(int offset, PsiFile file2, Editor editor) {
        Function1 isHintOwnedByElement2;
        PsiElement psiElement = file2.findElementAt(offset);
        if (psiElement == null) {
            return null;
        }
        PsiElement element = psiElement;
        InlayParameterHintsProvider inlayParameterHintsProvider = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(file2.getLanguage());
        if (inlayParameterHintsProvider == null) {
            return null;
        }
        InlayParameterHintsProvider provider = inlayParameterHintsProvider;
        Function1 function1 = isHintOwnedByElement2 = (Function1)new Function1<PsiElement, Boolean>(provider, editor){
            final /* synthetic */ InlayParameterHintsProvider $provider;
            final /* synthetic */ Editor $editor;

            public final boolean invoke(@NotNull PsiElement e) {
                return this.$provider.getHintInfo(e) != null && PopupActionsKt.isOwnsInlayInEditor(e, this.$editor);
            }
            {
                this.$provider = inlayParameterHintsProvider;
                this.$editor = editor;
                super(1);
            }
        };
        PsiElement psiElement2 = PsiTreeUtil.findFirstParent((PsiElement)element, (Condition)new PopupActionsKt$sam$com_intellij_openapi_util_Condition$0(function1));
        if (psiElement2 == null) {
            return null;
        }
        PsiElement method = psiElement2;
        return provider.getHintInfo(method);
    }

    public static final boolean isOwnsInlayInEditor(@NotNull PsiElement $receiver, @NotNull Editor editor) {
        if ($receiver.getTextRange() == null) {
            return false;
        }
        int start2 = $receiver.getTextRange().isEmpty() ? $receiver.getTextRange().getStartOffset() : $receiver.getTextRange().getStartOffset() + 1;
        return editor.getInlayModel().hasInlineElementsInRange(start2, $receiver.getTextRange().getEndOffset());
    }

    @NotNull
    public static final String toPattern(@NotNull HintInfo.MethodInfo $receiver) {
        return $receiver.getFullyQualifiedName() + '(' + CollectionsKt.joinToString$default((Iterable)$receiver.getParamNames(), (CharSequence)",", null, null, (int)0, null, null, (int)62, null) + ')';
    }

    private static final String capitalize(@NotNull String $receiver) {
        return StringUtil.capitalizeWords((String)$receiver, (boolean)true);
    }

    private static final String capitalizeFirstLetter(@NotNull String $receiver) {
        return StringUtil.capitalize((String)$receiver);
    }

    public static final /* synthetic */ HintInfo access$getHintInfoFromProvider(int offset, PsiFile file2, Editor editor) {
        return PopupActionsKt.getHintInfoFromProvider(offset, file2, editor);
    }

    public static final /* synthetic */ boolean access$hasEditorParameterHintAtOffset(Editor editor, PsiFile file2) {
        return PopupActionsKt.hasEditorParameterHintAtOffset(editor, file2);
    }

    public static final /* synthetic */ void access$refreshAllOpenEditors() {
        PopupActionsKt.refreshAllOpenEditors();
    }

    public static final /* synthetic */ String access$capitalizeFirstLetter(String $receiver) {
        return PopupActionsKt.capitalizeFirstLetter($receiver);
    }

    public static final /* synthetic */ boolean access$hasDisabledOptionHintInfo(InlayParameterHintsProvider $receiver, PsiElement element) {
        return PopupActionsKt.hasDisabledOptionHintInfo($receiver, element);
    }

    public static final /* synthetic */ String access$capitalize(String $receiver) {
        return PopupActionsKt.capitalize($receiver);
    }
}

