/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints.settings;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.hints.HintUtilsKt;
import com.intellij.codeInsight.hints.InlayParameterHintsExtension;
import com.intellij.codeInsight.hints.InlayParameterHintsProvider;
import com.intellij.codeInsight.hints.Option;
import com.intellij.codeInsight.hints.ParameterHintsPassFactory;
import com.intellij.codeInsight.hints.settings.Diff;
import com.intellij.codeInsight.hints.settings.ParameterNameHintsSettings;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.labels.SwingActionLink;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jdesktop.swingx.combobox.ListComboBoxModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParameterNameHintsConfigurable
extends DialogWrapper {
    private static final String LAST_EDITED_LANGUAGE_ID_KEY = "param.hints.settings.last.edited.language";
    private JPanel myConfigurable;
    private ComboBox<Language> myCurrentLanguageCombo;
    private Map<Language, EditorTextField> myEditors;
    private Map<Language, Boolean> myIsValidPatterns;
    private Map<Option, JBCheckBox> myOptions;
    private JPanel myPanel;
    private CardLayout myCardLayout;

    public ParameterNameHintsConfigurable() {
        this(null, null);
    }

    public ParameterNameHintsConfigurable(@Nullable Language selectedLanguage, @Nullable String newPreselectedPattern) {
        super(null);
        this.$$$setupUI$$$();
        this.setTitle("Configure Parameter Name Hints");
        this.init();
        if (selectedLanguage != null) {
            selectedLanguage = HintUtilsKt.getLanguageForSettingKey(selectedLanguage);
            this.showLanguagePanel(selectedLanguage);
            this.myCurrentLanguageCombo.setSelectedItem((Object)selectedLanguage);
            if (newPreselectedPattern != null) {
                this.addSelectedText(selectedLanguage, newPreselectedPattern);
            }
        }
    }

    private void addSelectedText(@NotNull Language language, @NotNull String newPreselectedPattern) {
        EditorTextField textField2 = this.myEditors.get(language);
        String text = textField2.getText();
        int startOffset = text.length();
        text = text + "\n" + newPreselectedPattern;
        int endOffset = text.length();
        textField2.setText(text);
        textField2.addSettingsProvider(editor -> {
            SelectionModel model = editor.getSelectionModel();
            model.setSelection(startOffset + 1, endOffset);
        });
    }

    private void updateOkEnabled(@NotNull Language language, @NotNull EditorTextField editorTextField) {
        String text = editorTextField.getText();
        List<Integer> invalidLines = HintUtilsKt.getBlackListInvalidLineNumbers(text);
        this.myIsValidPatterns.put(language, invalidLines.isEmpty());
        boolean isEveryOneValid = !this.myIsValidPatterns.containsValue(false);
        this.getOKAction().setEnabled(isEveryOneValid);
        Editor editor = editorTextField.getEditor();
        if (editor != null) {
            ParameterNameHintsConfigurable.highlightErrorLines(invalidLines, editor);
        }
    }

    private static void highlightErrorLines(@NotNull List<Integer> lines2, @NotNull Editor editor) {
        TextAttributes attributes = editor.getColorsScheme().getAttributes(CodeInsightColors.ERRORS_ATTRIBUTES);
        Document document = editor.getDocument();
        int totalLines = document.getLineCount();
        MarkupModel model = editor.getMarkupModel();
        model.removeAllHighlighters();
        lines2.stream().filter(current -> current < totalLines).forEach(line -> model.addLineHighlighter(line.intValue(), 5000, attributes));
    }

    protected void doOKAction() {
        this.myEditors.forEach((language, editor) -> {
            String blacklist = editor.getText();
            ParameterNameHintsConfigurable.storeBlackListDiff(language, blacklist);
        });
        this.myOptions.forEach((option2, checkBox2) -> option2.set(checkBox2.isSelected()));
        this.saveLastEditedLanguage();
        ParameterHintsPassFactory.forceHintsUpdateOnNextPass();
        super.doOKAction();
    }

    public void doCancelAction() {
        this.saveLastEditedLanguage();
        super.doCancelAction();
    }

    private void saveLastEditedLanguage() {
        Arrays.stream(this.myPanel.getComponents()).filter(Component::isVisible).findFirst().ifPresent(component -> ParameterNameHintsConfigurable.saveLastEditedLanguage(component.getName()));
    }

    private static void storeBlackListDiff(@NotNull Language language, @NotNull String text) {
        Set updatedBlackList = StringUtil.split((String)text, (String)"\n").stream().filter(e -> !e.trim().isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new));
        InlayParameterHintsProvider provider = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(language);
        Set defaultBlackList = provider.getDefaultBlackList();
        Diff diff = Diff.Builder.build(defaultBlackList, updatedBlackList);
        ParameterNameHintsSettings.getInstance().setBlackListDiff(HintUtilsKt.getLanguageForSettingKey(language), diff);
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myConfigurable;
    }

    private void createUIComponents() {
        this.myOptions = ContainerUtil.newHashMap();
        this.myEditors = ContainerUtil.newHashMap();
        this.myIsValidPatterns = ContainerUtil.newHashMap();
        List<Language> allLanguages = HintUtilsKt.getBaseLanguagesWithProviders();
        Language lastEditedLanguage = ParameterNameHintsConfigurable.lastEditedLanguage();
        Language selected = lastEditedLanguage != null ? lastEditedLanguage : allLanguages.get(0);
        this.initLanguageCombo(selected, allLanguages);
        this.myCardLayout = new CardLayout();
        this.myPanel = new JPanel(this.myCardLayout);
        allLanguages.forEach(language -> {
            JPanel panel2 = this.createLanguagePanel((Language)language);
            panel2.setName(language.getID());
            this.myPanel.add((Component)panel2, language.getID());
        });
        this.myCardLayout.show(this.myPanel, selected.getID());
    }

    @Nullable
    private static Language lastEditedLanguage() {
        String id = PropertiesComponent.getInstance().getValue(LAST_EDITED_LANGUAGE_ID_KEY);
        if (id == null) {
            return null;
        }
        return Language.findLanguageByID((String)id);
    }

    private static void saveLastEditedLanguage(@NotNull String id) {
        PropertiesComponent.getInstance().setValue(LAST_EDITED_LANGUAGE_ID_KEY, id);
    }

    @NotNull
    private JPanel createLanguagePanel(@NotNull Language language) {
        JPanel blacklistPanel = this.createBlacklistPanel(language);
        JPanel optionsPanel = this.createOptionsPanel(language);
        JPanel panel2 = new JPanel();
        BoxLayout layout = new BoxLayout(panel2, 1);
        panel2.setLayout(layout);
        if (blacklistPanel != null) {
            panel2.add(blacklistPanel);
        }
        if (optionsPanel != null) {
            panel2.add(optionsPanel);
        }
        return panel2;
    }

    @Nullable
    private JPanel createBlacklistPanel(final @NotNull Language language) {
        InlayParameterHintsProvider provider = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(language);
        if (!provider.isBlackListSupported()) {
            return null;
        }
        String blackList = ParameterNameHintsConfigurable.getLanguageBlackList(language);
        final EditorTextField editorTextField = ParameterNameHintsConfigurable.createBlacklistEditorField(blackList);
        editorTextField.addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                ParameterNameHintsConfigurable.this.updateOkEnabled(language, editorTextField);
            }
        });
        this.updateOkEnabled(language, editorTextField);
        this.myEditors.put(language, editorTextField);
        JPanel blacklistPanel = new JPanel();
        BoxLayout layout = new BoxLayout(blacklistPanel, 1);
        blacklistPanel.setLayout(layout);
        blacklistPanel.setBorder(IdeBorderFactory.createTitledBorder((String)"Blacklist"));
        JBLabel explanation = new JBLabel(ParameterNameHintsConfigurable.getBlacklistExplanationHTML(language));
        explanation.setAlignmentX(0.0f);
        blacklistPanel.add((Component)explanation);
        JComponent resetPanel = this.createResetPanel(language);
        resetPanel.setAlignmentX(0.0f);
        blacklistPanel.add(resetPanel);
        editorTextField.setAlignmentX(0.0f);
        blacklistPanel.add((Component)((Object)editorTextField));
        JBLabel label2 = ParameterNameHintsConfigurable.blacklistDependencyInfoLabel(language);
        if (label2 != null) {
            label2.setAlignmentX(0.0f);
            blacklistPanel.add((Component)label2);
        }
        return blacklistPanel;
    }

    @Nullable
    private static JBLabel blacklistDependencyInfoLabel(@NotNull Language language) {
        InlayParameterHintsProvider provider = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(language);
        Language dependencyLanguage = provider.getBlackListDependencyLanguage();
        if (dependencyLanguage == null) {
            return null;
        }
        return new JBLabel("<html>Additionally <b>" + dependencyLanguage.getDisplayName() + "</b> language blacklist will be applied.</html>");
    }

    @NotNull
    private JComponent createResetPanel(final @NotNull Language language) {
        SwingActionLink link2 = new SwingActionLink((Action)new AbstractAction("Reset"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParameterNameHintsConfigurable.this.setLanguageBlacklistToDefault(language);
            }
        });
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add((Component)link2);
        return box;
    }

    private void setLanguageBlacklistToDefault(Language language) {
        InlayParameterHintsProvider provider = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(language);
        Set defaultBlacklist = provider.getDefaultBlackList();
        EditorTextField editor = this.myEditors.get(language);
        editor.setText(StringUtil.join((Collection)defaultBlacklist, (String)"\n"));
    }

    @NotNull
    private static String getBlacklistExplanationHTML(Language language) {
        InlayParameterHintsProvider hintsProvider = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(language);
        if (hintsProvider == null) {
            return CodeInsightBundle.message((String)"inlay.hints.blacklist.pattern.explanation", (Object[])new Object[0]);
        }
        return hintsProvider.getBlacklistExplanationHTML();
    }

    @Nullable
    private JPanel createOptionsPanel(@NotNull Language language) {
        List<Option> options = ParameterNameHintsConfigurable.getOptions(language);
        if (options.isEmpty()) {
            return null;
        }
        JPanel languageOptionsPanel = new JPanel();
        BoxLayout boxLayout = new BoxLayout(languageOptionsPanel, 1);
        languageOptionsPanel.setLayout(boxLayout);
        if (!options.isEmpty()) {
            languageOptionsPanel.setBorder(IdeBorderFactory.createTitledBorder((String)"Options"));
        }
        for (Option option2 : options) {
            JBCheckBox box = new JBCheckBox(option2.getName(), option2.get());
            this.myOptions.put(option2, box);
            languageOptionsPanel.add((Component)box);
        }
        return languageOptionsPanel;
    }

    private void initLanguageCombo(Language selected, List<Language> languages) {
        ListComboBoxModel model = new ListComboBoxModel(languages);
        this.myCurrentLanguageCombo = new ComboBox((ComboBoxModel)model);
        this.myCurrentLanguageCombo.setSelectedItem((Object)selected);
        this.myCurrentLanguageCombo.setRenderer((ListCellRenderer)new ListCellRendererWrapper<Language>(){

            public void customize(JList list2, Language value, int index, boolean selected, boolean hasFocus) {
                this.setText(value.getDisplayName());
            }
        });
        this.myCurrentLanguageCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Language language = (Language)e.getItem();
                if (e.getStateChange() == 1) {
                    ParameterNameHintsConfigurable.this.showLanguagePanel(language);
                }
            }
        });
    }

    private void showLanguagePanel(@NotNull Language language) {
        this.myCardLayout.show(this.myPanel, language.getID());
    }

    private static List<Option> getOptions(Language language) {
        InlayParameterHintsProvider provider = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(language);
        if (provider != null) {
            return provider.getSupportedOptions();
        }
        return ContainerUtil.emptyList();
    }

    @NotNull
    private static String getLanguageBlackList(@NotNull Language language) {
        InlayParameterHintsProvider hintsProvider = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(language);
        if (hintsProvider == null) {
            return "";
        }
        Diff diff = ParameterNameHintsSettings.getInstance().getBlackListDiff(HintUtilsKt.getLanguageForSettingKey(language));
        Set blackList = diff.applyOn(hintsProvider.getDefaultBlackList());
        return StringUtil.join((Collection)blackList, (String)"\n");
    }

    @NotNull
    private static EditorTextField createBlacklistEditorField(@NotNull String text) {
        Document document = EditorFactory.getInstance().createDocument((CharSequence)text);
        EditorTextField field = new EditorTextField(document, null, (FileType)FileTypes.PLAIN_TEXT, false, false);
        field.setPreferredSize(new Dimension(200, 350));
        field.addSettingsProvider(editor -> {
            editor.setVerticalScrollbarVisible(true);
            editor.setHorizontalScrollbarVisible(true);
            editor.getSettings().setAdditionalLinesCount(2);
            ParameterNameHintsConfigurable.highlightErrorLines(HintUtilsKt.getBlackListInvalidLineNumbers(text), editor);
        });
        return field;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.createUIComponents();
        this.myConfigurable = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, "Center");
        JPanel jPanel3 = this.myPanel;
        jPanel2.add((Component)jPanel3, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        ComboBox<Language> comboBox2 = this.myCurrentLanguageCombo;
        jPanel4.add((Component)comboBox2, new GridConstraints(0, 1, 1, 1, 0, 0, 2, 0, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Language:");
        jPanel4.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myConfigurable;
    }
}

