/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionDelegate;
import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.codeInsight.intention.impl.IntentionActionWithTextCaching;
import com.intellij.codeInsight.intention.impl.IntentionGroup;
import com.intellij.codeInsight.intention.impl.ShowIntentionActionsHandler;
import com.intellij.codeInsight.intention.impl.config.IntentionManagerSettings;
import com.intellij.codeInspection.SuppressIntentionActionFromFix;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CachedIntentions {
    private static final Logger LOG = Logger.getInstance(CachedIntentions.class);
    private final Set<IntentionActionWithTextCaching> myIntentions = ConcurrentCollectionFactory.createConcurrentSet(ACTION_TEXT_AND_CLASS_EQUALS);
    private final Set<IntentionActionWithTextCaching> myErrorFixes = ConcurrentCollectionFactory.createConcurrentSet(ACTION_TEXT_AND_CLASS_EQUALS);
    private final Set<IntentionActionWithTextCaching> myInspectionFixes = ConcurrentCollectionFactory.createConcurrentSet(ACTION_TEXT_AND_CLASS_EQUALS);
    private final Set<IntentionActionWithTextCaching> myGutters = ConcurrentCollectionFactory.createConcurrentSet(ACTION_TEXT_AND_CLASS_EQUALS);
    private final Set<IntentionActionWithTextCaching> myNotifications = ConcurrentCollectionFactory.createConcurrentSet(ACTION_TEXT_AND_CLASS_EQUALS);
    private int myOffset;
    @Nullable
    private final Editor myEditor;
    @NotNull
    private final PsiFile myFile;
    @NotNull
    private final Project myProject;
    private static final TObjectHashingStrategy<IntentionActionWithTextCaching> ACTION_TEXT_AND_CLASS_EQUALS = new TObjectHashingStrategy<IntentionActionWithTextCaching>(){

        public int computeHashCode(IntentionActionWithTextCaching object) {
            return object.getText().hashCode();
        }

        public boolean equals(IntentionActionWithTextCaching o1, IntentionActionWithTextCaching o2) {
            return this.getActionClass(o1) == this.getActionClass(o2) && o1.getText().equals(o2.getText());
        }

        private Class<? extends IntentionAction> getActionClass(IntentionActionWithTextCaching o1) {
            IntentionAction action = o1.getAction();
            if (action instanceof IntentionActionDelegate) {
                return ((IntentionActionDelegate)action).getDelegate().getClass();
            }
            return action.getClass();
        }
    };

    public CachedIntentions(@NotNull Project project, @NotNull PsiFile file2, @Nullable Editor editor) {
        this.myProject = project;
        this.myFile = file2;
        this.myEditor = editor;
    }

    @NotNull
    public Set<IntentionActionWithTextCaching> getIntentions() {
        return this.myIntentions;
    }

    @NotNull
    public Set<IntentionActionWithTextCaching> getErrorFixes() {
        return this.myErrorFixes;
    }

    @NotNull
    public Set<IntentionActionWithTextCaching> getInspectionFixes() {
        return this.myInspectionFixes;
    }

    @NotNull
    public Set<IntentionActionWithTextCaching> getGutters() {
        return this.myGutters;
    }

    @NotNull
    public Set<IntentionActionWithTextCaching> getNotifications() {
        return this.myNotifications;
    }

    @Nullable
    public Editor getEditor() {
        return this.myEditor;
    }

    @NotNull
    public PsiFile getFile() {
        return this.myFile;
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    public int getOffset() {
        return this.myOffset;
    }

    @NotNull
    public static CachedIntentions create(@NotNull Project project, @NotNull PsiFile file2, @Nullable Editor editor, @NotNull ShowIntentionsPass.IntentionsInfo intentions) {
        CachedIntentions res2 = new CachedIntentions(project, file2, editor);
        res2.wrapAndUpdateActions(intentions, false);
        return res2;
    }

    @NotNull
    public static CachedIntentions createAndUpdateActions(@NotNull Project project, @NotNull PsiFile file2, @Nullable Editor editor, @NotNull ShowIntentionsPass.IntentionsInfo intentions) {
        CachedIntentions res2 = new CachedIntentions(project, file2, editor);
        res2.wrapAndUpdateActions(intentions, true);
        return res2;
    }

    public boolean wrapAndUpdateActions(@NotNull ShowIntentionsPass.IntentionsInfo newInfo, boolean callUpdate) {
        this.myOffset = newInfo.getOffset();
        boolean changed = this.wrapActionsTo(newInfo.errorFixesToShow, this.myErrorFixes, callUpdate);
        changed |= this.wrapActionsTo(newInfo.inspectionFixesToShow, this.myInspectionFixes, callUpdate);
        changed |= this.wrapActionsTo(newInfo.intentionsToShow, this.myIntentions, callUpdate);
        changed |= this.wrapActionsTo(newInfo.guttersToShow, this.myGutters, callUpdate);
        return changed |= this.wrapActionsTo(newInfo.notificationActionsToShow, this.myNotifications, callUpdate);
    }

    private boolean wrapActionsTo(@NotNull List<HighlightInfo.IntentionActionDescriptor> newDescriptors, @NotNull Set<IntentionActionWithTextCaching> cachedActions, boolean callUpdate) {
        boolean changed = false;
        if (this.myEditor == null) {
            LOG.assertTrue(!callUpdate);
            for (HighlightInfo.IntentionActionDescriptor descriptor : newDescriptors) {
                changed |= cachedActions.add(this.wrapAction(descriptor, (PsiElement)this.myFile, this.myFile, null));
            }
        } else {
            Editor injectedEditor;
            PsiFile injectedFile;
            PsiFile hostElement;
            PsiFile element;
            int fileOffset;
            int caretOffset = this.myEditor.getCaretModel().getOffset();
            int n = fileOffset = caretOffset > 0 && caretOffset == this.myFile.getTextLength() ? caretOffset - 1 : caretOffset;
            if (this.myFile instanceof PsiCompiledElement) {
                hostElement = element = this.myFile;
            } else if (PsiDocumentManager.getInstance((Project)this.myProject).isUncommited(this.myEditor.getDocument())) {
                FileViewProvider viewProvider = this.myFile.getViewProvider();
                hostElement = element = viewProvider.findElementAt(fileOffset, viewProvider.getBaseLanguage());
            } else {
                hostElement = this.myFile.getViewProvider().findElementAt(fileOffset, this.myFile.getLanguage());
                element = InjectedLanguageUtil.findElementAtNoCommit(this.myFile, fileOffset);
            }
            if (element == null || element == hostElement) {
                injectedFile = this.myFile;
                injectedEditor = this.myEditor;
            } else {
                injectedFile = element.getContainingFile();
                injectedEditor = InjectedLanguageUtil.getInjectedEditorForInjectedFile(this.myEditor, injectedFile);
            }
            Iterator<IntentionActionWithTextCaching> iterator = cachedActions.iterator();
            while (iterator.hasNext()) {
                IntentionActionWithTextCaching cachedAction = iterator.next();
                IntentionAction action = cachedAction.getAction();
                if (ShowIntentionActionsHandler.availableFor(this.myFile, this.myEditor, action) || hostElement != element && (element == null || ShowIntentionActionsHandler.availableFor(injectedFile, injectedEditor, action))) continue;
                iterator.remove();
                changed = true;
            }
            THashSet wrappedNew = new THashSet(newDescriptors.size(), ACTION_TEXT_AND_CLASS_EQUALS);
            for (HighlightInfo.IntentionActionDescriptor descriptor : newDescriptors) {
                IntentionActionWithTextCaching cachedAction;
                IntentionAction action = descriptor.getAction();
                if (element != null && element != hostElement && (!callUpdate || ShowIntentionActionsHandler.availableFor(injectedFile, injectedEditor, action))) {
                    cachedAction = this.wrapAction(descriptor, (PsiElement)element, injectedFile, injectedEditor);
                    wrappedNew.add(cachedAction);
                    changed |= cachedActions.add(cachedAction);
                    continue;
                }
                if (hostElement == null || callUpdate && !ShowIntentionActionsHandler.availableFor(this.myFile, this.myEditor, action)) continue;
                cachedAction = this.wrapAction(descriptor, (PsiElement)hostElement, this.myFile, this.myEditor);
                wrappedNew.add(cachedAction);
                changed |= cachedActions.add(cachedAction);
            }
            Iterator<IntentionActionWithTextCaching> iterator2 = cachedActions.iterator();
            while (iterator2.hasNext()) {
                IntentionActionWithTextCaching cachedAction = iterator2.next();
                if (wrappedNew.contains(cachedAction)) continue;
                iterator2.remove();
                changed = true;
            }
        }
        return changed;
    }

    @NotNull
    IntentionActionWithTextCaching wrapAction(@NotNull HighlightInfo.IntentionActionDescriptor descriptor, @Nullable PsiElement element, @Nullable PsiFile containingFile, @Nullable Editor containingEditor) {
        IntentionActionWithTextCaching cachedAction = new IntentionActionWithTextCaching(descriptor, (cached, action) -> {
            this.removeActionFromCached((IntentionActionWithTextCaching)cached);
            this.markInvoked((IntentionAction)action);
        });
        if (element == null) {
            return cachedAction;
        }
        List<IntentionAction> options = descriptor.getOptions(element, containingEditor);
        if (options == null) {
            return cachedAction;
        }
        for (IntentionAction option2 : options) {
            boolean isInspectionFix;
            if (containingFile == null || containingEditor == null || this.myEditor == null ? !option2.isAvailable(this.myProject, containingEditor, containingFile) && (containingEditor == this.myEditor || !option2.isAvailable(this.myProject, this.myEditor, this.myFile)) : !ShowIntentionActionsHandler.availableFor(containingFile, containingEditor, option2) && (containingEditor == this.myEditor || !ShowIntentionActionsHandler.availableFor(this.myFile, this.myEditor, option2))) continue;
            IntentionActionWithTextCaching textCaching = new IntentionActionWithTextCaching(option2);
            boolean isErrorFix = this.myErrorFixes.contains(textCaching);
            if (isErrorFix) {
                cachedAction.addErrorFix(option2);
            }
            if (isInspectionFix = this.myInspectionFixes.contains(textCaching)) {
                cachedAction.addInspectionFix(option2);
                continue;
            }
            cachedAction.addIntention(option2);
        }
        return cachedAction;
    }

    private void markInvoked(@NotNull IntentionAction action) {
        if (this.myEditor != null) {
            ShowIntentionsPass.markActionInvoked(this.myFile.getProject(), this.myEditor, action);
        }
    }

    private void removeActionFromCached(@NotNull IntentionActionWithTextCaching action) {
        this.myErrorFixes.remove(action);
        this.myGutters.remove(action);
        this.myInspectionFixes.remove(action);
        this.myIntentions.remove(action);
        this.myNotifications.remove(action);
    }

    @NotNull
    public List<IntentionActionWithTextCaching> getAllActions() {
        List<IntentionActionWithTextCaching> result2 = new ArrayList<IntentionActionWithTextCaching>(this.myErrorFixes);
        result2.addAll(this.myInspectionFixes);
        result2.addAll(this.myIntentions);
        result2.addAll(this.myGutters);
        result2.addAll(this.myNotifications);
        result2 = DumbService.getInstance((Project)this.myProject).filterByDumbAwareness(result2);
        Collections.sort(result2, (o1, o2) -> {
            int weight2;
            int weight1 = this.getWeight((IntentionActionWithTextCaching)o1);
            if (weight1 != (weight2 = this.getWeight((IntentionActionWithTextCaching)o2))) {
                return weight2 - weight1;
            }
            return o1.compareTo((IntentionActionWithTextCaching)o2);
        });
        return result2;
    }

    private int getWeight(@NotNull IntentionActionWithTextCaching action) {
        IntentionAction a = action.getAction();
        int group = this.getGroup(action).getPriority();
        while (a instanceof IntentionActionDelegate) {
            a = ((IntentionActionDelegate)a).getDelegate();
        }
        if (a instanceof PriorityAction) {
            return group + CachedIntentions.getPriorityWeight(((PriorityAction)a).getPriority());
        }
        if (a instanceof SuppressIntentionActionFromFix && ((SuppressIntentionActionFromFix)a).isShouldBeAppliedToInjectionHost() == ThreeState.NO) {
            return group - 1;
        }
        return group;
    }

    private static int getPriorityWeight(PriorityAction.Priority priority) {
        switch (priority) {
            case TOP: {
                return 666;
            }
            case HIGH: {
                return 3;
            }
            case LOW: {
                return -3;
            }
        }
        return 0;
    }

    @NotNull
    public IntentionGroup getGroup(@NotNull IntentionActionWithTextCaching action) {
        if (this.myErrorFixes.contains(action)) {
            return IntentionGroup.ERROR;
        }
        if (this.myInspectionFixes.contains(action)) {
            return IntentionGroup.INSPECTION;
        }
        if (this.myNotifications.contains(action)) {
            return IntentionGroup.NOTIFICATION;
        }
        if (this.myGutters.contains(action)) {
            return IntentionGroup.GUTTER;
        }
        if (action.getAction() instanceof EmptyIntentionAction) {
            return IntentionGroup.EMPTY_ACTION;
        }
        return IntentionGroup.OTHER;
    }

    @NotNull
    public Icon getIcon(@NotNull IntentionActionWithTextCaching value) {
        Icon icon;
        if (value.getIcon() != null) {
            return value.getIcon();
        }
        IntentionAction action = value.getAction();
        while (action instanceof IntentionActionDelegate) {
            action = ((IntentionActionDelegate)action).getDelegate();
        }
        IntentionAction iconable = action;
        if (action instanceof QuickFixWrapper) {
            iconable = ((QuickFixWrapper)action).getFix();
        }
        if (iconable instanceof Iconable && (icon = ((Iconable)iconable).getIcon(0)) != null) {
            return icon;
        }
        if (IntentionManagerSettings.getInstance().isShowLightBulb(action)) {
            return this.myErrorFixes.contains(value) ? AllIcons.Actions.QuickfixBulb : (this.myInspectionFixes.contains(value) ? AllIcons.Actions.IntentionBulb : AllIcons.Actions.RealIntentionBulb);
        }
        if (this.myErrorFixes.contains(value)) {
            return AllIcons.Actions.QuickfixOffBulb;
        }
        Icon disabledIcon = IconLoader.getDisabledIcon((Icon)AllIcons.Actions.RealIntentionBulb);
        return disabledIcon != null ? disabledIcon : AllIcons.Actions.RealIntentionBulb;
    }

    public boolean showBulb() {
        return ContainerUtil.exists(this.getAllActions(), info -> IntentionManagerSettings.getInstance().isShowLightBulb(info.getAction()));
    }

    public String toString() {
        return "CachedIntentions{myIntentions=" + this.myIntentions + ", myErrorFixes=" + this.myErrorFixes + ", myInspectionFixes=" + this.myInspectionFixes + ", myGutters=" + this.myGutters + ", myNotifications=" + this.myNotifications + '}';
    }
}

