/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.PriorityQuestionAction;
import com.intellij.codeInsight.hint.ScrollAwareHint;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionDelegate;
import com.intellij.codeInsight.intention.impl.CachedIntentions;
import com.intellij.codeInsight.intention.impl.IntentionActionWithTextCaching;
import com.intellij.codeInsight.intention.impl.IntentionListStep;
import com.intellij.codeInsight.intention.impl.config.IntentionManagerSettings;
import com.intellij.codeInsight.unwrap.ScopeHighlighter;
import com.intellij.codeInspection.SuppressIntentionActionFromFix;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.refactoring.BaseRefactoringIntentionAction;
import com.intellij.ui.HintHint;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.PopupMenuListenerAdapter;
import com.intellij.ui.RowIcon;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.WizardPopup;
import com.intellij.util.Alarm;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntentionHintComponent
implements Disposable,
ScrollAwareHint {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.intention.impl.IntentionHintComponent.ListPopupRunnable");
    private static final Icon ourInactiveArrowIcon = EmptyIcon.create((Icon)AllIcons.General.ArrowDown);
    private static final int NORMAL_BORDER_SIZE = 6;
    private static final int SMALL_BORDER_SIZE = 4;
    private static final Border INACTIVE_BORDER = BorderFactory.createEmptyBorder(6, 6, 6, 6);
    private static final Border INACTIVE_BORDER_SMALL = BorderFactory.createEmptyBorder(4, 4, 4, 4);
    private final CachedIntentions myCachedIntentions;
    private final Editor myEditor;
    private static final Alarm myAlarm = new Alarm();
    private final RowIcon myHighlightedIcon;
    private final JLabel myIconLabel;
    private final RowIcon myInactiveIcon;
    private static final int DELAY = 500;
    private final MyComponentHint myComponentHint;
    private volatile boolean myPopupShown;
    private boolean myDisposed;
    private volatile ListPopup myPopup;
    private final PsiFile myFile;
    private final JPanel myPanel = new JPanel(){

        @Override
        public synchronized void addMouseListener(MouseListener l) {
        }
    };
    private PopupMenuListener myOuterComboboxPopupListener;

    public CachedIntentions getCachedIntentions() {
        return this.myCachedIntentions;
    }

    private static Border createActiveBorder() {
        return BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(IntentionHintComponent.getBorderColor(), 1), BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    private static Border createActiveBorderSmall() {
        return BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(IntentionHintComponent.getBorderColor(), 1), BorderFactory.createEmptyBorder(3, 3, 3, 3));
    }

    private static Color getBorderColor() {
        return EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.SELECTED_TEARLINE_COLOR);
    }

    public boolean isVisible() {
        return this.myPanel.isVisible();
    }

    @NotNull
    public static IntentionHintComponent showIntentionHint(@NotNull Project project, @NotNull PsiFile file2, @NotNull Editor editor, boolean showExpanded, @NotNull CachedIntentions cachedIntentions) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        IntentionHintComponent component = new IntentionHintComponent(project, file2, editor, cachedIntentions);
        if (editor.getSettings().isShowIntentionBulb()) {
            component.showIntentionHintImpl(!showExpanded);
        }
        if (showExpanded) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (!editor.isDisposed() && editor.getComponent().isShowing()) {
                    component.showPopup(false);
                }
            }, project.getDisposed());
        }
        return component;
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    public void dispose() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myDisposed = true;
        this.myComponentHint.hide();
        this.myPanel.hide();
        if (this.myOuterComboboxPopupListener != null) {
            Container ancestor = SwingUtilities.getAncestorOfClass(JComboBox.class, this.myEditor.getContentComponent());
            if (ancestor != null) {
                ((JComboBox)ancestor).removePopupMenuListener(this.myOuterComboboxPopupListener);
            }
            this.myOuterComboboxPopupListener = null;
        }
    }

    @Override
    public void editorScrolled() {
        this.closePopup();
    }

    public boolean isForEditor(@NotNull Editor editor) {
        return editor == this.myEditor;
    }

    @NotNull
    public PopupUpdateResult getPopupUpdateResult(boolean actionsChanged) {
        if (this.myPopup.isDisposed() || !this.myFile.isValid()) {
            return PopupUpdateResult.HIDE_AND_RECREATE;
        }
        if (!actionsChanged) {
            return PopupUpdateResult.NOTHING_CHANGED;
        }
        return this.myPopupShown ? PopupUpdateResult.HIDE_AND_RECREATE : PopupUpdateResult.CHANGED_INVISIBLE;
    }

    public void recreate() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        ListPopupStep step = this.myPopup.getListStep();
        this.recreateMyPopup(step);
    }

    @Nullable
    public IntentionAction getAction(int index) {
        if (this.myPopup == null || this.myPopup.isDisposed()) {
            return null;
        }
        List<IntentionActionWithTextCaching> values = this.myCachedIntentions.getAllActions();
        if (values.size() <= index) {
            return null;
        }
        return values.get(index).getAction();
    }

    private void showIntentionHintImpl(boolean delay) {
        Point position;
        int offset = this.myEditor.getCaretModel().getOffset();
        this.myComponentHint.setShouldDelay(delay);
        HintManagerImpl hintManager = HintManagerImpl.getInstanceImpl();
        PriorityQuestionAction action = new PriorityQuestionAction(){

            public boolean execute() {
                IntentionHintComponent.this.showPopup(false);
                return true;
            }

            @Override
            public int getPriority() {
                return -10;
            }
        };
        if (hintManager.canShowQuestionAction(action) && (position = IntentionHintComponent.getHintPosition(this.myEditor)) != null) {
            hintManager.showQuestionHint(this.myEditor, position, offset, offset, this.myComponentHint, action, (short)1);
        }
    }

    @Nullable
    private static Point getHintPosition(Editor editor) {
        Point realPoint;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return new Point();
        }
        int offset = editor.getCaretModel().getOffset();
        VisualPosition pos = editor.offsetToVisualPosition(offset);
        int line = pos.line;
        Point position = editor.visualPositionToXY(new VisualPosition(line, 0));
        LOG.assertTrue(editor.getComponent().isDisplayable());
        JComponent convertComponent = editor.getContentComponent();
        boolean oneLineEditor = editor.isOneLineMode();
        if (oneLineEditor) {
            JComponent contentComponent = editor.getContentComponent();
            Container ancestorOfClass = SwingUtilities.getAncestorOfClass(JComboBox.class, contentComponent);
            if (ancestorOfClass != null) {
                convertComponent = (JComponent)ancestorOfClass;
            } else {
                ancestorOfClass = SwingUtilities.getAncestorOfClass(JTextField.class, contentComponent);
                if (ancestorOfClass != null) {
                    convertComponent = (JComponent)ancestorOfClass;
                }
            }
            realPoint = new Point(-(AllIcons.Actions.RealIntentionBulb.getIconWidth() / 2) - 4, -(AllIcons.Actions.RealIntentionBulb.getIconHeight() / 2));
        } else {
            Rectangle visibleArea = editor.getScrollingModel().getVisibleArea();
            if (position.y < visibleArea.y || position.y >= visibleArea.y + visibleArea.height) {
                return null;
            }
            int yShift = -(6 + AllIcons.Actions.RealIntentionBulb.getIconHeight());
            if (IntentionHintComponent.canPlaceBulbOnTheSameLine(editor)) {
                yShift = -(6 + (AllIcons.Actions.RealIntentionBulb.getIconHeight() - editor.getLineHeight()) / 2 + 3);
            } else if (position.y < visibleArea.y + editor.getLineHeight()) {
                yShift = editor.getLineHeight() - 6;
            }
            int xShift = AllIcons.Actions.RealIntentionBulb.getIconWidth();
            realPoint = new Point(Math.max(0, visibleArea.x - xShift), position.y + yShift);
        }
        Point location = SwingUtilities.convertPoint(convertComponent, realPoint, editor.getComponent().getRootPane().getLayeredPane());
        return new Point(location.x, location.y);
    }

    private static boolean canPlaceBulbOnTheSameLine(Editor editor) {
        if (ApplicationManager.getApplication().isUnitTestMode() || editor.isOneLineMode()) {
            return false;
        }
        if (Registry.is((String)"always.show.intention.above.current.line", (boolean)false)) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        VisualPosition pos = editor.offsetToVisualPosition(offset);
        int line = pos.line;
        int firstNonSpaceColumnOnTheLine = EditorActionUtil.findFirstNonSpaceColumnOnTheLine(editor, line);
        if (firstNonSpaceColumnOnTheLine == -1) {
            return false;
        }
        Point point = editor.visualPositionToXY(new VisualPosition(line, firstNonSpaceColumnOnTheLine));
        return point.x > AllIcons.Actions.RealIntentionBulb.getIconWidth() + (editor.isOneLineMode() ? 4 : 6) * 2;
    }

    private IntentionHintComponent(@NotNull Project project, @NotNull PsiFile file2, final @NotNull Editor editor, @NotNull CachedIntentions cachedIntentions) {
        boolean showFix;
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myFile = file2;
        this.myEditor = editor;
        this.myCachedIntentions = cachedIntentions;
        this.myPanel.setLayout(new BorderLayout());
        this.myPanel.setOpaque(false);
        boolean showRefactoringsBulb = ContainerUtil.exists(cachedIntentions.getInspectionFixes(), descriptor -> descriptor.getAction() instanceof BaseRefactoringIntentionAction);
        boolean bl = showFix = !showRefactoringsBulb && ContainerUtil.exists(cachedIntentions.getErrorFixes(), descriptor -> IntentionManagerSettings.getInstance().isShowLightBulb(descriptor.getAction()));
        Icon smartTagIcon = showRefactoringsBulb ? AllIcons.Actions.RefactoringBulb : (showFix ? AllIcons.Actions.QuickfixBulb : AllIcons.Actions.IntentionBulb);
        this.myHighlightedIcon = new RowIcon(new Icon[]{smartTagIcon, AllIcons.General.ArrowDown});
        this.myInactiveIcon = new RowIcon(new Icon[]{smartTagIcon, ourInactiveArrowIcon});
        this.myIconLabel = new JLabel((Icon)this.myInactiveIcon);
        this.myIconLabel.setOpaque(false);
        this.myPanel.add((Component)this.myIconLabel, "Center");
        this.myPanel.setBorder(editor.isOneLineMode() ? INACTIVE_BORDER_SMALL : INACTIVE_BORDER);
        this.myIconLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(@NotNull MouseEvent e) {
                if (!e.isPopupTrigger() && e.getButton() == 1) {
                    IntentionHintComponent.this.showPopup(true);
                }
            }

            @Override
            public void mouseEntered(@NotNull MouseEvent e) {
                IntentionHintComponent.this.onMouseEnter(editor.isOneLineMode());
            }

            @Override
            public void mouseExited(@NotNull MouseEvent e) {
                IntentionHintComponent.this.onMouseExit(editor.isOneLineMode());
            }
        });
        this.myComponentHint = new MyComponentHint(this.myPanel);
        IntentionListStep step = new IntentionListStep(this, this.myEditor, this.myFile, project, this.myCachedIntentions);
        this.recreateMyPopup(step);
        EditorUtil.disposeWithEditor(this.myEditor, this);
    }

    public void hide() {
        this.myDisposed = true;
        Disposer.dispose((Disposable)this);
    }

    private void onMouseExit(boolean small) {
        Window ancestor = SwingUtilities.getWindowAncestor(this.myPopup.getContent());
        if (ancestor == null) {
            this.myIconLabel.setIcon((Icon)this.myInactiveIcon);
            this.myPanel.setBorder(small ? INACTIVE_BORDER_SMALL : INACTIVE_BORDER);
        }
    }

    private void onMouseEnter(boolean small) {
        this.myIconLabel.setIcon((Icon)this.myHighlightedIcon);
        this.myPanel.setBorder(small ? IntentionHintComponent.createActiveBorderSmall() : IntentionHintComponent.createActiveBorder());
        String acceleratorsText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("ShowIntentionActions"));
        if (!acceleratorsText.isEmpty()) {
            this.myIconLabel.setToolTipText(CodeInsightBundle.message((String)"lightbulb.tooltip", (Object[])new Object[]{acceleratorsText}));
        }
    }

    public LightweightHint getComponentHint() {
        return this.myComponentHint;
    }

    private void closePopup() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myPopup.cancel();
        this.myPopupShown = false;
    }

    private void showPopup(boolean mouseClick) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myPopup == null || this.myPopup.isDisposed() || this.myPopupShown) {
            return;
        }
        if (mouseClick && this.myPanel.isShowing()) {
            RelativePoint swCorner = RelativePoint.getSouthWestOf((JComponent)this.myPanel);
            int yOffset = IntentionHintComponent.canPlaceBulbOnTheSameLine(this.myEditor) ? 0 : this.myEditor.getLineHeight() - (this.myEditor.isOneLineMode() ? 4 : 6);
            this.myPopup.show(new RelativePoint(swCorner.getComponent(), new Point(swCorner.getPoint().x, swCorner.getPoint().y + yOffset)));
        } else {
            this.myPopup.showInBestPositionFor(this.myEditor);
        }
        this.myPopupShown = true;
    }

    private void recreateMyPopup(@NotNull ListPopupStep step) {
        Container ancestor;
        boolean committed;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myPopup != null) {
            Disposer.dispose((Disposable)this.myPopup);
        }
        this.myPopup = JBPopupFactory.getInstance().createListPopup(step);
        if (this.myPopup instanceof WizardPopup) {
            Shortcut[] shortcuts;
            for (Shortcut shortcut : shortcuts = KeymapUtil.getActiveKeymapShortcuts((String)"ShowIntentionActions").getShortcuts()) {
                KeyboardShortcut keyboardShortcut;
                if (!(shortcut instanceof KeyboardShortcut) || (keyboardShortcut = (KeyboardShortcut)shortcut).getSecondKeyStroke() != null) continue;
                ((WizardPopup)this.myPopup).registerAction("activateSelectedElement", keyboardShortcut.getFirstKeyStroke(), new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        IntentionHintComponent.this.myPopup.handleSelect(true);
                    }
                });
            }
        }
        PsiFile injectedFile = (committed = PsiDocumentManager.getInstance((Project)this.myFile.getProject()).isCommitted(this.myEditor.getDocument())) ? InjectedLanguageUtil.findInjectedPsiNoCommit(this.myFile, this.myEditor.getCaretModel().getOffset()) : null;
        Editor injectedEditor = InjectedLanguageUtil.getInjectedEditorForInjectedFile(this.myEditor, injectedFile);
        final ScopeHighlighter highlighter = new ScopeHighlighter(this.myEditor);
        final ScopeHighlighter injectionHighlighter = new ScopeHighlighter(injectedEditor);
        this.myPopup.addListener(new JBPopupListener(){

            public void onClosed(@NotNull LightweightWindowEvent event) {
                highlighter.dropHighlight();
                injectionHighlighter.dropHighlight();
                IntentionHintComponent.this.myPopupShown = false;
            }
        });
        this.myPopup.addListSelectionListener(e -> {
            Object selectedItem;
            Object source = e.getSource();
            highlighter.dropHighlight();
            injectionHighlighter.dropHighlight();
            if (source instanceof DataProvider && (selectedItem = PlatformDataKeys.SELECTED_ITEM.getData((DataProvider)source)) instanceof IntentionActionWithTextCaching) {
                IntentionAction action = ((IntentionActionWithTextCaching)selectedItem).getAction();
                if (action instanceof IntentionActionDelegate) {
                    action = ((IntentionActionDelegate)action).getDelegate();
                }
                if (action instanceof SuppressIntentionActionFromFix) {
                    if (injectedFile != null && ((SuppressIntentionActionFromFix)action).isShouldBeAppliedToInjectionHost() == ThreeState.NO) {
                        PsiElement at = injectedFile.findElementAt(injectedEditor.getCaretModel().getOffset());
                        PsiElement container = ((SuppressIntentionActionFromFix)action).getContainer(at);
                        if (container != null) {
                            injectionHighlighter.highlight(container, Collections.singletonList(container));
                        }
                    } else {
                        PsiElement at = this.myFile.findElementAt(this.myEditor.getCaretModel().getOffset());
                        PsiElement container = ((SuppressIntentionActionFromFix)action).getContainer(at);
                        if (container != null) {
                            highlighter.highlight(container, Collections.singletonList(container));
                        }
                    }
                }
            }
        });
        if (this.myEditor.isOneLineMode() && (ancestor = SwingUtilities.getAncestorOfClass(JComboBox.class, this.myEditor.getContentComponent())) != null) {
            JComboBox comboBox2 = (JComboBox)ancestor;
            this.myOuterComboboxPopupListener = new PopupMenuListenerAdapter(){

                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    IntentionHintComponent.this.hide();
                }
            };
            comboBox2.addPopupMenuListener(this.myOuterComboboxPopupListener);
        }
        Disposer.register((Disposable)this, (Disposable)this.myPopup);
        Disposer.register((Disposable)this.myPopup, () -> ((Application)ApplicationManager.getApplication()).assertIsDispatchThread());
    }

    void canceled(@NotNull ListPopupStep intentionListStep) {
        if (this.myPopup.getListStep() != intentionListStep || this.myDisposed) {
            return;
        }
        this.recreateMyPopup(intentionListStep);
    }

    private static class MyComponentHint
    extends LightweightHint {
        private boolean myVisible;
        private boolean myShouldDelay;

        private MyComponentHint(JComponent component) {
            super(component);
        }

        @Override
        public void show(@NotNull JComponent parentComponent, int x, int y, JComponent focusBackComponent, @NotNull HintHint hintHint) {
            this.myVisible = true;
            if (this.myShouldDelay) {
                myAlarm.cancelAllRequests();
                myAlarm.addRequest(() -> this.showImpl(parentComponent, x, y, focusBackComponent), 500);
            } else {
                this.showImpl(parentComponent, x, y, focusBackComponent);
            }
        }

        private void showImpl(JComponent parentComponent, int x, int y, JComponent focusBackComponent) {
            if (!parentComponent.isShowing()) {
                return;
            }
            super.show(parentComponent, x, y, focusBackComponent, new HintHint(parentComponent, new Point(x, y)));
        }

        @Override
        public void hide() {
            super.hide();
            this.myVisible = false;
            myAlarm.cancelAllRequests();
        }

        @Override
        public boolean isVisible() {
            return this.myVisible || super.isVisible();
        }

        private void setShouldDelay(boolean shouldDelay) {
            this.myShouldDelay = shouldDelay;
        }
    }

    public static enum PopupUpdateResult {
        NOTHING_CHANGED,
        CHANGED_INVISIBLE,
        HIDE_AND_RECREATE;

    }
}

