/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.intention.impl.QuickEditAction;
import com.intellij.injected.editor.InjectedFileChangesHandler;
import com.intellij.injected.editor.InjectedFileChangesHandlerProvider;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.ReadonlyFragmentModificationHandler;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorWithProviderComposite;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.impl.source.tree.injected.Place;
import com.intellij.psi.impl.source.tree.injected.changesHandler.CommonInjectedFileChangesHandler;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Point;
import java.util.Iterator;
import java.util.List;
import javax.swing.FocusManager;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class QuickEditHandler
implements Disposable,
DocumentListener {
    private final Project myProject;
    private final QuickEditAction myAction;
    private final Editor myEditor;
    private final Document myOrigDocument;
    private final Document myNewDocument;
    private final PsiFile myNewFile;
    private final LightVirtualFile myNewVirtualFile;
    private final long myOrigCreationStamp;
    private EditorWindow mySplittedWindow;
    private boolean myCommittingToOriginal;
    private final InjectedFileChangesHandler myEditChangesHandler;
    public static final Key<String> REPLACEMENT_KEY = Key.create((String)"REPLACEMENT_KEY");

    QuickEditHandler(Project project, @NotNull PsiFile injectedFile, PsiFile origFile, Editor editor, QuickEditAction action) {
        this.myProject = project;
        this.myEditor = editor;
        this.myAction = action;
        this.myOrigDocument = editor.getDocument();
        Place shreds = InjectedLanguageUtil.getShreds(injectedFile);
        FileType fileType = injectedFile.getFileType();
        Language language = injectedFile.getLanguage();
        PsiLanguageInjectionHost.Shred firstShred = (PsiLanguageInjectionHost.Shred)ContainerUtil.getFirstItem((List)((Object)shreds));
        PsiFileFactory factory = PsiFileFactory.getInstance((Project)project);
        String text = InjectedLanguageManager.getInstance((Project)project).getUnescapedText((PsiElement)injectedFile);
        String newFileName = StringUtil.notNullize((String)language.getDisplayName(), (String)"Injected") + " Fragment (" + origFile.getName() + ":" + firstShred.getHost().getTextRange().getStartOffset() + ")." + fileType.getDefaultExtension();
        this.myNewFile = factory.createFileFromText(newFileName, language, (CharSequence)text, true, false);
        this.myNewVirtualFile = (LightVirtualFile)ObjectUtils.assertNotNull((Object)((LightVirtualFile)this.myNewFile.getVirtualFile()));
        this.myNewVirtualFile.setOriginalFile(origFile.getVirtualFile());
        assert (this.myNewFile != null) : "PSI file is null";
        assert (this.myNewFile.getTextLength() == this.myNewVirtualFile.getContent().length()) : "PSI / Virtual file text mismatch";
        this.myNewVirtualFile.setOriginalFile(origFile.getVirtualFile());
        this.myNewFile.putUserData(InjectedLanguageUtil.FRANKENSTEIN_INJECTION, injectedFile.getUserData(InjectedLanguageUtil.FRANKENSTEIN_INJECTION));
        PsiLanguageInjectionHost host = InjectedLanguageManager.getInstance((Project)project).getInjectionHost(injectedFile.getViewProvider());
        this.myNewFile.putUserData(FileContextUtil.INJECTED_IN_ELEMENT, (Object)SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer((PsiElement)host));
        this.myNewDocument = PsiDocumentManager.getInstance((Project)project).getDocument(this.myNewFile);
        assert (this.myNewDocument != null);
        EditorActionManager.getInstance().setReadonlyFragmentModificationHandler(this.myNewDocument, (ReadonlyFragmentModificationHandler)new MyQuietHandler());
        this.myOrigCreationStamp = this.myOrigDocument.getModificationStamp();
        this.myOrigDocument.addDocumentListener((DocumentListener)this, (Disposable)this);
        this.myNewDocument.addDocumentListener((DocumentListener)this, (Disposable)this);
        EditorFactory editorFactory = (EditorFactory)ObjectUtils.assertNotNull((Object)EditorFactory.getInstance());
        editorFactory.addEditorFactoryListener(new EditorFactoryListener(){
            int useCount;

            public void editorCreated(@NotNull EditorFactoryEvent event) {
                if (event.getEditor().getDocument() != QuickEditHandler.this.myNewDocument) {
                    return;
                }
                ++this.useCount;
            }

            public void editorReleased(@NotNull EditorFactoryEvent event) {
                if (event.getEditor().getDocument() == QuickEditHandler.this.myOrigDocument) {
                    ApplicationManager.getApplication().invokeLater(() -> QuickEditHandler.this.closeEditor(), QuickEditHandler.this.myProject.getDisposed());
                    return;
                }
                if (event.getEditor().getDocument() != QuickEditHandler.this.myNewDocument) {
                    return;
                }
                if (--this.useCount > 0) {
                    return;
                }
                if (Boolean.TRUE.equals(QuickEditHandler.this.myNewVirtualFile.getUserData(FileEditorManagerImpl.CLOSING_TO_REOPEN))) {
                    return;
                }
                Disposer.dispose((Disposable)QuickEditHandler.this);
            }
        }, (Disposable)this);
        InjectedFileChangesHandlerProvider changesHandlerFactory = (InjectedFileChangesHandlerProvider)InjectedFileChangesHandlerProvider.EP.forLanguage(firstShred.getHost().getLanguage());
        this.myEditChangesHandler = changesHandlerFactory != null ? changesHandlerFactory.createFileChangesHandler((List)((Object)shreds), editor, this.myNewDocument, injectedFile) : new CommonInjectedFileChangesHandler((List<? extends PsiLanguageInjectionHost.Shred>)((Object)shreds), editor, this.myNewDocument, injectedFile);
        Disposer.register((Disposable)this, (Disposable)this.myEditChangesHandler);
        this.initGuardedBlocks(shreds);
    }

    public boolean isValid() {
        return this.myNewVirtualFile.isValid() && this.myEditChangesHandler.isValid();
    }

    public void navigate(int injectedOffset) {
        if (this.myAction.isShowInBalloon()) {
            JComponent component = this.myAction.createBalloonComponent(this.myNewFile);
            if (component != null) {
                QuickEditHandler.showBalloon(this.myEditor, this.myNewFile, component);
            }
        } else {
            Editor editor;
            FileEditorManagerEx fileEditorManager = FileEditorManagerEx.getInstanceEx(this.myProject);
            FileEditor[] editors = fileEditorManager.getEditors((VirtualFile)this.myNewVirtualFile);
            if (editors.length == 0) {
                EditorWindow curWindow = fileEditorManager.getCurrentWindow();
                this.mySplittedWindow = curWindow.split(0, false, (VirtualFile)this.myNewVirtualFile, true);
            }
            if ((editor = fileEditorManager.openTextEditor(new OpenFileDescriptor(this.myProject, (VirtualFile)this.myNewVirtualFile, injectedOffset), true)) instanceof EditorEx) {
                editor.putUserData(QuickEditAction.QUICK_EDIT_HANDLER, (Object)this);
                FoldingModelEx foldingModel = ((EditorEx)editor).getFoldingModel();
                foldingModel.runBatchFoldingOperation(() -> {
                    CharSequence sequence = this.myNewDocument.getImmutableCharSequence();
                    for (RangeMarker o : ContainerUtil.reverse(((DocumentEx)this.myNewDocument).getGuardedBlocks())) {
                        String replacement = (String)o.getUserData(REPLACEMENT_KEY);
                        if (StringUtil.isEmpty((String)replacement)) continue;
                        int start2 = o.getStartOffset();
                        int end = o.getEndOffset();
                        if ((start2 += StringUtil.countChars((CharSequence)sequence, (char)'\n', (int)start2, (int)end, (boolean)true)) > (end -= StringUtil.countChars((CharSequence)sequence, (char)'\n', (int)end, (int)start2, (boolean)true))) continue;
                        FoldRegion region = foldingModel.getFoldRegion(start2, end);
                        if (region == null) {
                            region = foldingModel.createFoldRegion(start2, end, replacement, null, true);
                        }
                        if (region == null) continue;
                        region.setExpanded(false);
                    }
                });
            }
        }
        ApplicationManager.getApplication().invokeLater(() -> this.myEditor.getScrollingModel().scrollToCaret(ScrollType.CENTER), ModalityState.any());
    }

    public static void showBalloon(Editor editor, PsiFile newFile, JComponent component) {
        Balloon balloon = JBPopupFactory.getInstance().createBalloonBuilder(component).setShadow(true).setAnimationCycle(0).setHideOnClickOutside(true).setHideOnKeyOutside(true).setHideOnAction(false).setFillColor(UIUtil.getControlColor()).createBalloon();
        DumbAwareAction.create(e -> balloon.hide()).registerCustomShortcutSet(CommonShortcuts.ESCAPE, component);
        Disposer.register((Disposable)newFile.getProject(), (Disposable)balloon);
        Balloon.Position position = QuickEditAction.getBalloonPosition(editor);
        RelativePoint point = JBPopupFactory.getInstance().guessBestPopupLocation(editor);
        if (position == Balloon.Position.above) {
            Point p = point.getPoint();
            point = new RelativePoint(point.getComponent(), new Point(p.x, p.y - editor.getLineHeight()));
        }
        balloon.show(point, position);
    }

    public void documentChanged(@NotNull DocumentEvent e) {
        boolean undoOrRedo;
        UndoManager undoManager = UndoManager.getInstance((Project)this.myProject);
        boolean bl = undoOrRedo = undoManager.isUndoInProgress() || undoManager.isRedoInProgress();
        if (undoOrRedo) {
            if (e.getDocument() == this.myOrigDocument) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (this.myOrigCreationStamp > this.myOrigDocument.getModificationStamp()) {
                        this.closeEditor();
                    }
                }, this.myProject.getDisposed());
            }
        } else if (e.getDocument() == this.myNewDocument) {
            this.commitToOriginal(e);
            if (!this.isValid()) {
                ApplicationManager.getApplication().invokeLater(() -> this.closeEditor(), this.myProject.getDisposed());
            }
        } else if (e.getDocument() == this.myOrigDocument) {
            if (this.myCommittingToOriginal) {
                return;
            }
            if (!this.myEditChangesHandler.handlesRange(TextRange.from((int)e.getOffset(), (int)e.getOldLength()))) {
                return;
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                Component owner = FocusManager.getCurrentManager().getFocusOwner();
                this.closeEditor();
                if (owner != null) {
                    owner.requestFocus();
                }
            }, this.myProject.getDisposed());
        }
    }

    private void closeEditor() {
        EditorWithProviderComposite[] editors;
        boolean unsplit = false;
        if (this.mySplittedWindow != null && !this.mySplittedWindow.isDisposed() && (editors = this.mySplittedWindow.getEditors()).length == 1 && Comparing.equal((Object)editors[0].getFile(), (Object)this.myNewVirtualFile)) {
            unsplit = true;
        }
        if (unsplit) {
            ((FileEditorManagerImpl)FileEditorManager.getInstance((Project)this.myProject)).closeFile((VirtualFile)this.myNewVirtualFile, this.mySplittedWindow, false);
        }
        FileEditorManager.getInstance((Project)this.myProject).closeFile((VirtualFile)this.myNewVirtualFile);
    }

    private void initGuardedBlocks(Place shreds) {
        int origOffset = -1;
        int curOffset = 0;
        Iterator iterator = shreds.iterator();
        while (iterator.hasNext()) {
            PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)iterator.next();
            Segment hostRangeMarker = shred.getHostRangeMarker();
            int start2 = shred.getRange().getStartOffset() + shred.getPrefix().length();
            int end = shred.getRange().getEndOffset() - shred.getSuffix().length();
            if (curOffset < start2) {
                RangeMarker guard = this.myNewDocument.createGuardedBlock(curOffset, start2);
                if (curOffset == 0 && shred == shreds.get(0)) {
                    guard.setGreedyToLeft(true);
                }
                String padding = origOffset < 0 ? "" : this.myOrigDocument.getText().substring(origOffset, hostRangeMarker.getStartOffset());
                guard.putUserData(REPLACEMENT_KEY, (Object)QuickEditHandler.fixQuotes(padding));
            }
            curOffset = end;
            origOffset = hostRangeMarker.getEndOffset();
        }
        if (curOffset < this.myNewDocument.getTextLength()) {
            RangeMarker guard = this.myNewDocument.createGuardedBlock(curOffset, this.myNewDocument.getTextLength());
            guard.setGreedyToRight(true);
            guard.putUserData(REPLACEMENT_KEY, (Object)"");
        }
    }

    private void commitToOriginal(DocumentEvent e) {
        this.myCommittingToOriginal = true;
        try {
            PostprocessReformattingAspect.getInstance(this.myProject).disablePostprocessFormattingInside(() -> this.myEditChangesHandler.commitToOriginal(e));
            PsiDocumentManager.getInstance((Project)this.myProject).doPostponedOperationsAndUnblockDocument(this.myOrigDocument);
        }
        finally {
            this.myCommittingToOriginal = false;
        }
    }

    private static String fixQuotes(String padding) {
        if (padding.isEmpty()) {
            return padding;
        }
        if (padding.startsWith("'")) {
            padding = '\"' + padding.substring(1);
        }
        if (padding.endsWith("'")) {
            padding = padding.substring(0, padding.length() - 1) + "\"";
        }
        return padding;
    }

    public void dispose() {
    }

    public PsiFile getNewFile() {
        return this.myNewFile;
    }

    public boolean tryReuse(@NotNull PsiFile injectedFile, @NotNull TextRange hostRange) {
        return this.myEditChangesHandler.tryReuse(injectedFile, hostRange);
    }

    private static class MyQuietHandler
    implements ReadonlyFragmentModificationHandler {
        private MyQuietHandler() {
        }

        public void handle(ReadOnlyFragmentModificationException e) {
        }
    }
}

