/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.IntentionsUI;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionDelegate;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.codeInsight.intention.impl.CachedIntentions;
import com.intellij.codeInsight.intention.impl.IntentionHintComponent;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.codeInspection.SuppressIntentionActionFromFix;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.featureStatistics.FeatureUsageTrackerImpl;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.internal.statistic.collectors.fus.actions.persistence.IntentionsCollector;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.stubs.StubTextInconsistencyException;
import com.intellij.util.PairProcessor;
import com.intellij.util.ThreeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowIntentionActionsHandler
implements CodeInsightActionHandler {
    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        LookupEx lookup;
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        if (editor instanceof EditorWindow) {
            editor = ((EditorWindow)editor).getDelegate();
            file2 = InjectedLanguageManager.getInstance((Project)file2.getProject()).getTopLevelFile((PsiElement)file2);
        }
        if ((lookup = LookupManager.getActiveLookup(editor)) != null) {
            lookup.showElementActions();
            return;
        }
        DaemonCodeAnalyzerImpl codeAnalyzer = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance((Project)project);
        ShowIntentionActionsHandler.letAutoImportComplete(editor, file2, codeAnalyzer);
        ShowIntentionsPass.IntentionsInfo intentions = ShowIntentionsPass.getActionsToShow(editor, file2);
        IntentionsUI.getInstance(project).hide();
        if (HintManagerImpl.getInstanceImpl().performCurrentQuestionAction()) {
            return;
        }
        TemplateState state = TemplateManagerImpl.getTemplateState(editor);
        if (state != null && !state.isFinished()) {
            return;
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        Editor finalEditor = editor;
        PsiFile finalFile = file2;
        editor.getScrollingModel().runActionOnScrollingFinished(() -> this.showIntentionHint(project, finalEditor, finalFile, intentions));
    }

    protected void showIntentionHint(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2, @NotNull ShowIntentionsPass.IntentionsInfo intentions) {
        if (!intentions.isEmpty()) {
            CachedIntentions cachedIntentions = CachedIntentions.createAndUpdateActions(project, file2, editor, intentions);
            IntentionHintComponent.showIntentionHint(project, file2, editor, true, cachedIntentions);
        }
    }

    private static void letAutoImportComplete(@NotNull Editor editor, @NotNull PsiFile file2, DaemonCodeAnalyzerImpl codeAnalyzer) {
        CommandProcessor.getInstance().runUndoTransparentAction(() -> codeAnalyzer.autoImportReferenceAtCursor(editor, file2));
    }

    public boolean startInWriteAction() {
        return false;
    }

    public static boolean availableFor(@NotNull PsiFile psiFile, @NotNull Editor editor, @NotNull IntentionAction action) {
        if (!psiFile.isValid()) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement psiElement = psiFile.findElementAt(offset);
        try {
            Project project = psiFile.getProject();
            if (action instanceof IntentionActionDelegate) {
                action = ((IntentionActionDelegate)action).getDelegate();
            }
            if (action instanceof IntentionActionDelegate) {
                action = ((IntentionActionDelegate)action).getDelegate();
            }
            if (action instanceof SuppressIntentionActionFromFix) {
                ThreeState shouldBeAppliedToInjectionHost = ((SuppressIntentionActionFromFix)action).isShouldBeAppliedToInjectionHost();
                if (editor instanceof EditorWindow && shouldBeAppliedToInjectionHost == ThreeState.YES) {
                    return false;
                }
                if (!(editor instanceof EditorWindow) && shouldBeAppliedToInjectionHost == ThreeState.NO) {
                    return false;
                }
            }
            if (action instanceof PsiElementBaseIntentionAction) {
                PsiElementBaseIntentionAction psiAction = (PsiElementBaseIntentionAction)action;
                if (psiElement == null || !psiAction.checkFile(psiFile) || !psiAction.isAvailable(project, editor, psiElement)) {
                    return false;
                }
            } else if (!action.isAvailable(project, editor, psiFile)) {
                return false;
            }
        }
        catch (IndexNotReadyException e) {
            return false;
        }
        return true;
    }

    @Nullable
    public static Pair<PsiFile, Editor> chooseBetweenHostAndInjected(@NotNull PsiFile hostFile, @NotNull Editor hostEditor, @NotNull PairProcessor<? super PsiFile, ? super Editor> predicate) {
        Editor injectedEditor;
        Editor editorToApply = null;
        PsiFile fileToApply = null;
        int offset = hostEditor.getCaretModel().getOffset();
        PsiFile injectedFile = InjectedLanguageUtil.findInjectedPsiNoCommit(hostFile, offset);
        if (injectedFile != null && predicate.process((Object)injectedFile, (Object)(injectedEditor = InjectedLanguageUtil.getInjectedEditorForInjectedFile(hostEditor, injectedFile)))) {
            editorToApply = injectedEditor;
            fileToApply = injectedFile;
        }
        if (editorToApply == null && predicate.process((Object)hostFile, (Object)hostEditor)) {
            editorToApply = hostEditor;
            fileToApply = hostFile;
        }
        if (editorToApply == null) {
            return null;
        }
        return Pair.create(fileToApply, editorToApply);
    }

    public static boolean chooseActionAndInvoke(@NotNull PsiFile hostFile, @NotNull Editor hostEditor, @NotNull IntentionAction action, @NotNull String text) {
        Project project = hostFile.getProject();
        return ShowIntentionActionsHandler.chooseActionAndInvoke(hostFile, hostEditor, action, text, project);
    }

    static boolean chooseActionAndInvoke(@NotNull PsiFile hostFile, @Nullable Editor hostEditor, @NotNull IntentionAction action, @NotNull String text, @NotNull Project project) {
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.quickFix");
        ((FeatureUsageTrackerImpl)FeatureUsageTracker.getInstance()).getFixesStats().registerInvocation();
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        Pair<PsiFile, Editor> pair = ShowIntentionActionsHandler.chooseFileForAction(hostFile, hostEditor, action);
        if (pair == null) {
            return false;
        }
        CommandProcessor.getInstance().executeCommand(project, () -> TransactionGuard.getInstance().submitTransactionAndWait(() -> ShowIntentionActionsHandler.invokeIntention(action, (Editor)pair.second, (PsiFile)pair.first)), text, null);
        ShowIntentionActionsHandler.checkPsiTextConsistency(hostFile);
        return true;
    }

    private static void checkPsiTextConsistency(@NotNull PsiFile hostFile) {
        if ((Registry.is((String)"ide.check.stub.text.consistency") || ApplicationManager.getApplication().isUnitTestMode() && !ApplicationInfoImpl.isInStressTest()) && hostFile.isValid()) {
            StubTextInconsistencyException.checkStubTextConsistency(hostFile);
        }
    }

    private static void invokeIntention(@NotNull IntentionAction action, @Nullable Editor editor, @NotNull PsiFile file2) {
        IntentionsCollector.getInstance().record(file2.getProject(), action, file2.getLanguage());
        PsiElement elementToMakeWritable = action.getElementToMakeWritable(file2);
        if (elementToMakeWritable != null && !FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{elementToMakeWritable})) {
            return;
        }
        Runnable r = () -> action.invoke(file2.getProject(), editor, file2);
        if (action.startInWriteAction()) {
            WriteAction.run(r::run);
        } else {
            r.run();
        }
    }

    @Nullable
    public static Pair<PsiFile, Editor> chooseFileForAction(@NotNull PsiFile hostFile, @Nullable Editor hostEditor, @NotNull IntentionAction action) {
        return hostEditor == null ? Pair.create((Object)hostFile, null) : ShowIntentionActionsHandler.chooseBetweenHostAndInjected(hostFile, hostEditor, (PairProcessor<? super PsiFile, ? super Editor>)((PairProcessor)(psiFile, editor) -> ShowIntentionActionsHandler.availableFor(psiFile, editor, action)));
    }
}

