/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl.config;

import com.intellij.codeInsight.intention.impl.config.BeforeAfterMetaData;
import com.intellij.codeInsight.intention.impl.config.PlainTextDescriptor;
import com.intellij.codeInsight.intention.impl.config.ResourceTextDescriptor;
import com.intellij.codeInsight.intention.impl.config.TextDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.ExactFileNameMatcher;
import com.intellij.openapi.fileTypes.ExtensionFileNameMatcher;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BeforeAfterActionMetaData
implements BeforeAfterMetaData {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.intention.impl.config.BeforeAfterActionMetaData");
    protected static final TextDescriptor[] EMPTY_EXAMPLE = new TextDescriptor[0];
    protected static final TextDescriptor EMPTY_DESCRIPTION = new PlainTextDescriptor("", "");
    @NonNls
    protected static final String DESCRIPTION_FILE_NAME = "description.html";
    @NonNls
    static final String EXAMPLE_USAGE_URL_SUFFIX = ".template";
    @NonNls
    private static final String BEFORE_TEMPLATE_PREFIX = "before";
    @NonNls
    private static final String AFTER_TEMPLATE_PREFIX = "after";
    protected final ClassLoader myLoader;
    protected final String myDescriptionDirectoryName;
    private TextDescriptor[] myExampleUsagesBefore;
    private TextDescriptor[] myExampleUsagesAfter;
    protected TextDescriptor myDescription;

    public BeforeAfterActionMetaData(@Nullable ClassLoader loader, @NotNull String descriptionDirectoryName) {
        this.myLoader = loader;
        this.myDescriptionDirectoryName = descriptionDirectoryName;
    }

    public BeforeAfterActionMetaData(@NotNull TextDescriptor description, @NotNull TextDescriptor[] exampleUsagesBefore, @NotNull TextDescriptor[] exampleUsagesAfter) {
        this.myLoader = null;
        this.myDescriptionDirectoryName = null;
        this.myExampleUsagesBefore = exampleUsagesBefore;
        this.myExampleUsagesAfter = exampleUsagesAfter;
        this.myDescription = description;
    }

    @NotNull
    private static TextDescriptor[] retrieveURLs(@NotNull URL descriptionDirectory, @NotNull String prefix, @NotNull String suffix) throws MalformedURLException {
        FileType[] fileTypes;
        ArrayList<TextDescriptor> urls = new ArrayList<TextDescriptor>();
        block2: for (FileType fileType : fileTypes = FileTypeManager.getInstance().getRegisteredFileTypes()) {
            List matchers = FileTypeManager.getInstance().getAssociations(fileType);
            for (FileNameMatcher matcher : matchers) {
                URL url;
                if (matcher instanceof ExactFileNameMatcher) {
                    ExactFileNameMatcher exactFileNameMatcher = (ExactFileNameMatcher)matcher;
                    String fileName2 = StringUtil.trimStart((String)exactFileNameMatcher.getFileName(), (String)".");
                    URL url2 = new URL(descriptionDirectory.toExternalForm() + "/" + prefix + "." + fileName2 + suffix);
                    if (!BeforeAfterActionMetaData.checkUrl(url2, urls)) continue;
                    continue block2;
                }
                if (!(matcher instanceof ExtensionFileNameMatcher)) continue;
                ExtensionFileNameMatcher extensionFileNameMatcher = (ExtensionFileNameMatcher)matcher;
                String extension = extensionFileNameMatcher.getExtension();
                int i = 0;
                while (BeforeAfterActionMetaData.checkUrl(url = new URL(descriptionDirectory.toExternalForm() + "/" + prefix + "." + extension + (i == 0 ? "" : Integer.toString(i)) + suffix), urls)) {
                    ++i;
                }
            }
        }
        if (urls.isEmpty()) {
            String[] children2;
            Exception cause = null;
            try {
                URI uri = descriptionDirectory.toURI();
                children2 = uri.isOpaque() ? null : (String[])ObjectUtils.notNull((Object)new File(uri).list(), (Object)ArrayUtil.EMPTY_STRING_ARRAY);
            }
            catch (IllegalArgumentException | URISyntaxException e) {
                cause = e;
                children2 = null;
            }
            LOG.error("URLs not found for available file types and prefix: '" + prefix + "', suffix: '" + suffix + "'; in directory: '" + descriptionDirectory + "'" + (children2 == null ? "" : "; directory contents: " + Arrays.asList(children2)), (Throwable)cause);
            return EMPTY_EXAMPLE;
        }
        return urls.toArray(new TextDescriptor[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean checkUrl(URL url, List<TextDescriptor> urls) {
        try (InputStream ignored = url.openStream();){
            urls.add(new ResourceTextDescriptor(url));
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    @NotNull
    public TextDescriptor[] getExampleUsagesBefore() {
        if (this.myExampleUsagesBefore == null) {
            try {
                this.myExampleUsagesBefore = BeforeAfterActionMetaData.retrieveURLs(this.getDirURL(), BEFORE_TEMPLATE_PREFIX, EXAMPLE_USAGE_URL_SUFFIX);
            }
            catch (MalformedURLException e) {
                LOG.error((Throwable)e);
                return EMPTY_EXAMPLE;
            }
        }
        return this.myExampleUsagesBefore;
    }

    @Override
    @NotNull
    public TextDescriptor[] getExampleUsagesAfter() {
        if (this.myExampleUsagesAfter == null) {
            try {
                this.myExampleUsagesAfter = BeforeAfterActionMetaData.retrieveURLs(this.getDirURL(), AFTER_TEMPLATE_PREFIX, EXAMPLE_USAGE_URL_SUFFIX);
            }
            catch (MalformedURLException e) {
                LOG.error((Throwable)e);
                return EMPTY_EXAMPLE;
            }
        }
        return this.myExampleUsagesAfter;
    }

    @Override
    @NotNull
    public TextDescriptor getDescription() {
        if (this.myDescription == null) {
            try {
                URL dirURL = this.getDirURL();
                URL descriptionURL = new URL(dirURL.toExternalForm() + "/" + DESCRIPTION_FILE_NAME);
                this.myDescription = new ResourceTextDescriptor(descriptionURL);
            }
            catch (MalformedURLException e) {
                LOG.error((Throwable)e);
                return EMPTY_DESCRIPTION;
            }
        }
        return this.myDescription;
    }

    @NotNull
    protected abstract URL getDirURL();
}

