/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl.config;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionBean;
import com.intellij.codeInsight.intention.IntentionActionDelegate;
import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.actionSystem.ShortcutProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntentionActionWrapper
implements IntentionAction,
ShortcutProvider,
IntentionActionDelegate {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.intention.impl.config.IntentionActionWrapper");
    private IntentionAction myDelegate;
    private final String[] myCategories;
    private final IntentionActionBean myExtension;
    private String myFullFamilyName;

    IntentionActionWrapper(@NotNull IntentionActionBean extension, String[] categories) {
        this.myExtension = extension;
        this.myCategories = categories;
    }

    @NotNull
    String getDescriptionDirectoryName() {
        return IntentionActionWrapper.getDescriptionDirectoryName(this.getImplementationClassName());
    }

    @NotNull
    static String getDescriptionDirectoryName(@NotNull String fqn) {
        return fqn.substring(fqn.lastIndexOf(46) + 1).replaceAll("\\$", "");
    }

    @NotNull
    public String getText() {
        return this.getDelegate().getText();
    }

    @NotNull
    public String getFamilyName() {
        return this.getDelegate().getFamilyName();
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        return this.getDelegate().isAvailable(project, editor, file2);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        this.getDelegate().invoke(project, editor, file2);
    }

    public boolean startInWriteAction() {
        return this.getDelegate().startInWriteAction();
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file2) {
        return this.getDelegate().getElementToMakeWritable(file2);
    }

    @NotNull
    public String getFullFamilyName() {
        String result2 = this.myFullFamilyName;
        if (result2 == null) {
            result2 = this.myCategories != null ? StringUtil.join((String[])this.myCategories, (String)"/") + "/" + this.getFamilyName() : this.getFamilyName();
            this.myFullFamilyName = result2;
        }
        return result2;
    }

    @NotNull
    public synchronized IntentionAction getDelegate() {
        if (this.myDelegate == null) {
            try {
                this.myDelegate = this.myExtension.instantiate();
            }
            catch (PluginException e) {
                LOG.error((Throwable)e);
            }
        }
        return this.myDelegate;
    }

    public String getImplementationClassName() {
        return this.myExtension.className;
    }

    @NotNull
    ClassLoader getImplementationClassLoader() {
        return this.myExtension.getLoaderForClass();
    }

    public String toString() {
        String text;
        try {
            text = this.getText();
        }
        catch (PsiInvalidElementAccessException e) {
            text = e.getMessage();
        }
        return "Intention: (" + this.getDelegate().getClass() + "): '" + text + "'";
    }

    public boolean equals(Object obj) {
        return super.equals(obj) || this.getDelegate().equals(obj);
    }

    @Nullable
    public ShortcutSet getShortcut() {
        IntentionAction delegate = this.getDelegate();
        return delegate instanceof ShortcutProvider ? ((ShortcutProvider)delegate).getShortcut() : null;
    }
}

