/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl.config;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.CleanupOnScopeIntention;
import com.intellij.codeInsight.daemon.impl.EditCleanupProfileIntentionAction;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionBean;
import com.intellij.codeInsight.intention.IntentionActionDelegate;
import com.intellij.codeInsight.intention.IntentionManager;
import com.intellij.codeInsight.intention.impl.config.IntentionActionWrapper;
import com.intellij.codeInsight.intention.impl.config.IntentionManagerSettings;
import com.intellij.codeInsight.intention.impl.config.LazyEditor;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.GlobalSimpleInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.actions.CleanupAllIntention;
import com.intellij.codeInspection.actions.CleanupInspectionIntention;
import com.intellij.codeInspection.actions.RunInspectionIntention;
import com.intellij.codeInspection.ex.DisableInspectionToolAction;
import com.intellij.codeInspection.ex.EditInspectionToolsSettingsAction;
import com.intellij.codeInspection.ex.EditInspectionToolsSettingsInSuppressedPlaceIntention;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IntentionManagerImpl
extends IntentionManager {
    private static final Logger LOG = Logger.getInstance(IntentionManagerImpl.class);
    private final List<IntentionAction> myActions;
    private final IntentionManagerSettings mySettings;
    private final AtomicReference<ScheduledFuture<?>> myScheduledFuture = new AtomicReference();
    private boolean myIntentionsDisabled;
    private boolean checkedForDuplicates;

    public IntentionManagerImpl(IntentionManagerSettings intentionManagerSettings) {
        this.mySettings = intentionManagerSettings;
        ArrayList<Object> actions = new ArrayList<Object>();
        actions.add(new EditInspectionToolsSettingsInSuppressedPlaceIntention());
        for (IntentionActionBean extension : IntentionManager.EP_INTENTION_ACTIONS.getExtensionList()) {
            actions.add(new IntentionActionWrapper(extension, extension.getCategories()));
        }
        this.myActions = ContainerUtil.createLockFreeCopyOnWriteList(actions);
    }

    public void registerIntentionAndMetaData(@NotNull IntentionAction action, String ... category) {
        this.addAction(action);
        String descriptionDirectoryName = action instanceof IntentionActionWrapper ? ((IntentionActionWrapper)action).getDescriptionDirectoryName() : IntentionActionWrapper.getDescriptionDirectoryName(action.getClass().getName());
        this.mySettings.registerIntentionMetaData(action, category, descriptionDirectoryName);
    }

    public void unregisterIntention(@NotNull IntentionAction intentionAction) {
        this.myActions.remove(intentionAction);
        this.mySettings.unregisterMetaData(intentionAction);
    }

    @NotNull
    public List<IntentionAction> getStandardIntentionOptions(@NotNull HighlightDisplayKey displayKey, @NotNull PsiElement context) {
        this.checkForDuplicates();
        ArrayList<IntentionAction> options = new ArrayList<IntentionAction>(9);
        options.add(new EditInspectionToolsSettingsAction(displayKey));
        options.add(new RunInspectionIntention(displayKey));
        options.add((IntentionAction)new DisableInspectionToolAction(displayKey));
        return options;
    }

    @Nullable
    public IntentionAction createFixAllIntention(@NotNull InspectionToolWrapper toolWrapper, @NotNull IntentionAction action) {
        LocalInspectionToolWrapper localWrapper;
        this.checkForDuplicates();
        if (toolWrapper instanceof GlobalInspectionToolWrapper && (localWrapper = ((GlobalInspectionToolWrapper)toolWrapper).getSharedLocalInspectionToolWrapper()) != null) {
            return this.createFixAllIntention(localWrapper, action);
        }
        if (toolWrapper instanceof LocalInspectionToolWrapper) {
            return IntentionManagerImpl.createFixAllIntentionInternal(toolWrapper, action);
        }
        if (toolWrapper instanceof GlobalInspectionToolWrapper) {
            GlobalInspectionTool wrappedTool = (GlobalInspectionTool)((GlobalInspectionToolWrapper)toolWrapper).getTool();
            if (wrappedTool instanceof GlobalSimpleInspectionTool && (action instanceof LocalQuickFix || action instanceof QuickFixWrapper)) {
                return IntentionManagerImpl.createFixAllIntentionInternal(toolWrapper, action);
            }
        } else {
            throw new AssertionError((Object)("unknown tool: " + toolWrapper));
        }
        return null;
    }

    private static IntentionAction createFixAllIntentionInternal(@NotNull InspectionToolWrapper toolWrapper, @NotNull IntentionAction action) {
        PsiFile file2 = null;
        IntentionAction fix = action;
        if (action instanceof QuickFixWrapper) {
            fix = ((QuickFixWrapper)action).getFix();
            file2 = ((QuickFixWrapper)action).getFile();
        }
        return new CleanupInspectionIntention(toolWrapper, (FileModifier)fix, file2, action.getText());
    }

    @NotNull
    public IntentionAction createCleanupAllIntention() {
        return CleanupAllIntention.INSTANCE;
    }

    @NotNull
    public List<IntentionAction> getCleanupIntentionOptions() {
        ArrayList<IntentionAction> options = new ArrayList<IntentionAction>();
        options.add(EditCleanupProfileIntentionAction.INSTANCE);
        options.add(CleanupOnScopeIntention.INSTANCE);
        return options;
    }

    @NotNull
    public LocalQuickFix convertToFix(final @NotNull IntentionAction action) {
        if (action instanceof LocalQuickFix) {
            return (LocalQuickFix)action;
        }
        return new LocalQuickFix(){

            @NotNull
            public String getName() {
                return action.getText();
            }

            @NotNull
            public String getFamilyName() {
                return action.getFamilyName();
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                PsiFile psiFile = descriptor.getPsiElement().getContainingFile();
                try {
                    action.invoke(project, (Editor)new LazyEditor(psiFile), psiFile);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
        };
    }

    public void addAction(@NotNull IntentionAction action) {
        this.myActions.add(action);
    }

    @NotNull
    public IntentionAction[] getIntentionActions() {
        if (this.myIntentionsDisabled) {
            return IntentionAction.EMPTY_ARRAY;
        }
        return this.myActions.toArray(IntentionAction.EMPTY_ARRAY);
    }

    @NotNull
    public IntentionAction[] getAvailableIntentionActions() {
        if (this.myIntentionsDisabled) {
            return IntentionAction.EMPTY_ARRAY;
        }
        this.checkForDuplicates();
        ArrayList<IntentionAction> list2 = new ArrayList<IntentionAction>(this.myActions.size());
        for (IntentionAction action : this.myActions) {
            if (!this.mySettings.isEnabled(action)) continue;
            list2.add(action);
        }
        return list2.toArray(IntentionAction.EMPTY_ARRAY);
    }

    public void checkForDuplicates() {
        if (this.checkedForDuplicates) {
            return;
        }
        this.checkedForDuplicates = true;
        List duplicates = this.myActions.stream().collect(Collectors.groupingBy(action -> IntentionManagerImpl.unwrap(action).getClass())).values().stream().filter(list2 -> list2.size() > 1).map(dup -> dup.size() + " intention duplicates found for " + IntentionManagerImpl.unwrap((IntentionAction)dup.get(0))).collect(Collectors.toList());
        if (!duplicates.isEmpty()) {
            throw new IllegalStateException(duplicates.toString());
        }
    }

    private static IntentionAction unwrap(IntentionAction action) {
        return action instanceof IntentionActionDelegate ? IntentionManagerImpl.unwrap(((IntentionActionDelegate)action).getDelegate()) : action;
    }

    public boolean hasActiveRequests() {
        return this.myScheduledFuture.get() != null;
    }

    public <T extends Throwable> void withDisabledIntentions(ThrowableRunnable<T> runnable2) throws T {
        boolean oldIntentionsDisabled = this.myIntentionsDisabled;
        this.myIntentionsDisabled = true;
        try {
            runnable2.run();
        }
        finally {
            this.myIntentionsDisabled = oldIntentionsDisabled;
        }
    }
}

