/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl.config;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionBean;
import com.intellij.codeInsight.intention.IntentionManager;
import com.intellij.codeInsight.intention.impl.config.IntentionActionMetaData;
import com.intellij.codeInsight.intention.impl.config.IntentionActionWrapper;
import com.intellij.codeInsight.intention.impl.config.IntentionSettingsConfigurable;
import com.intellij.codeInsight.intention.impl.config.TextDescriptor;
import com.intellij.ide.ui.search.SearchableOptionsRegistrar;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.containers.StringInterner;
import com.intellij.util.containers.WeakStringInterner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.regex.Pattern;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@State(name="IntentionManagerSettings", storages={@Storage(value="intentionSettings.xml")})
public final class IntentionManagerSettings
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance(IntentionManagerSettings.class);
    private final Set<String> myIgnoredActions = Collections.synchronizedSet(new LinkedHashSet());
    private final Map<MetaDataKey, IntentionActionMetaData> myMetaData = new LinkedHashMap<MetaDataKey, IntentionActionMetaData>();
    @NonNls
    private static final String IGNORE_ACTION_TAG = "ignoreAction";
    @NonNls
    private static final String NAME_ATT = "name";
    private static final Pattern HTML_PATTERN = Pattern.compile("<[^<>]*>");
    private static final ExecutorService ourExecutor = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"Intentions Loader");

    public IntentionManagerSettings() {
        for (IntentionActionBean extension : IntentionManager.EP_INTENTION_ACTIONS.getExtensionList()) {
            String[] categories = extension.getCategories();
            if (categories == null) continue;
            IntentionActionWrapper instance = new IntentionActionWrapper(extension, categories);
            String descriptionDirectoryName = extension.getDescriptionDirectoryName();
            if (descriptionDirectoryName == null) {
                descriptionDirectoryName = instance.getDescriptionDirectoryName();
            }
            try {
                this.registerMetaData(new IntentionActionMetaData(instance, extension.getMetadataClassLoader(), categories, descriptionDirectoryName));
            }
            catch (ExtensionNotApplicableException extensionNotApplicableException) {}
        }
    }

    @NotNull
    public static IntentionManagerSettings getInstance() {
        return (IntentionManagerSettings)ServiceManager.getService(IntentionManagerSettings.class);
    }

    void registerIntentionMetaData(@NotNull IntentionAction intentionAction, @NotNull String[] category, @NotNull String descriptionDirectoryName) {
        this.registerMetaData(new IntentionActionMetaData(intentionAction, IntentionManagerSettings.getClassLoader(intentionAction), category, descriptionDirectoryName));
    }

    private static ClassLoader getClassLoader(@NotNull IntentionAction intentionAction) {
        return intentionAction instanceof IntentionActionWrapper ? ((IntentionActionWrapper)intentionAction).getImplementationClassLoader() : intentionAction.getClass().getClassLoader();
    }

    public boolean isShowLightBulb(@NotNull IntentionAction action) {
        return !this.myIgnoredActions.contains(action.getFamilyName());
    }

    public void loadState(@NotNull Element element) {
        this.myIgnoredActions.clear();
        for (Element e : element.getChildren(IGNORE_ACTION_TAG)) {
            this.myIgnoredActions.add(e.getAttributeValue(NAME_ATT));
        }
    }

    public Element getState() {
        Element element = new Element("state");
        for (String name : this.myIgnoredActions) {
            element.addContent(new Element(IGNORE_ACTION_TAG).setAttribute(NAME_ATT, name));
        }
        return element;
    }

    @NotNull
    public synchronized List<IntentionActionMetaData> getMetaData() {
        return new ArrayList<IntentionActionMetaData>(this.myMetaData.values());
    }

    public boolean isEnabled(@NotNull IntentionActionMetaData metaData) {
        return !this.myIgnoredActions.contains(IntentionManagerSettings.getFamilyName(metaData));
    }

    private static String getFamilyName(@NotNull IntentionActionMetaData metaData) {
        return StringUtil.join((String[])metaData.myCategory, (String)"/") + "/" + metaData.getFamily();
    }

    private static String getFamilyName(@NotNull IntentionAction action) {
        return action instanceof IntentionActionWrapper ? ((IntentionActionWrapper)action).getFullFamilyName() : action.getFamilyName();
    }

    public void setEnabled(@NotNull IntentionActionMetaData metaData, boolean enabled) {
        if (enabled) {
            this.myIgnoredActions.remove(IntentionManagerSettings.getFamilyName(metaData));
        } else {
            this.myIgnoredActions.add(IntentionManagerSettings.getFamilyName(metaData));
        }
    }

    public boolean isEnabled(@NotNull IntentionAction action) {
        return !this.myIgnoredActions.contains(IntentionManagerSettings.getFamilyName(action));
    }

    public void setEnabled(@NotNull IntentionAction action, boolean enabled) {
        if (enabled) {
            this.myIgnoredActions.remove(IntentionManagerSettings.getFamilyName(action));
        } else {
            this.myIgnoredActions.add(IntentionManagerSettings.getFamilyName(action));
        }
    }

    private synchronized void registerMetaData(@NotNull IntentionActionMetaData metaData) {
        MetaDataKey key = new MetaDataKey(metaData.myCategory, metaData.getFamily());
        if (!this.myMetaData.containsKey((Object)key)) {
            IntentionManagerSettings.processMetaData(metaData);
        }
        this.myMetaData.put(key, metaData);
    }

    private static void processMetaData(@NotNull IntentionActionMetaData metaData) {
        Application app = ApplicationManager.getApplication();
        if (app.isUnitTestMode() || app.isHeadlessEnvironment()) {
            return;
        }
        TextDescriptor description = metaData.getDescription();
        ourExecutor.execute(() -> {
            try {
                SearchableOptionsRegistrar registrar = SearchableOptionsRegistrar.getInstance();
                if (registrar == null) {
                    return;
                }
                String descriptionText = description.getText().toLowerCase();
                descriptionText = HTML_PATTERN.matcher(descriptionText).replaceAll(" ");
                Set words = registrar.getProcessedWordsWithoutStemming(descriptionText);
                words.addAll(registrar.getProcessedWords(metaData.getFamily()));
                for (String word : words) {
                    registrar.addOption(word, metaData.getFamily(), metaData.getFamily(), "preferences.intentionPowerPack", IntentionSettingsConfigurable.DISPLAY_NAME);
                }
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        });
    }

    synchronized void unregisterMetaData(@NotNull IntentionAction intentionAction) {
        for (Map.Entry<MetaDataKey, IntentionActionMetaData> entry : this.myMetaData.entrySet()) {
            if (entry.getValue().getAction() != intentionAction) continue;
            this.myMetaData.remove((Object)entry.getKey());
            break;
        }
    }

    private static final class MetaDataKey
    extends Pair<String, String> {
        private static final StringInterner ourInterner = new WeakStringInterner();

        private MetaDataKey(@NotNull String[] categoryNames, @NotNull String familyName) {
            super((Object)StringUtil.join((String[])categoryNames, (String)":"), ourInterner.intern((Object)familyName));
        }
    }
}

