/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup.impl;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.completion.CompletionProcess;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.hint.EditorHintListener;
import com.intellij.codeInsight.lookup.LookupArranger;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.ui.LightweightHint;
import com.intellij.util.Alarm;
import com.intellij.util.BitUtil;
import com.intellij.util.messages.MessageBus;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.jetbrains.annotations.NotNull;

public class LookupManagerImpl
extends LookupManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.lookup.impl.LookupManagerImpl");
    private final Project myProject;
    private LookupImpl myActiveLookup = null;
    private Editor myActiveLookupEditor = null;
    private final PropertyChangeSupport myPropertyChangeSupport = new PropertyChangeSupport(this);
    public static final Key<Boolean> SUPPRESS_AUTOPOPUP_JAVADOC = Key.create((String)"LookupManagerImpl.suppressAutopopupJavadoc");

    public LookupManagerImpl(Project project, MessageBus bus) {
        this.myProject = project;
        bus.connect().subscribe(EditorHintListener.TOPIC, (Object)new EditorHintListener(){

            @Override
            public void hintShown(Project project, final @NotNull LightweightHint hint, int flags) {
                LookupEx lookup;
                if (project == LookupManagerImpl.this.myProject && (lookup = LookupManagerImpl.this.getActiveLookup()) != null && BitUtil.isSet((int)flags, (int)4)) {
                    lookup.addLookupListener(new LookupListener(){

                        public void currentItemChanged(@NotNull LookupEvent event) {
                            hint.hide();
                        }

                        public void itemSelected(@NotNull LookupEvent event) {
                            hint.hide();
                        }

                        public void lookupCanceled(@NotNull LookupEvent event) {
                            hint.hide();
                        }
                    });
                }
            }
        });
        bus.connect().subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
                LookupManagerImpl.this.hideActiveLookup();
            }

            public void exitDumbMode() {
                LookupManagerImpl.this.hideActiveLookup();
            }
        });
        EditorFactory.getInstance().addEditorFactoryListener(new EditorFactoryListener(){

            public void editorReleased(@NotNull EditorFactoryEvent event) {
                if (event.getEditor() == LookupManagerImpl.this.myActiveLookupEditor) {
                    LookupManagerImpl.this.hideActiveLookup();
                }
            }
        }, (Disposable)this.myProject);
    }

    @Override
    public LookupEx showLookup(@NotNull Editor editor, @NotNull LookupElement[] items, @NotNull String prefix, @NotNull LookupArranger arranger) {
        for (LookupElement item : items) {
            assert (item != null);
        }
        LookupImpl lookup = this.createLookup(editor, items, prefix, arranger);
        return lookup.showLookup() ? lookup : null;
    }

    @Override
    @NotNull
    public LookupImpl createLookup(@NotNull Editor editor, @NotNull LookupElement[] items, @NotNull String prefix, @NotNull LookupArranger arranger) {
        this.hideActiveLookup();
        final LookupImpl lookup = this.createLookup(editor, arranger, this.myProject);
        final Alarm alarm = new Alarm();
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myActiveLookup = lookup;
        this.myActiveLookupEditor = editor;
        this.myActiveLookup.addLookupListener(new LookupListener(){

            public void itemSelected(@NotNull LookupEvent event) {
                this.lookupClosed();
            }

            public void lookupCanceled(@NotNull LookupEvent event) {
                this.lookupClosed();
            }

            public void currentItemChanged(@NotNull LookupEvent event) {
                alarm.cancelAllRequests();
                CodeInsightSettings settings = CodeInsightSettings.getInstance();
                if (settings.AUTO_POPUP_JAVADOC_INFO && DocumentationManager.getInstance(LookupManagerImpl.this.myProject).getDocInfoHint() == null) {
                    alarm.addRequest(() -> LookupManagerImpl.this.showJavadoc(lookup), settings.JAVADOC_INFO_DELAY);
                }
            }

            private void lookupClosed() {
                ApplicationManager.getApplication().assertIsDispatchThread();
                alarm.cancelAllRequests();
                lookup.removeLookupListener(this);
            }
        });
        Disposer.register((Disposable)lookup, (Disposable)new Disposable(){

            public void dispose() {
                LookupManagerImpl.this.myActiveLookup = null;
                LookupManagerImpl.this.myActiveLookupEditor = null;
                LookupManagerImpl.this.myPropertyChangeSupport.firePropertyChange("activeLookup", lookup, null);
            }
        });
        CamelHumpMatcher matcher = new CamelHumpMatcher(prefix);
        if (items.length > 0) {
            for (LookupElement item : items) {
                this.myActiveLookup.addItem(item, matcher);
            }
            this.myActiveLookup.refreshUi(true, true);
        } else {
            alarm.cancelAllRequests();
        }
        this.myPropertyChangeSupport.firePropertyChange("activeLookup", null, this.myActiveLookup);
        return lookup;
    }

    private void showJavadoc(LookupImpl lookup) {
        if (this.myActiveLookup != lookup) {
            return;
        }
        DocumentationManager docManager = DocumentationManager.getInstance(this.myProject);
        if (docManager.getDocInfoHint() != null) {
            return;
        }
        LookupElement currentItem = lookup.getCurrentItem();
        CompletionProcess completion = CompletionService.getCompletionService().getCurrentCompletion();
        if (currentItem != null && currentItem.isValid() && this.isAutoPopupJavadocSupportedBy(currentItem) && completion != null) {
            try {
                boolean hideLookupWithDoc = completion.isAutopopupCompletion() || CodeInsightSettings.getInstance().JAVADOC_INFO_DELAY == 0;
                docManager.showJavaDocInfo(lookup.getEditor(), lookup.getPsiFile(), false, () -> {
                    if (hideLookupWithDoc && completion == CompletionService.getCompletionService().getCurrentCompletion()) {
                        this.hideActiveLookup();
                    }
                });
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
        }
    }

    protected boolean isAutoPopupJavadocSupportedBy(LookupElement lookupItem) {
        return lookupItem.getUserData(SUPPRESS_AUTOPOPUP_JAVADOC) == null;
    }

    @NotNull
    protected LookupImpl createLookup(@NotNull Editor editor, @NotNull LookupArranger arranger, Project project) {
        return new LookupImpl(project, editor, arranger);
    }

    @Override
    public void hideActiveLookup() {
        LookupImpl lookup = this.myActiveLookup;
        if (lookup != null) {
            lookup.checkValid();
            lookup.hide();
            LOG.assertTrue(lookup.isLookupDisposed(), (Object)"Should be disposed");
        }
    }

    @Override
    public LookupEx getActiveLookup() {
        if (this.myActiveLookup != null && this.myActiveLookup.isLookupDisposed()) {
            LookupImpl lookup = this.myActiveLookup;
            this.myActiveLookup = null;
            lookup.checkValid();
        }
        return this.myActiveLookup;
    }

    @Override
    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        this.myPropertyChangeSupport.addPropertyChangeListener(listener2);
    }

    @Override
    public void addPropertyChangeListener(final @NotNull PropertyChangeListener listener2, @NotNull Disposable disposable) {
        this.addPropertyChangeListener(listener2);
        Disposer.register((Disposable)disposable, (Disposable)new Disposable(){

            public void dispose() {
                LookupManagerImpl.this.removePropertyChangeListener(listener2);
            }
        });
    }

    @Override
    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        this.myPropertyChangeSupport.removePropertyChangeListener(listener2);
    }

    public void forceSelection(char completion, int index) {
        if (this.myActiveLookup == null) {
            throw new RuntimeException("There are no items in this lookup");
        }
        LookupElement lookupItem = this.myActiveLookup.getItems().get(index);
        this.myActiveLookup.setCurrentItem(lookupItem);
        this.myActiveLookup.finishLookup(completion);
    }

    public void forceSelection(char completion, LookupElement item) {
        this.myActiveLookup.setCurrentItem(item);
        this.myActiveLookup.finishLookup(completion);
    }

    public void clearLookup() {
        if (this.myActiveLookup != null) {
            this.myActiveLookup.hide();
            this.myActiveLookup = null;
        }
    }
}

