/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ListComponentUpdater;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageView;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BackgroundUpdaterTask
extends Task.Backgroundable {
    protected JBPopup myPopup;
    private ListComponentUpdater myUpdater;
    private Ref<? extends UsageView> myUsageView;
    private final Collection<PsiElement> myData;
    private final Alarm myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
    private final Object lock = new Object();
    private volatile boolean myCanceled;
    private volatile boolean myFinished;
    private volatile ProgressIndicator myIndicator;

    public BackgroundUpdaterTask(@Nullable Project project, @NotNull String title, @Nullable Comparator<PsiElement> comparator2) {
        super(project, title);
        this.myData = comparator2 == null ? ContainerUtil.newSmartList() : new TreeSet<PsiElement>(comparator2);
    }

    public ListComponentUpdater getUpdater() {
        return this.myUpdater;
    }

    public void init(@NotNull JBPopup popup2, @NotNull ListComponentUpdater updater, @NotNull Ref<? extends UsageView> usageView) {
        this.myPopup = popup2;
        this.myUpdater = updater;
        this.myUsageView = usageView;
    }

    public abstract String getCaption(int var1);

    protected void replaceModel(@NotNull List<? extends PsiElement> data) {
        this.myUpdater.replaceModel(data);
    }

    protected void paintBusy(boolean paintBusy) {
        this.myUpdater.paintBusy(paintBusy);
    }

    protected static Comparator<PsiElement> createComparatorWrapper(@NotNull Comparator<? super PsiElement> comparator2) {
        return (o1, o2) -> {
            int diff = comparator2.compare((PsiElement)o1, (PsiElement)o2);
            if (diff == 0) {
                return (Integer)ReadAction.compute(() -> PsiUtilCore.compareElementsByPosition((PsiElement)o1, (PsiElement)o2));
            }
            return diff;
        };
    }

    private boolean setCanceled() {
        boolean canceled = this.myCanceled;
        this.myCanceled = true;
        return canceled;
    }

    public boolean isCanceled() {
        return this.myCanceled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public boolean updateComponent(@NotNull PsiElement element, @Nullable Comparator comparator2) {
        UsageView view = (UsageView)this.myUsageView.get();
        if (view != null && !((UsageViewImpl)view).isDisposed()) {
            ApplicationManager.getApplication().runReadAction(() -> view.appendUsage((Usage)new UsageInfo2UsageAdapter(new UsageInfo(element))));
            return true;
        }
        if (this.myCanceled) {
            return false;
        }
        JComponent content = this.myPopup.getContent();
        if (this.myPopup instanceof AbstractPopup && content == null || this.myPopup.isDisposed()) {
            return false;
        }
        ModalityState modalityState = content == null ? null : ModalityState.stateForComponent((Component)content);
        Object object = this.lock;
        synchronized (object) {
            if (this.myData.contains(element)) {
                return true;
            }
            this.myData.add(element);
            if (comparator2 != null && this.myData instanceof List) {
                Collections.sort((List)this.myData, comparator2);
            }
        }
        this.myAlarm.addRequest(() -> {
            this.myAlarm.cancelAllRequests();
            this.refreshModelImmediately();
        }, 200, modalityState);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateComponent(@NotNull PsiElement element) {
        UsageView view = (UsageView)this.myUsageView.get();
        if (view != null && !((UsageViewImpl)view).isDisposed()) {
            ApplicationManager.getApplication().runReadAction(() -> view.appendUsage((Usage)new UsageInfo2UsageAdapter(new UsageInfo(element))));
            return true;
        }
        if (this.myCanceled) {
            return false;
        }
        JComponent content = this.myPopup.getContent();
        if (content == null || this.myPopup.isDisposed()) {
            return false;
        }
        Object object = this.lock;
        synchronized (object) {
            if (!this.myData.add(element)) {
                return true;
            }
        }
        this.myAlarm.addRequest(() -> {
            this.myAlarm.cancelAllRequests();
            this.refreshModelImmediately();
        }, 200, ModalityState.stateForComponent((Component)content));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshModelImmediately() {
        ArrayList<PsiElement> data;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myCanceled) {
            return;
        }
        if (this.myPopup.isDisposed()) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            data = new ArrayList<PsiElement>(this.myData);
        }
        this.replaceModel(data);
        this.myPopup.setCaption(this.getCaption(this.getCurrentSize()));
        this.myPopup.pack(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurrentSize() {
        Object object = this.lock;
        synchronized (object) {
            return this.myData.size();
        }
    }

    public void run(@NotNull ProgressIndicator indicator) {
        this.paintBusy(true);
        this.myIndicator = indicator;
    }

    public void onSuccess() {
        this.myFinished = true;
        this.refreshModelImmediately();
        this.paintBusy(false);
    }

    public void onFinished() {
        this.myAlarm.cancelAllRequests();
        this.myFinished = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected PsiElement getTheOnlyOneElement() {
        Object object = this.lock;
        synchronized (object) {
            if (this.myData.size() == 1) {
                return this.myData.iterator().next();
            }
        }
        return null;
    }

    public boolean isFinished() {
        return this.myFinished;
    }

    public boolean cancelTask() {
        ProgressIndicator indicator = this.myIndicator;
        if (indicator != null) {
            indicator.cancel();
        }
        return this.setCanceled();
    }
}

